/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.AggregateEntriesSpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.AggregateEntriesSpaceOperationResult;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.operations.AbstractSpaceOperation;
import com.gigaspaces.query.aggregators.AggregationInternalUtils;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.utils.CodeChangeUtilities;

@InternalApi
public class AggregateEntriesSpaceOperation
extends AbstractSpaceOperation<AggregateEntriesSpaceOperationResult, AggregateEntriesSpaceOperationRequest> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(AggregateEntriesSpaceOperationRequest request, AggregateEntriesSpaceOperationResult result, SpaceImpl space, boolean oneway) throws Exception {
        try {
            SpaceAuthority.SpacePrivilege requiredPrivilege = AggregationInternalUtils.containsCustomAggregators(request.getAggregators()) ? SpaceAuthority.SpacePrivilege.EXECUTE : SpaceAuthority.SpacePrivilege.READ;
            space.beginPacketOperation(true, request.getSpaceContext(), requiredPrivilege, request.getQueryPacket());
            space.getEngine().aggregate(request.getQueryPacket(), request.getAggregators(), request.getReadModifiers(), request.getSpaceContext());
            Object[] intermediateResults = new Object[request.getAggregators().size()];
            for (int i = 0; i < intermediateResults.length; ++i) {
                intermediateResults[i] = request.getAggregators().get(i).getIntermediateResult();
            }
            result.setIntermediateResults(intermediateResults);
        }
        finally {
            CodeChangeUtilities.removeOneTimeClassLoaderIfNeeded(request.getAggregators());
        }
    }

    @Override
    public String getLogName(AggregateEntriesSpaceOperationRequest request, AggregateEntriesSpaceOperationResult result) {
        return "scan";
    }
}

