/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ChangeException;
import com.gigaspaces.client.ChangeResult;
import com.gigaspaces.client.CustomChangeOperation;
import com.gigaspaces.client.FailedChangedEntryDetails;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.client.ChangeDetailedResultImpl;
import com.gigaspaces.internal.client.ChangeEntryDetailsImpl;
import com.gigaspaces.internal.client.ChangeResultImpl;
import com.gigaspaces.internal.client.FailedChangedEntryDetailsImpl;
import com.gigaspaces.internal.client.spaceproxy.operations.ChangeEntriesSpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.ChangeEntriesSpaceOperationResult;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.operations.AbstractSpaceOperation;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.lrmi.nio.IResponseContext;
import com.gigaspaces.lrmi.nio.ResponseContext;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.utils.CodeChangeUtilities;
import com.j_spaces.core.ExtendedAnswerHolder;
import com.j_spaces.core.client.Modifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@InternalApi
public class ChangeEntriesSpaceOperation
extends AbstractSpaceOperation<ChangeEntriesSpaceOperationResult, ChangeEntriesSpaceOperationRequest> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ChangeEntriesSpaceOperationRequest request, ChangeEntriesSpaceOperationResult result, SpaceImpl space, boolean oneway) throws Exception {
        try {
            boolean byId;
            IResponseContext respContext = ResponseContext.getResponseContext();
            if (respContext != null) {
                respContext.setInvokedFromNewRouter(true);
            }
            SpaceAuthority.SpacePrivilege requiredPrivilege = ChangeEntriesSpaceOperation.getRequiredPrivilege(request.getMutators());
            space.beginPacketOperation(true, request.getSpaceContext(), requiredPrivilege, request.getTemplatePacket());
            ExtendedAnswerHolder answerHolder = space.getEngine().change(request.getTemplatePacket(), request.getTransaction(), request.getLease(), request.getTimeout(), request.getSpaceContext(), false, true, request.getMutators(), request.getModifiers(), false);
            String uid = request.getTemplatePacket().getUID();
            boolean bl = byId = uid != null || request.getTemplatePacket().getID() != null && request.getTemplatePacket().getExtendedMatchCodes() == null && request.getTemplatePacket().getCustomQuery() == null;
            if (byId) {
                ChangeEntriesSpaceOperation.setResult(result, answerHolder, request.getModifiers(), uid);
            } else {
                ChangeEntriesSpaceOperation.setMultipleEntriesResult(result, answerHolder, request.getModifiers());
            }
            if (Modifiers.contains(request.getModifiers(), 0x4000000)) {
                result.setNumOfEntriesMatched(answerHolder.getNumOfEntriesMatched());
            }
        }
        finally {
            CodeChangeUtilities.removeOneTimeClassLoaderIfNeeded(request.getMutators());
        }
    }

    private static SpaceAuthority.SpacePrivilege getRequiredPrivilege(Collection<SpaceEntryMutator> mutators) {
        for (SpaceEntryMutator spaceEntryMutator : mutators) {
            if (!(spaceEntryMutator instanceof CustomChangeOperation)) continue;
            return SpaceAuthority.SpacePrivilege.EXECUTE;
        }
        return SpaceAuthority.SpacePrivilege.WRITE;
    }

    public static void setResult(ChangeEntriesSpaceOperationResult result, ExtendedAnswerHolder answerHolder, int modifiers, Object templateUid) {
        Exception exception = answerHolder.getException();
        IEntryData modifiedEntryData = answerHolder.getModifiedEntryData();
        IEntryData rejectedEntry = answerHolder.getRejectedEntry();
        boolean isDetailedResult = Modifiers.contains(modifiers, 0x2000000);
        ChangeResult<Object> resultImpl = null;
        if (modifiedEntryData != null) {
            if (isDetailedResult) {
                Object idValue = ChangeEntriesSpaceOperation.extractId(templateUid, modifiedEntryData);
                resultImpl = new ChangeDetailedResultImpl(new ChangeEntryDetailsImpl(modifiedEntryData.getSpaceTypeDescriptor().getTypeName(), idValue, modifiedEntryData.getVersion(), answerHolder.getChangeResults()));
            } else {
                resultImpl = ChangeResultImpl.SINGLE;
            }
        } else if (rejectedEntry != null) {
            Object idValue = ChangeEntriesSpaceOperation.extractId(templateUid, rejectedEntry);
            FailedChangedEntryDetailsImpl failedChangeResult = new FailedChangedEntryDetailsImpl(rejectedEntry.getSpaceTypeDescriptor().getTypeName(), idValue, rejectedEntry.getVersion(), exception);
            List<FailedChangedEntryDetails> entriesFailedToChange = Collections.singletonList(failedChangeResult);
            result.setExecutionException(new ChangeException("Failed changing entry in space - " + exception.getMessage(), Collections.EMPTY_LIST, entriesFailedToChange, (Collection<Throwable>)Collections.EMPTY_LIST));
        } else if (exception != null) {
            result.setExecutionException(new ChangeException("Failed changing entry in space - " + exception.getMessage(), Collections.EMPTY_LIST, (Collection<FailedChangedEntryDetails>)Collections.EMPTY_LIST, Collections.singletonList(exception)));
        } else {
            resultImpl = isDetailedResult ? ChangeDetailedResultImpl.EMPTY : ChangeResultImpl.EMPTY;
        }
        result.setChangeResult(resultImpl);
    }

    public static void setMultipleEntriesResult(ChangeEntriesSpaceOperationResult result, ExtendedAnswerHolder answerHolder, int modifiers) {
        Exception exception = answerHolder.getException();
        boolean isDetailedResult = Modifiers.contains(modifiers, 0x2000000);
        ArrayList changedEntries = Collections.EMPTY_LIST;
        if (answerHolder.anyChangedEntriesForMultipleOperation() && isDetailedResult) {
            changedEntries = new ArrayList(answerHolder.getModifiedEntriesData().size());
            for (int i = 0; i < answerHolder.getModifiedEntriesData().size(); ++i) {
                IEntryData ed = answerHolder.getModifiedEntriesData().get(i);
                List results = answerHolder.getChangeResults() != null ? (List)answerHolder.getChangeResults().get(i) : null;
                changedEntries.add(new ChangeEntryDetailsImpl(ed.getSpaceTypeDescriptor().getTypeName(), ChangeEntriesSpaceOperation.extractId(answerHolder.getModifiedEntriesUids().get(i), ed), ed.getVersion(), results));
            }
        }
        ArrayList<FailedChangedEntryDetails> rejectedEntries = Collections.EMPTY_LIST;
        if (answerHolder.anyRejectedEntriesForMultipleOperation()) {
            rejectedEntries = new ArrayList<FailedChangedEntryDetails>(answerHolder.getRejectedEntries().size());
            for (int i = 0; i < answerHolder.getRejectedEntries().size(); ++i) {
                IEntryData ed = answerHolder.getRejectedEntries().get(i);
                rejectedEntries.add(new FailedChangedEntryDetailsImpl(ed.getSpaceTypeDescriptor().getTypeName(), ChangeEntriesSpaceOperation.extractId(answerHolder.getRejectedEntriesUids().get(i), ed), ed.getVersion(), answerHolder.getRejectedCause().get(i)));
            }
        }
        ChangeResult<Object> resultImpl = null;
        if (exception != null) {
            if (isDetailedResult) {
                result.setExecutionException(new ChangeException(" Failed changing entry in space  -  " + exception.getMessage(), changedEntries, rejectedEntries, Collections.singletonList(exception)));
            } else {
                result.setExecutionException(new ChangeException("Failed changing entry in space  - " + exception.getMessage(), answerHolder.getNumChangedEntriesForMultipleOperation(), rejectedEntries, Collections.singletonList(exception)));
            }
        } else if (!rejectedEntries.isEmpty()) {
            if (isDetailedResult) {
                result.setExecutionException(new ChangeException("Failed to change some entries in space  ", changedEntries, rejectedEntries, (Collection<Throwable>)Collections.EMPTY_LIST));
            } else {
                result.setExecutionException(new ChangeException("Failed to change some entries in space  ", answerHolder.getNumChangedEntriesForMultipleOperation(), rejectedEntries, (Collection<Throwable>)Collections.EMPTY_LIST));
            }
        } else {
            int size;
            resultImpl = answerHolder.anyChangedEntriesForMultipleOperation() ? (isDetailedResult ? new ChangeDetailedResultImpl(changedEntries) : ((size = answerHolder.getModifiedEntriesData().size()) == 1 ? ChangeResultImpl.SINGLE : new ChangeResultImpl(size))) : (isDetailedResult ? ChangeDetailedResultImpl.EMPTY : ChangeResultImpl.EMPTY);
        }
        result.setChangeResult(resultImpl);
    }

    private static Object extractId(Object templateId, IEntryData entryData) {
        Object idValue = entryData.getPropertyValue(entryData.getSpaceTypeDescriptor().getIdPropertyName());
        if (idValue == null && ((ITypeDesc)entryData.getSpaceTypeDescriptor()).isAutoGenerateId()) {
            idValue = templateId;
        }
        return idValue;
    }

    @Override
    public String getLogName(ChangeEntriesSpaceOperationRequest request, ChangeEntriesSpaceOperationResult result) {
        return "change";
    }
}

