/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.RemoteOperationResult;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.operations.AbortPreparedTransactionSpaceOperation;
import com.gigaspaces.internal.server.space.operations.AbstractSpaceOperation;
import com.gigaspaces.internal.server.space.operations.AddEntryTypeIndexesSpaceOperation;
import com.gigaspaces.internal.server.space.operations.AggregateEntriesSpaceOperation;
import com.gigaspaces.internal.server.space.operations.ChangeEntriesSpaceOperation;
import com.gigaspaces.internal.server.space.operations.CommitPreparedTransactionSpaceOperation;
import com.gigaspaces.internal.server.space.operations.CountClearEntriesSpaceOperation;
import com.gigaspaces.internal.server.space.operations.ExecuteTaskSpaceOperation;
import com.gigaspaces.internal.server.space.operations.GetEntryTypeDescriptorSpaceOperation;
import com.gigaspaces.internal.server.space.operations.PrepareAndCommitTransactionSpaceOperation;
import com.gigaspaces.internal.server.space.operations.ReadTakeEntriesByIdsSpaceOperation;
import com.gigaspaces.internal.server.space.operations.ReadTakeEntriesSpaceOperation;
import com.gigaspaces.internal.server.space.operations.ReadTakeEntriesUidsSpaceOperation;
import com.gigaspaces.internal.server.space.operations.ReadTakeEntrySpaceOperation;
import com.gigaspaces.internal.server.space.operations.RegisterEntriesListenerSpaceOperation;
import com.gigaspaces.internal.server.space.operations.RegisterEntryTypeDescriptorSpaceOperation;
import com.gigaspaces.internal.server.space.operations.RegisterLocalViewSpaceOperation;
import com.gigaspaces.internal.server.space.operations.UnregisterLocalViewSpaceOperation;
import com.gigaspaces.internal.server.space.operations.UpdateLeaseSpaceOperation;
import com.gigaspaces.internal.server.space.operations.UpdateLeasesSpaceOperation;
import com.gigaspaces.internal.server.space.operations.WriteEntriesSpaceOperation;
import com.gigaspaces.internal.server.space.operations.WriteEntrySpaceOperation;
import com.j_spaces.core.exception.ClosedResourceException;
import java.rmi.RemoteException;
import java.util.logging.Level;

@InternalApi
public class SpaceOperationsExecutor {
    private final AbstractSpaceOperation<?, ?>[] _operations;

    public SpaceOperationsExecutor() {
        this._operations = new AbstractSpaceOperation[23];
        this._operations[0] = new ExecuteTaskSpaceOperation();
        this._operations[1] = new AbortPreparedTransactionSpaceOperation();
        this._operations[2] = new CommitPreparedTransactionSpaceOperation();
        this._operations[3] = new PrepareAndCommitTransactionSpaceOperation();
        this._operations[6] = new GetEntryTypeDescriptorSpaceOperation();
        this._operations[7] = new RegisterEntryTypeDescriptorSpaceOperation();
        this._operations[8] = new AddEntryTypeIndexesSpaceOperation();
        this._operations[4] = new UpdateLeaseSpaceOperation();
        this._operations[5] = new UpdateLeasesSpaceOperation();
        this._operations[9] = new WriteEntrySpaceOperation();
        this._operations[10] = new WriteEntriesSpaceOperation();
        this._operations[11] = new ReadTakeEntrySpaceOperation();
        this._operations[12] = new ReadTakeEntriesSpaceOperation();
        this._operations[13] = new ReadTakeEntriesByIdsSpaceOperation();
        this._operations[14] = new ReadTakeEntriesUidsSpaceOperation();
        this._operations[15] = new CountClearEntriesSpaceOperation();
        this._operations[16] = new RegisterEntriesListenerSpaceOperation();
        this._operations[17] = new ChangeEntriesSpaceOperation();
        this._operations[18] = new RegisterLocalViewSpaceOperation();
        this._operations[19] = new UnregisterLocalViewSpaceOperation();
        this._operations[20] = new AggregateEntriesSpaceOperation();
    }

    public SpaceOperationsExecutor(AbstractSpaceOperation<?, ?>[] operations) {
        this._operations = operations;
    }

    public <T extends RemoteOperationResult> T executeOperation(RemoteOperationRequest<T> request, SpaceImpl space, boolean oneway) {
        int operationCode = request.getOperationCode();
        if (operationCode < 0 || operationCode >= this._operations.length) {
            throw new UnsupportedOperationException("Unsupported space operation code: " + operationCode + ", request class: " + request.getClass().getName());
        }
        AbstractSpaceOperation<?, ?> operation = this._operations[operationCode];
        T result = request.createRemoteOperationResult();
        try {
            boolean loggable;
            boolean bl = loggable = operation.isGenericLogging() && space.getOperationLogger().isLoggable(Level.FINEST);
            if (loggable) {
                space.getOperationLogger().finest("executing " + operation.getLogName(request, result) + " operation" + (oneway ? "(oneway)" : "") + " [" + request + "]");
            }
            operation.execute(request, result, space, oneway);
            if (loggable) {
                space.getOperationLogger().finest("operation " + operation.getLogName(request, result) + " executed" + (oneway ? "(oneway)" : "") + " [" + request + "] result [" + result + "]");
            }
        }
        catch (ClosedResourceException e) {
            result.setExecutionException(new RemoteException(e.getMessage(), e));
        }
        catch (Exception e) {
            result.setExecutionException(e);
        }
        return result;
    }
}

