/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.space.operations.WriteEntryResult;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class WriteEntriesResult
implements Externalizable,
Textualizable {
    private static final long serialVersionUID = 1L;
    private WriteEntryResult[] _results;
    private Exception[] _errors;

    public WriteEntriesResult() {
    }

    public WriteEntriesResult(int length) {
        this._results = new WriteEntryResult[length];
    }

    public int getSize() {
        return this._results.length;
    }

    public void setResult(int i, WriteEntryResult result) {
        this._results[i] = result;
    }

    public boolean isError(int i) {
        return this._errors != null && this._errors[i] != null;
    }

    public void setError(int i, Exception exception) {
        if (this._errors == null) {
            this._errors = new Exception[this._results.length];
        }
        this._errors[i] = exception;
    }

    public Exception[] getErrors() {
        return this._errors;
    }

    public WriteEntryResult[] getResults() {
        return this._results;
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("results", this._results);
        textualizer.append("errors", this._errors);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this._results);
        IOUtils.writeObject(out, this._errors);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._results = (WriteEntryResult[])IOUtils.readObject(in);
        this._errors = (Exception[])IOUtils.readObject(in);
    }
}

