/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.LeaseInitializer;
import com.j_spaces.core.LeaseProxy;
import com.j_spaces.core.client.UpdateModifiers;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class WriteEntryResult
implements Externalizable,
Textualizable {
    private static final long serialVersionUID = 1L;
    private static final boolean ReturnPrevOnUpdate = Boolean.getBoolean("com.gigaspaces.client.returnPrevOnUpdate");
    private String _uid;
    private int _version;
    private long _expiration;
    private IEntryPacket _prevEntry;
    private int syncReplicationLevel;
    private static final short FLAG_UID = 1;
    private static final short FLAG_VERSION = 2;
    private static final short FLAG_EXPIRATION = 4;
    private static final short FLAG_PREV_ENTRY = 8;
    private static final short FLAG_SYNC_REPLICATION_LEVEL = 16;
    private static final int DEFAULT_VERSION = 1;
    private static final long DEFAULT_EXPIRATION = Long.MAX_VALUE;

    public WriteEntryResult() {
    }

    public WriteEntryResult(String uid, int version, long expiration) {
        this._uid = uid;
        this._version = version;
        this._expiration = expiration;
    }

    public WriteEntryResult(IEntryPacket entryPacket) {
        this._uid = entryPacket.getUID();
        this._version = entryPacket.getVersion();
        this._prevEntry = entryPacket;
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    public void setSyncReplicationLevel(int syncReplicationLevel) {
        this.syncReplicationLevel = syncReplicationLevel;
    }

    public int getSyncReplicationLevel() {
        return this.syncReplicationLevel;
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("uid", this._uid);
        textualizer.append("version", this._version);
        textualizer.append("expiration", this._expiration);
    }

    public String getUid() {
        return this._uid;
    }

    public void removeRedundantData(ITypeDesc typeDesc, int modifiers) {
        if (this._version > 1 || StringUtils.hasLength(typeDesc.getIdPropertyName()) && !typeDesc.isAutoGenerateId()) {
            this._uid = null;
        }
        if (ReturnPrevOnUpdate) {
            if (UpdateModifiers.isNoReturnValue(modifiers)) {
                this._prevEntry = null;
            }
        } else if (!UpdateModifiers.isReturnPrevOnUpdate(modifiers)) {
            this._prevEntry = null;
        }
    }

    public int getVersion() {
        return this._version;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public IEntryPacket getPrevEntry() {
        return this._prevEntry;
    }

    public void setPrevEntry(IEntryPacket prevEntry) {
        this._prevEntry = prevEntry;
    }

    public LeaseContext<?> createLease(String typeName, SpaceImpl spaceImpl, boolean noWriteLease) {
        if (this._expiration == 0L) {
            if (this._prevEntry != null) {
                return LeaseInitializer.createDummyLease(this._uid, this._version, this._prevEntry);
            }
            return LeaseInitializer.createDummyLease(this._uid, this._version);
        }
        if (noWriteLease) {
            return LeaseInitializer.createDummyLease(this._uid, this._version, this._prevEntry);
        }
        LeaseProxy result = new LeaseProxy(this._expiration, this._uid, typeName, this._version, 1, spaceImpl);
        result.setObject(this._prevEntry);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        short flags = this.buildFlags();
        out.writeShort(flags);
        if (flags != 0) {
            if (this._uid != null) {
                IOUtils.writeString(out, this._uid);
            }
            if (this._version != 1) {
                out.writeInt(this._version);
            }
            if (this._expiration != Long.MAX_VALUE) {
                out.writeLong(this._expiration);
            }
            if (this._prevEntry != null) {
                IOUtils.writeObject(out, this._prevEntry);
            }
            if (0 < this.syncReplicationLevel) {
                out.writeInt(this.syncReplicationLevel);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._uid = IOUtils.readString(in);
            }
            this._version = (flags & 2) != 0 ? in.readInt() : 1;
            long l = this._expiration = (flags & 4) != 0 ? in.readLong() : Long.MAX_VALUE;
            if ((flags & 8) != 0) {
                this._prevEntry = (IEntryPacket)IOUtils.readObject(in);
            }
            this.syncReplicationLevel = (flags & 0x10) != 0 ? in.readInt() : 0;
        } else {
            this._version = 1;
            this._expiration = Long.MAX_VALUE;
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._uid != null) {
            flags = (short)(flags | 1);
        }
        if (this._version != 1) {
            flags = (short)(flags | 2);
        }
        if (this._expiration != Long.MAX_VALUE) {
            flags = (short)(flags | 4);
        }
        if (this._prevEntry != null) {
            flags = (short)(flags | 8);
        }
        if (0 < this.syncReplicationLevel) {
            flags = (short)(flags | 0x10);
        }
        return flags;
    }
}

