/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.quiesce;

import com.gigaspaces.admin.quiesce.QuiesceException;
import com.gigaspaces.admin.quiesce.QuiesceState;
import com.gigaspaces.admin.quiesce.QuiesceStateChangedEvent;
import com.gigaspaces.admin.quiesce.QuiesceToken;
import com.gigaspaces.admin.quiesce.QuiesceTokenFactory;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.suspend.SuspendTypeChangedInternalListener;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.gigaspaces.server.space.suspend.SuspendInfo;
import com.gigaspaces.server.space.suspend.SuspendType;
import java.io.Closeable;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class QuiesceHandler {
    private static final boolean QUIESCE_DISABLED = Boolean.getBoolean("com.gs.engine.disableQuiesceMode");
    private final Logger _logger;
    private final SpaceImpl _spaceImpl;
    private final boolean _supported;
    private volatile Guard _guard;
    private volatile SuspendInfo _suspendInfo;
    private final Collection<SuspendTypeChangedInternalListener> suspendTypeChangeListeners = new ConcurrentHashSet<SuspendTypeChangedInternalListener>();

    public QuiesceHandler(SpaceImpl spaceImpl, QuiesceStateChangedEvent quiesceStateChangedEvent) {
        this._spaceImpl = spaceImpl;
        this._logger = Logger.getLogger("com.gigaspaces.suspend." + spaceImpl.getNodeName());
        this._supported = !QUIESCE_DISABLED && !this._spaceImpl.isLocalCache();
        this._guard = null;
        this.setSuspendInfo(new SuspendInfo(SuspendType.NONE));
        if (quiesceStateChangedEvent != null && quiesceStateChangedEvent.getQuiesceState() == QuiesceState.QUIESCED) {
            this.setQuiesceMode(quiesceStateChangedEvent);
        }
    }

    public boolean isOn() {
        Guard currGuard = this._guard;
        return currGuard != null;
    }

    public SuspendInfo getSuspendInfo() {
        return this._suspendInfo;
    }

    public boolean isSuspended() {
        Guard currGuard = this._guard;
        return this.hasGuard(currGuard, Status.DISCONNECTED);
    }

    public boolean isQuiesced() {
        Guard currGuard = this._guard;
        return this.hasGuard(currGuard, Status.QUIESCED);
    }

    public void checkAllowedOp(QuiesceToken operationToken) {
        Guard currGuard;
        if (this._supported && (currGuard = this._guard) != null) {
            currGuard.guard(operationToken);
        }
    }

    public void setQuiesceMode(QuiesceStateChangedEvent newQuiesceInfo) {
        if (newQuiesceInfo.getQuiesceState() == QuiesceState.QUIESCED) {
            this.quiesce(newQuiesceInfo.getDescription(), newQuiesceInfo.getToken());
        } else {
            this.unquiesce();
        }
    }

    public void quiesceDemote(String description) {
        Guard guard = new Guard(description, null, Status.DEMOTING);
        if (this.addGuard(guard) && this._spaceImpl.getEngine() != null) {
            this._spaceImpl.getEngine().getTemplateScanner().cancelAllNonNotifyTemplates(this._guard.exception);
        }
    }

    public void quiesce(String description, QuiesceToken token) {
        if (this.addGuard(new Guard(description, token, Status.QUIESCED)) && this._spaceImpl.getEngine() != null) {
            this._spaceImpl.getEngine().getTemplateScanner().cancelAllNonNotifyTemplates(this._guard.exception);
        }
    }

    public void unquiesce() {
        this.removeGuard(Status.QUIESCED);
    }

    public void unquiesceDemote() {
        this.removeGuard(Status.DEMOTING);
    }

    public void suspend(String description) {
        this.addGuard(new Guard(description, this.createSpaceNameToken(), Status.DISCONNECTED));
    }

    public void unsuspend() {
        this.removeGuard(Status.DISCONNECTED);
    }

    public boolean isSupported() {
        return this._supported;
    }

    public QuiesceToken createSpaceNameToken() {
        return QuiesceTokenFactory.createStringToken(this._spaceImpl.getName());
    }

    private static String desc(Guard guard) {
        if (guard == null) {
            return "NONE";
        }
        return guard.status.suspendType.name();
    }

    private boolean hasGuard(Guard currentGuard, Status status) {
        if (currentGuard == null) {
            return false;
        }
        return currentGuard.status.equals((Object)status) || this.hasGuard(currentGuard.innerGuard, status);
    }

    private Guard getGuard(Guard currentGuard, Status status) {
        if (currentGuard == null) {
            return null;
        }
        if (currentGuard.status.equals((Object)status)) {
            return currentGuard;
        }
        return this.getGuard(currentGuard.innerGuard, status);
    }

    synchronized boolean addGuard(Guard newGuard) {
        if (!this._supported) {
            if (QUIESCE_DISABLED) {
                this._logger.severe("Suspend is not supported because the 'com.gs.engine.disableQuiesceMode' was set");
            }
            if (this._spaceImpl.isLocalCache()) {
                this._logger.severe("Suspend is not supported for local-cache/local-view");
            }
            return false;
        }
        if (this.hasGuard(this._guard, newGuard.status)) {
            this._logger.warning("Suspend guard [" + (Object)((Object)newGuard.status) + "] was discarded, it already exists - current state is " + QuiesceHandler.desc(this._guard));
            return false;
        }
        if (!this.guardCanBeAdded(this._guard, newGuard)) {
            this._logger.warning("Suspend guard couldn't be added - current state is " + QuiesceHandler.desc(this._guard));
            return false;
        }
        try {
            Guard prevGuard = this._guard;
            this._guard = this.addGuardHelper(this._guard, newGuard);
            if (prevGuard == this._guard) {
                this._logger.info("Suspend guard " + QuiesceHandler.desc(newGuard) + " was added, but is currently masked because state is " + QuiesceHandler.desc(this._guard));
            } else {
                this._logger.info("Suspend state set to " + QuiesceHandler.desc(this._guard));
            }
            if (this._guard != null) {
                this.setSuspendInfo(new SuspendInfo(this._guard.status.suspendType));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean guardCanBeAdded(Guard current, Guard newGuard) {
        if (current == null) {
            return true;
        }
        if (current.supersedes(newGuard) || newGuard.supersedes(current)) {
            return this.guardCanBeAdded(current.innerGuard, newGuard);
        }
        return false;
    }

    private Guard addGuardHelper(Guard currentGuard, Guard newGuard) throws Exception {
        Guard res;
        if (currentGuard == null) {
            res = newGuard;
        } else if (currentGuard.supersedes(newGuard)) {
            res = currentGuard;
            res.innerGuard = this.addGuardHelper(currentGuard.innerGuard, newGuard);
        } else if (newGuard.supersedes(currentGuard)) {
            res = newGuard;
            res.innerGuard = this.addGuardHelper(currentGuard.innerGuard, currentGuard);
        } else {
            throw new Exception("Guard could not be added due to ambiguity");
        }
        return res;
    }

    synchronized void removeGuard(Status status) {
        if (this._guard == null) {
            this._logger.warning("No guard to remove");
            return;
        }
        Guard guardToRemove = this.getGuard(this._guard, status);
        if (guardToRemove == null) {
            this._logger.warning("No " + (Object)((Object)status) + " guard to remove");
            return;
        }
        guardToRemove.close();
        this._guard = this.removeGuardHelper(this._guard, status);
        this._logger.info("Removed " + (Object)((Object)status) + ", new state is " + QuiesceHandler.desc(this._guard));
        if (this._guard != null) {
            this.setSuspendInfo(new SuspendInfo(this._guard.status.suspendType));
        } else {
            this.setSuspendInfo(new SuspendInfo(SuspendType.NONE));
        }
    }

    private Guard removeGuardHelper(Guard guard, Status status) {
        if (guard.status.equals((Object)status)) {
            return guard.innerGuard;
        }
        guard.innerGuard = this.removeGuardHelper(guard.innerGuard, status);
        return guard;
    }

    private void setSuspendInfo(SuspendInfo suspendInfo) {
        boolean isSuspendTypeChanged = true;
        if (this._suspendInfo != null && this._suspendInfo.getSuspendType().equals((Object)suspendInfo.getSuspendType())) {
            isSuspendTypeChanged = false;
        }
        this._suspendInfo = suspendInfo;
        if (isSuspendTypeChanged) {
            for (SuspendTypeChangedInternalListener listener : this.suspendTypeChangeListeners) {
                try {
                    listener.onSuspendTypeChanged(suspendInfo.getSuspendType());
                }
                catch (Exception e) {
                    this._logger.log(Level.WARNING, "Failed to dispatch suspendInfo event to listener [" + listener + "]: " + e.getMessage(), e);
                }
            }
        }
    }

    public void addSpaceSuspendTypeListener(SuspendTypeChangedInternalListener listener) {
        this.suspendTypeChangeListeners.add(listener);
    }

    public void removeSpaceSuspendTypeListener(SuspendTypeChangedInternalListener listener) {
        this.suspendTypeChangeListeners.remove(listener);
    }

    Guard getGuard() {
        return this._guard;
    }

    protected class Guard
    implements Closeable {
        private final QuiesceException exception;
        private final QuiesceToken token;
        private final Status status;
        private final CountDownLatch suspendLatch;
        private Guard innerGuard;

        Guard(String description, QuiesceToken token, Status status) {
            this.token = token != null ? token : EmptyToken.INSTANCE;
            this.status = status;
            this.suspendLatch = status == Status.DISCONNECTED ? new CountDownLatch(1) : null;
            String errorMessage = "Operation cannot be executed - space [" + QuiesceHandler.this._spaceImpl.getServiceName() + "] is " + status.description + (StringUtils.hasLength(description) ? " (" + description + ")" : "");
            this.exception = new QuiesceException(errorMessage);
        }

        void guard(QuiesceToken operationToken) {
            if (!this.token.equals(operationToken)) {
                if (this.suspendLatch != null && this.safeAwait()) {
                    this.safeSleep(new Random().nextInt(1000));
                    return;
                }
                throw this.exception;
            }
        }

        boolean supersedes(Guard otherGuard) {
            return this.status.supersedes(otherGuard.status);
        }

        @Override
        public void close() {
            if (this.suspendLatch != null) {
                this.suspendLatch.countDown();
            }
        }

        private boolean safeAwait() {
            try {
                return this.suspendLatch.await(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return this.suspendLatch.getCount() == 0L;
            }
        }

        private void safeSleep(long millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public String toString() {
            return "Guard{status=" + (Object)((Object)this.status) + ", innerGuard=" + this.innerGuard + '}';
        }

        Status getStatus() {
            return this.status;
        }

        Guard getInnerGuard() {
            return this.innerGuard;
        }
    }

    protected static enum Status {
        DISCONNECTED(0, "disconnected", SuspendType.DISCONNECTED),
        DEMOTING(1, "demoting", SuspendType.DEMOTING),
        QUIESCED(2, "quiesced", SuspendType.QUIESCED);

        private int order;
        private String description;
        private SuspendType suspendType;

        private Status(int order, String description, SuspendType suspendType) {
            this.order = order;
            this.description = description;
            this.suspendType = suspendType;
        }

        private boolean supersedes(Status other) {
            return this.order < other.order;
        }
    }

    private static class EmptyToken
    implements QuiesceToken {
        public static final EmptyToken INSTANCE = new EmptyToken();

        private EmptyToken() {
        }

        public boolean equals(Object obj) {
            return false;
        }
    }
}

