/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.recovery;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.recovery.strategy.AllInCacheCentralDBBackupSpaceRecovery;
import com.gigaspaces.internal.server.space.recovery.strategy.LRUCentralDBBackupSpaceRecovery;
import com.gigaspaces.internal.server.space.recovery.strategy.NonCentralDBBackupSpaceRecovery;
import com.gigaspaces.internal.server.space.recovery.strategy.NonPrimaryBackupSpaceRecovery;
import com.gigaspaces.internal.server.space.recovery.strategy.PrimarySpaceRecovery;
import com.gigaspaces.internal.server.space.recovery.strategy.SpaceRecoverStrategy;
import com.j_spaces.core.SpaceRecoveryException;

@InternalApi
public class RecoveryManager {
    public static final int RECOVERY_RETRIES = 3;
    public SpaceImpl _space;

    public RecoveryManager(SpaceImpl space) {
        this._space = space;
    }

    public SpaceRecoverStrategy getBackupSpaceRecovery() {
        boolean isCentralDB = this._space.getEngine().getCacheManager().isCentralDB();
        int cachePolicy = Integer.parseInt(this._space.getEngine().getConfigReader().getSpaceProperty("engine.cache_policy", this._space.getJspaceAttr().isPersistent() ? String.valueOf(0) : String.valueOf(1)));
        if (isCentralDB || this._space.getEngine().getCacheManager().isBlobStoreCachePolicy()) {
            if (cachePolicy == 1 || cachePolicy == 3) {
                return new AllInCacheCentralDBBackupSpaceRecovery(this._space);
            }
            return new LRUCentralDBBackupSpaceRecovery(this._space);
        }
        return new NonCentralDBBackupSpaceRecovery(this._space);
    }

    public SpaceRecoverStrategy getRecoveryStrategy(SpaceMode spaceMode) throws SpaceRecoveryException {
        switch (spaceMode) {
            case PRIMARY: {
                return new PrimarySpaceRecovery(this._space);
            }
            case BACKUP: {
                return this.getBackupSpaceRecovery();
            }
        }
        return new NonPrimaryBackupSpaceRecovery(this._space);
    }
}

