/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.recovery.direct_persistency;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.attribute_store.AttributeStore;
import com.gigaspaces.attribute_store.PropertiesFileAttributeStore;
import com.gigaspaces.attribute_store.TransientAttributeStore;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DefaultStorageConsistency;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DirectPersistencyAttributeStoreException;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DirectPersistencyRecoveryException;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.GSDirectPersistencyLusWaiter;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.IStorageConsistency;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.StorageConsistencyModes;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class DirectPersistencyRecoveryHelper
implements IStorageConsistency,
ISpaceModeListener {
    private static final long WAIT_FOR_ANOTHER_PRIMARY_MAX_TIME = 300000L;
    private final SpaceImpl _spaceImpl;
    private final IStorageConsistency _storageConsistencyHelper;
    private final boolean useZooKeeper;
    private volatile boolean _pendingBackupRecovery;
    private final Logger _logger;
    private AttributeStore _attributeStore;
    private final String _attributeStoreKey;
    private final String _fullSpaceName;
    private final int _recoverRetries = Integer.getInteger("com.gs.direct_persistency.recover_retries", 10);

    public DirectPersistencyRecoveryHelper(SpaceImpl spaceImpl, Logger logger) {
        boolean isPersistent;
        this._spaceImpl = spaceImpl;
        this._logger = logger;
        Boolean isLastPrimaryStateKeeperEnabled = Boolean.parseBoolean((String)this._spaceImpl.getCustomProperties().get("space-config.engine.blobstore_persistent"));
        this.useZooKeeper = spaceImpl.getZookeeperLastPrimaryHandler() != null;
        SpaceEngine spaceEngine = spaceImpl.getEngine();
        this._storageConsistencyHelper = spaceEngine.getCacheManager().isBlobStoreCachePolicy() && isLastPrimaryStateKeeperEnabled != false ? spaceEngine.getCacheManager().getBlobStoreRecoveryHelper() : new DefaultStorageConsistency();
        this._fullSpaceName = spaceEngine.getFullSpaceName();
        this._attributeStoreKey = spaceEngine.getSpaceName() + "." + spaceEngine.getPartitionIdOneBased() + ".primary";
        boolean bl = isPersistent = spaceEngine.getCacheManager().isBlobStoreCachePolicy() && this._storageConsistencyHelper.isPerInstancePersistency();
        if (isPersistent) {
            AttributeStore attributeStoreImpl = (AttributeStore)this._spaceImpl.getCustomProperties().get("directPersistency.attribute-store");
            if (attributeStoreImpl == null) {
                if (!this.useZooKeeper) {
                    String attributeStorePath = System.getProperty("com.gs.DirectPersistencyLastPrimaryStatePath");
                    if (attributeStorePath == null) {
                        attributeStorePath = SystemInfo.singleton().locations().work() + File.separator + this.getClass().getSimpleName();
                    }
                    this._attributeStore = new PropertiesFileAttributeStore(attributeStorePath);
                }
            } else {
                this._attributeStore = attributeStoreImpl;
            }
        } else {
            this._attributeStore = new TransientAttributeStore();
        }
        this._spaceImpl.addSpaceModeListener(this);
    }

    @Override
    public StorageConsistencyModes getStorageState() {
        return this._storageConsistencyHelper.getStorageState();
    }

    @Override
    public void setStorageState(StorageConsistencyModes s) {
        this._storageConsistencyHelper.setStorageState(s);
    }

    @Override
    public boolean isPerInstancePersistency() {
        return this._storageConsistencyHelper.isPerInstancePersistency();
    }

    public void beforePrimaryElectionProcess() {
        GSDirectPersistencyLusWaiter waiter;
        boolean iWasPrimary;
        boolean iMayBePrimary;
        boolean validStorageState;
        if (!this._storageConsistencyHelper.isPerInstancePersistency()) {
            return;
        }
        StorageConsistencyModes res = this._storageConsistencyHelper.getStorageState();
        boolean bl = validStorageState = res != StorageConsistencyModes.Inconsistent;
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.log(Level.INFO, "space tested for storageconsistency - result=" + (Object)((Object)res));
        }
        String latestPrimary = this.getLastPrimaryName();
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.log(Level.INFO, "space tested for latest-primary - result=" + latestPrimary);
        }
        boolean bl2 = iMayBePrimary = ((iWasPrimary = this.isMeLastPrimary(latestPrimary)) || latestPrimary == null) && validStorageState;
        if (iMayBePrimary) {
            return;
        }
        if (!validStorageState && iWasPrimary) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, "Inconsistent storage state but space was primary]");
            }
            throw new DirectPersistencyRecoveryException("Failed to start [" + this._spaceImpl.getEngine().getFullSpaceName() + "] inconsistent storage state but space was primary]");
        }
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.log(Level.INFO, "Waiting for any other space to become primary");
        }
        try {
            waiter = new GSDirectPersistencyLusWaiter(this._spaceImpl, this._spaceImpl.getClusterPolicy(), this._logger, this._spaceImpl.getJoinManager(), new Object());
        }
        catch (Exception ex) {
            this._logger.severe("Exception while initiating waiter-for-primary thread " + ex);
            if (ex instanceof DirectPersistencyRecoveryException) {
                throw (DirectPersistencyRecoveryException)ex;
            }
            throw new DirectPersistencyRecoveryException("space " + this._spaceImpl.getEngine().getFullSpaceName() + " got exception while initiating waiter-for-primary thread", ex);
        }
        waiter.start();
        waiter.waitForAnotherPrimary(300000L);
    }

    public boolean isInconsistentStorage() {
        return this._storageConsistencyHelper.getStorageState() == StorageConsistencyModes.Inconsistent;
    }

    private String getLastPrimaryName() {
        try {
            if (this.useZooKeeper) {
                return this._spaceImpl.getZookeeperLastPrimaryHandler().getLastPrimaryNameMemoryXtend();
            }
            return this._attributeStore.get(this._attributeStoreKey);
        }
        catch (IOException e) {
            throw new DirectPersistencyAttributeStoreException("Failed to get last primary", e);
        }
    }

    private void setMeAsLastPrimary() {
        try {
            if (this.useZooKeeper) {
                this._spaceImpl.getZookeeperLastPrimaryHandler().setMeAsLastPrimary();
            } else {
                this._attributeStore.set(this._attributeStoreKey, this._fullSpaceName);
            }
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.log(Level.INFO, "Set as last primary");
            }
        }
        catch (IOException e) {
            throw new DirectPersistencyAttributeStoreException("Failed to set last primary", e);
        }
    }

    public boolean isMeLastPrimary() {
        String lastPrimary = this.getLastPrimaryName();
        return this.isMeLastPrimary(lastPrimary);
    }

    private boolean isMeLastPrimary(String lastPrimary) {
        if (this.useZooKeeper) {
            return this._spaceImpl.getInstanceId().equals(lastPrimary);
        }
        return this._fullSpaceName.equals(lastPrimary);
    }

    @Override
    public void beforeSpaceModeChange(SpaceMode newMode) throws RemoteException {
        if (newMode == SpaceMode.PRIMARY && this.isPendingBackupRecovery()) {
            throw DirectPersistencyRecoveryException.createBackupNotFinishedRecoveryException(this._fullSpaceName);
        }
        if (newMode == SpaceMode.BACKUP) {
            this.setPendingBackupRecovery(true);
        }
        if (newMode == SpaceMode.PRIMARY && !this.useZooKeeper) {
            this.setMeAsLastPrimary();
        }
    }

    @Override
    public void afterSpaceModeChange(SpaceMode newMode) throws RemoteException {
    }

    public void setPendingBackupRecovery(boolean pendingRecovery) {
        this._pendingBackupRecovery = pendingRecovery;
    }

    private boolean isPendingBackupRecovery() {
        return this._pendingBackupRecovery;
    }

    public void handleDirectPersistencyRecoverFailure(int retryCount) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this._logger.warning("failed during recover, retrying for the " + retryCount + " time");
        }
        if (this.isPendingBackupRecovery() && this._recoverRetries == retryCount) {
            throw DirectPersistencyRecoveryException.createBackupNotFinishedRecoveryException(this._fullSpaceName);
        }
    }
}

