/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.recovery.direct_persistency;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionState;
import com.gigaspaces.internal.naming.INamingService;
import com.gigaspaces.internal.naming.LookupNamingService;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DirectPersistencyRecoveryException;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.service.Service;
import com.j_spaces.lookup.entry.ClusterGroup;
import com.j_spaces.lookup.entry.ClusterName;
import com.j_spaces.lookup.entry.State;
import com.sun.jini.lookup.entry.LookupAttributes;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lookup.JoinManager;

@InternalApi
public class GSDirectPersistencyLusWaiter
extends Thread {
    private static final long PERIODIC_SLEEP_TIME = 5000L;
    private volatile boolean _closed;
    private final Logger _logger;
    private final INamingService _namingService;
    private final ElectionEntry _electTemplate;
    private final SpaceImpl _spaceImpl;
    private final Object _terminationMonitor;
    private volatile DirectPersistencyRecoveryException _ex;

    public GSDirectPersistencyLusWaiter(SpaceImpl spaceImpl, ClusterPolicy clusterPolicy, Logger logger, JoinManager joinManager, Object terminationMonitor) throws RemoteException {
        super("GSDirectPersistencyLusWaiter");
        this.setDaemon(true);
        this._logger = logger;
        this._spaceImpl = spaceImpl;
        this._terminationMonitor = terminationMonitor;
        ServiceTemplate participantSrvTemplate = this.buildServiceTemplate(clusterPolicy);
        if (participantSrvTemplate.attributeSetTemplates == null && participantSrvTemplate.serviceTypes == null) {
            throw new IllegalArgumentException("ServiceTemplate can not be initialized with attributeSetTemplates=null and serviceTypes=null");
        }
        this._namingService = new LookupNamingService((LookupDiscoveryManager)joinManager.getDiscoveryManager(), joinManager.getLeaseRenewalManager());
        this._electTemplate = new ElectionEntry(participantSrvTemplate);
    }

    private boolean isPrimaryActive() throws InterruptedException {
        List<ServiceItem> res = this.lookup(Integer.MAX_VALUE);
        if (res == null || res.isEmpty()) {
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info(this._spaceImpl.getEngine().getFullSpaceName() + " waiting for another space to become primary since its storage is  inconsistent, found none so far ");
            }
            return false;
        }
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.info(this._spaceImpl.getEngine().getFullSpaceName() + " waited for another space to become primary since its storage is  inconsistent and found " + ((IJSpace)res.get(0).getService()).getName());
        }
        return true;
    }

    private List<ServiceItem> lookup(int maxMatches) throws InterruptedException {
        this._electTemplate.setState(ActiveElectionState.State.ACTIVE);
        ServiceItem[] foundSrv = this._namingService.lookup(this._electTemplate, maxMatches, null);
        if (foundSrv == null) {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest(this.toString() + " lookup service not found while querying for state: " + (Object)((Object)this._electTemplate._actState.getState()));
            }
            return null;
        }
        List<ServiceItem> matchedSrv = GSDirectPersistencyLusWaiter.trimServices(foundSrv);
        if (this._logger.isLoggable(Level.FINEST)) {
            int duplicates = foundSrv.length - matchedSrv.size();
            this._logger.finest(this.toString() + " found: [" + matchedSrv.size() + "] matches for  serviceTemplate: [" + this._electTemplate + "]; matched services: " + matchedSrv + (duplicates > 0 ? " duplicates: [" + duplicates + "]" : ""));
        }
        return matchedSrv;
    }

    static List<ServiceItem> trimServices(ServiceItem[] srvSet) {
        TreeSet<ServiceItem> treeSet = new TreeSet<ServiceItem>(new Comparator<ServiceItem>(){

            @Override
            public int compare(ServiceItem o1, ServiceItem o2) {
                ServiceID srvID_1 = o1.serviceID;
                ServiceID srvID_2 = o2.serviceID;
                return srvID_1.getMostSignificantBits() < srvID_2.getMostSignificantBits() ? -1 : (srvID_1.getMostSignificantBits() > srvID_2.getMostSignificantBits() ? 1 : (srvID_1.getLeastSignificantBits() < srvID_2.getLeastSignificantBits() ? -1 : (srvID_1.getLeastSignificantBits() > srvID_2.getLeastSignificantBits() ? 1 : 0)));
            }
        });
        if (srvSet != null) {
            Collections.addAll(treeSet, srvSet);
        }
        ArrayList<ServiceItem> trimSet = new ArrayList<ServiceItem>();
        trimSet.addAll(treeSet);
        return trimSet;
    }

    private ServiceTemplate buildServiceTemplate(ClusterPolicy clusterPolicy) {
        ClusterName clusterName = new ClusterName(clusterPolicy.m_ClusterName);
        ClusterGroup clusterGroup = new ClusterGroup(clusterPolicy.m_FailOverPolicy.getElectionGroupName(), null, null);
        State state = new State();
        state.setElectable(Boolean.TRUE);
        Entry[] spaceTemplAttr = new Entry[]{clusterName, clusterGroup, state};
        Class[] serviceTypes = new Class[]{Service.class};
        return new ServiceTemplate(null, serviceTypes, spaceTemplAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAnotherPrimary(long maxWaitTime) {
        long ttl = maxWaitTime;
        Object object = this._terminationMonitor;
        synchronized (object) {
            block11: {
                if (this._ex != null) {
                    throw this._ex;
                }
                if (this._closed) {
                    return;
                }
                long t1 = System.currentTimeMillis();
                long t2 = t1 + maxWaitTime;
                while (true) {
                    try {
                        this._terminationMonitor.wait(ttl);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        this._ex = new DirectPersistencyRecoveryException("space " + this._spaceImpl.getEngine().getFullSpaceName() + " got exception while waiting for other space to become primary", e);
                        break block11;
                    }
                    if (this._closed) break block11;
                    long cur = System.currentTimeMillis();
                    if (cur >= t2) break;
                    ttl = t2 - cur;
                }
                this._ex = new DirectPersistencyRecoveryException("space " + this._spaceImpl.getEngine().getFullSpaceName() + " time to wait for another primary expired");
                try {
                    this.close();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._ex != null) {
                this._logger.severe("space " + this._spaceImpl.getEngine().getFullSpaceName() + " got exception while waiting for other space to become primary " + this._ex);
                throw this._ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (!this._closed) {
                try {
                    if (this.isPrimaryActive()) {
                        return;
                    }
                    Thread.sleep(5000L);
                }
                catch (Exception ex) {
                    this._logger.severe("space " + this._spaceImpl.getEngine().getFullSpaceName() + " got exception while waiting for other space to become primary " + ex);
                    DirectPersistencyRecoveryException e = this._ex = new DirectPersistencyRecoveryException("space " + this._spaceImpl.getEngine().getFullSpaceName() + " got exception while waiting for other space to become primary", ex);
                    if (this._ex != null) throw e;
                    this._ex = e;
                    throw e;
                    return;
                }
            }
        }
        finally {
            this._namingService.terminate();
            Object object = this._terminationMonitor;
            synchronized (object) {
                this._closed = true;
                this._terminationMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        Object object = this._terminationMonitor;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._closed = true;
            this.interrupt();
            this._terminationMonitor.wait();
        }
    }

    private static final class ElectionEntry
    extends ServiceTemplate
    implements Cloneable {
        private static final long serialVersionUID = 1L;
        ActiveElectionState _actState;
        ServiceID _serviceID;
        transient Object service;

        private ElectionEntry(ServiceTemplate srvTemplate) {
            super(null, null, null);
            this.service = this.service;
            this._actState = new ActiveElectionState();
            this.attributeSetTemplates = LookupAttributes.add(srvTemplate.attributeSetTemplates, new Entry[]{this._actState});
            this.serviceTypes = srvTemplate.serviceTypes;
        }

        public ElectionEntry clone() {
            try {
                ElectionEntry cloneEntry = (ElectionEntry)super.clone();
                cloneEntry._actState = new ActiveElectionState();
                cloneEntry.attributeSetTemplates = (Entry[])this.attributeSetTemplates.clone();
                for (int i = 0; i < cloneEntry.attributeSetTemplates.length; ++i) {
                    if (!(cloneEntry.attributeSetTemplates[i] instanceof ActiveElectionState)) continue;
                    cloneEntry.attributeSetTemplates[i] = cloneEntry._actState;
                    break;
                }
                return cloneEntry;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        private Object getService() {
            return this.service;
        }

        private void setState(ActiveElectionState.State state) {
            this._actState.setState(state);
        }

        private ServiceID getServiceID() {
            return this._serviceID;
        }
    }
}

