/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.recovery.group;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.recovery.group.RecoveryGroup;
import com.j_spaces.core.client.FinderException;
import java.rmi.RemoteException;
import java.util.LinkedList;

@InternalApi
public class CompositeRecoveryGroup
extends RecoveryGroup {
    private final LinkedList<RecoveryGroup> _recoveryGroups = new LinkedList();

    public CompositeRecoveryGroup(SpaceImpl space) {
        super(space);
    }

    @Override
    public ISpaceSynchronizeReplicaState recover(boolean transientOnly, boolean memoryOnly) throws Exception {
        for (RecoveryGroup recoveryGroup : this._recoveryGroups) {
            ISpaceSynchronizeReplicaState recoveryStatus = recoveryGroup.recover(transientOnly, memoryOnly);
            if (recoveryStatus == null) continue;
            if (recoveryStatus.getCopyResult().isSuccessful()) {
                return recoveryStatus;
            }
            if (recoveryStatus.getCopyResult().getFailureReason() instanceof FinderException || recoveryStatus.getCopyResult().getFailureReason() instanceof RemoteException) continue;
            throw recoveryStatus.getCopyResult().getFailureReason();
        }
        return null;
    }

    public void add(RecoveryGroup group) {
        this._recoveryGroups.add(group);
    }
}

