/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.recovery.group;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyReplicaState;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyResult;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.recovery.group.CopyOnlySynchronizeSpaceReplicate;
import com.gigaspaces.internal.server.space.recovery.group.RecoveryGroup;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceURL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

@InternalApi
public class LoadBalancingGroupRecovery
extends RecoveryGroup {
    public LoadBalancingGroupRecovery(SpaceImpl space) {
        super(space);
    }

    @Override
    public ISpaceSynchronizeReplicaState recover(boolean transientOnly, boolean memoryOnly) {
        if (!this._space.getClusterPolicy().m_NotifyRecovery) {
            return null;
        }
        List<String> excludeTargets = this.getExcludeTargets();
        List<SpaceURL> recTargets = this._space.getClusterPolicy().m_LoadBalancingPolicy.getRecoverableTargets(this._space.getClusterPolicy().m_ClusterName, this._space.getServiceName(), excludeTargets);
        for (SpaceURL remoteSpaceURL : recTargets) {
            try {
                ISpaceCopyReplicaState spaceCopyReplica = this._space.getEngine().spaceBroadcastNotifyTemplatesReplica(remoteSpaceURL, 1, true);
                ISpaceCopyResult result = spaceCopyReplica.getCopyResult();
                if (result.isSuccessful()) {
                    if (_logger.isLoggable(Level.INFO)) {
                        _logger.info("Space [" + this._space.getServiceName() + "] recovered notify templates from [" + remoteSpaceURL + "]");
                    }
                    return new CopyOnlySynchronizeSpaceReplicate(spaceCopyReplica);
                }
                this._space.getEngine().rollbackCopyReplica(result);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return null;
    }

    private IDirectSpaceProxy findTargetProxy(SpaceURL remoteSpaceURL) throws FinderException {
        long findTimeout = 0L;
        if (this._space.getEngine().getClusterPolicy().m_ReplicationPolicy != null) {
            findTimeout = this._space.getEngine().getClusterPolicy().m_ReplicationPolicy.m_SpaceFinderTimeout;
        } else if (this._space.getEngine().getClusterPolicy().m_FailOverPolicy != null) {
            findTimeout = this._space.getEngine().getClusterPolicy().m_FailOverPolicy.spaceFinderTimeout;
        }
        remoteSpaceURL.setProperty("timeout", String.valueOf(findTimeout));
        IDirectSpaceProxy abstractSpaceProxy = (IDirectSpaceProxy)SpaceFinder.find(remoteSpaceURL);
        return abstractSpaceProxy;
    }

    public List<String> getExcludeTargets() {
        LinkedList<String> excludeTargets = new LinkedList<String>();
        if (this._space.getClusterPolicy().m_FailOverPolicy != null) {
            excludeTargets.addAll(this._space.getClusterPolicy().m_FailOverPolicy.getElectionGroupMembers());
        }
        if (this._space.getClusterPolicy().m_ReplicationPolicy != null) {
            excludeTargets.addAll(this._space.getClusterPolicy().m_ReplicationPolicy.m_ReplicationGroupMembersNames);
        }
        return excludeTargets;
    }
}

