/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.recovery.group;

import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyResult;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceURL;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RecoveryGroup {
    static final Logger _logger = Logger.getLogger("com.gigaspaces.core.common");
    protected final SpaceImpl _space;

    public RecoveryGroup(SpaceImpl space) {
        this._space = space;
    }

    public abstract ISpaceSynchronizeReplicaState recover(boolean var1, boolean var2) throws Exception;

    public ISpaceSynchronizeReplicaState recover(List<SpaceURL> recTargets, boolean transientOnly, boolean memoryOnly) {
        SpaceURL remoteSpaceURL;
        if (!this._space.getEngine().isMemoryRecoveryEnabled()) {
            return null;
        }
        int recoveryChunkSize = this._space.getClusterPolicy().m_ReplicationPolicy.getRecoveryChunkSize();
        ISpaceSynchronizeReplicaState recoveryStatus = null;
        Iterator<SpaceURL> iterator = recTargets.iterator();
        while (iterator.hasNext() && !(recoveryStatus = this.recoverFromSpace(remoteSpaceURL = iterator.next(), transientOnly, memoryOnly, recoveryChunkSize)).getCopyResult().isSuccessful()) {
            if (recoveryStatus.getCopyResult().getFailureReason() instanceof FinderException || recoveryStatus.getCopyResult().getFailureReason() instanceof RemoteException) continue;
            return recoveryStatus;
        }
        return recoveryStatus;
    }

    private ISpaceSynchronizeReplicaState recoverFromSpace(SpaceURL remoteSpaceURL, boolean transientOnly, boolean memoryOnly, int recoveryChunkSize) {
        ISpaceSynchronizeReplicaState spaceSynchronizeReplica;
        ISpaceCopyResult copyResult;
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Space [" + this._space.getServiceName() + "] trying to perform recovery from [" + remoteSpaceURL + "]. RecoveryChunkSize=" + recoveryChunkSize);
        }
        if ((copyResult = (spaceSynchronizeReplica = this._space.getEngine().spaceSynchronizeReplica(remoteSpaceURL, recoveryChunkSize, transientOnly, memoryOnly)).getCopyResult()).isFailed() && !copyResult.isEmpty()) {
            if (this._space.getEngine().getCacheManager().isBlobStoreCachePolicy()) {
                Exception failureReason = copyResult.getFailureReason();
                String err = "Space [" + this._space.getServiceName() + "] failed to perform recovery from [" + remoteSpaceURL + "] reason=" + (failureReason != null ? failureReason.getCause() : "[]") + " space is disabled since it cannot restart in BlobStore cache-policy";
                _logger.severe(err);
                try {
                    this._space.shutdown();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                throw new BlobStoreException(err);
            }
            this._space.internalClean(true, false, false);
        }
        return spaceSynchronizeReplica;
    }
}

