/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.recovery.group;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.recovery.group.RecoveryGroup;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.ClusterPolicy;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class ReplicationGroupRecovery
extends RecoveryGroup {
    public ReplicationGroupRecovery(SpaceImpl space) {
        super(space);
    }

    @Override
    public ISpaceSynchronizeReplicaState recover(boolean transientOnly, boolean memoryOnly) {
        List<String> excludeTargets = this.getExcludeTargets();
        List<SpaceURL> recTargets = this._space.getClusterPolicy().m_ReplicationPolicy.getRecoverableTargets(excludeTargets);
        return this.recover(recTargets, transientOnly, memoryOnly);
    }

    public List<String> getExcludeTargets() {
        LinkedList<String> excludeTargets = new LinkedList<String>();
        ClusterPolicy clusterPolicy = this._space.getClusterPolicy();
        if (clusterPolicy.getReplicationPolicy().getMirrorServiceConfig() != null) {
            excludeTargets.add(clusterPolicy.getReplicationPolicy().getMirrorServiceConfig().memberName);
        }
        if (clusterPolicy.m_FailOverPolicy != null) {
            excludeTargets.addAll(clusterPolicy.m_FailOverPolicy.getElectionGroupMembers());
        }
        return excludeTargets;
    }
}

