/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.recovery.strategy;

import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.StorageConsistencyModes;
import com.gigaspaces.internal.server.space.recovery.group.FailoverGroupRecovery;
import com.gigaspaces.internal.server.space.recovery.strategy.SpaceRecoverStrategy;
import com.gigaspaces.internal.server.space.recovery.strategy.UnavailablePrimarySpaceException;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.exception.internal.InternalInactiveSpaceException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BackupSpaceRecovery
implements SpaceRecoverStrategy {
    static final Logger _logger = Logger.getLogger("com.gigaspaces.core.common");
    protected final SpaceImpl _space;
    private FailoverGroupRecovery _failoverGroup;

    public BackupSpaceRecovery(SpaceImpl space) {
        this._space = space;
        ClusterPolicy clusterPolicy = this._space.getClusterPolicy();
        if (clusterPolicy == null) {
            return;
        }
        if (clusterPolicy.m_FailOverPolicy != null) {
            this._failoverGroup = new FailoverGroupRecovery(this._space);
        }
    }

    @Override
    public ISpaceSynchronizeReplicaState recover() throws Exception {
        this.recoverFromDB();
        boolean recovered = false;
        int directPersistencyRecoverRetryCount = 0;
        ISpaceSynchronizeReplicaState replicaState = null;
        while (!recovered) {
            try {
                replicaState = this.recoverFromOtherSpace();
                recovered = true;
            }
            catch (UnavailablePrimarySpaceException e) {
                if (this._space.getDirectPersistencyRecoveryHelper() != null) {
                    this._space.getDirectPersistencyRecoveryHelper().handleDirectPersistencyRecoverFailure(++directPersistencyRecoverRetryCount);
                }
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Primary space is unavailable.", e);
                }
                if (this._space.getEngine().isFailOverDuringRecovery()) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.warning("Primary space failure detected during the recovery process of this space instance - recovery will be aborted");
                    }
                    throw e;
                }
                Thread.sleep(5000L);
            }
        }
        return replicaState;
    }

    protected ISpaceSynchronizeReplicaState recoverAllFromPrimary() throws Exception {
        return this.recoverFromPrimary(false, false);
    }

    protected ISpaceSynchronizeReplicaState recoverTransientFromPrimary() throws Exception {
        return this.recoverFromPrimary(true, true);
    }

    protected ISpaceSynchronizeReplicaState recoverFromPrimaryMemoryOnly() throws Exception {
        return this.recoverFromPrimary(false, true);
    }

    protected ISpaceSynchronizeReplicaState recoverFromPrimary(boolean transientOnly, boolean memoryOnly) throws Exception {
        if (this._failoverGroup == null) {
            return null;
        }
        ISpaceSynchronizeReplicaState recoveryStatus = this._failoverGroup.recover(transientOnly, memoryOnly);
        if (recoveryStatus != null && recoveryStatus.getCopyResult().isFailed()) {
            Exception causeException = recoveryStatus.getCopyResult().getFailureReason();
            if ((causeException instanceof RemoteException || causeException instanceof FinderException || causeException instanceof InternalInactiveSpaceException) && recoveryStatus.getCopyResult().isEmpty()) {
                throw new UnavailablePrimarySpaceException(causeException);
            }
            throw causeException;
        }
        if (this._space.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper() != null) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("[" + this._space.getEngine().getFullSpaceName() + "] setting storage state of backup to Consistent after recovery from primary");
            }
            this._space.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper().setStorageState(StorageConsistencyModes.Consistent);
        }
        return recoveryStatus;
    }

    @Override
    public abstract void recoverFromDB() throws Exception;

    @Override
    public abstract ISpaceSynchronizeReplicaState recoverFromOtherSpace() throws Exception;
}

