/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.recovery.strategy;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.recovery.group.CompositeRecoveryGroup;
import com.gigaspaces.internal.server.space.recovery.group.FailoverGroupRecovery;
import com.gigaspaces.internal.server.space.recovery.group.LoadBalancingGroupRecovery;
import com.gigaspaces.internal.server.space.recovery.group.ReplicationGroupRecovery;
import com.gigaspaces.internal.server.space.recovery.strategy.SpaceRecoverStrategy;
import com.j_spaces.core.cluster.ClusterPolicy;

@InternalApi
public class NonPrimaryBackupSpaceRecovery
implements SpaceRecoverStrategy {
    private final CompositeRecoveryGroup _recoveryGroup;
    private final SpaceImpl _space;

    public NonPrimaryBackupSpaceRecovery(SpaceImpl space) {
        this._space = space;
        this._recoveryGroup = new CompositeRecoveryGroup(this._space);
        ClusterPolicy clusterPolicy = this._space.getClusterPolicy();
        if (clusterPolicy == null) {
            return;
        }
        if (clusterPolicy.m_FailOverPolicy != null) {
            this._recoveryGroup.add(new FailoverGroupRecovery(this._space));
        }
        if (clusterPolicy.m_ReplicationPolicy != null) {
            this._recoveryGroup.add(new ReplicationGroupRecovery(this._space));
        }
        if (clusterPolicy.m_LoadBalancingPolicy != null) {
            this._recoveryGroup.add(new LoadBalancingGroupRecovery(this._space));
        }
    }

    @Override
    public ISpaceSynchronizeReplicaState recover() throws Exception {
        this.recoverFromDB();
        return this.recoverFromOtherSpace();
    }

    @Override
    public void recoverFromDB() throws Exception {
        this._space.initAndRecoverFromDataStorage(true);
    }

    @Override
    public ISpaceSynchronizeReplicaState recoverFromOtherSpace() throws Exception {
        boolean transientOnly = !this._space.getEngine().isColdStart();
        return this._recoveryGroup.recover(transientOnly, transientOnly);
    }
}

