/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.redolog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.AbstractSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.server.space.redolog.FixedSizeSwapRedoLogFileConfig;
import com.gigaspaces.internal.server.space.redolog.IRedoLogFile;
import com.gigaspaces.internal.server.space.redolog.MemoryRedoLogFile;
import com.gigaspaces.internal.server.space.redolog.RedoLogFileCompromisedException;
import com.gigaspaces.internal.server.space.redolog.SwapStorageException;
import com.gigaspaces.internal.server.space.redolog.storage.INonBatchRedoLogFileStorage;
import com.gigaspaces.internal.server.space.redolog.storage.StorageException;
import com.gigaspaces.internal.server.space.redolog.storage.StorageReadOnlyIterator;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.WeightedBatch;
import com.gigaspaces.internal.utils.collections.ReadOnlyIterator;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.cluster.startup.CompactionResult;
import com.j_spaces.core.cluster.startup.RedoLogCompactionUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class FixedSizeSwapRedoLogFile<T extends IReplicationOrderedPacket>
implements IRedoLogFile<T> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.backlog");
    private final int _memoryMaxCapacity;
    private final int _fetchBatchCapacity;
    private final MemoryRedoLogFile<T> _memoryRedoLogFile;
    private final INonBatchRedoLogFileStorage<T> _externalStorage;
    private final String _name;
    private final int _combinedMemoryMaxCapacity;
    private final AbstractSingleFileGroupBacklog _groupBacklog;
    private boolean _insertToExternal = false;
    private long _lastCompactionRangeEndKey = -1L;
    private long _lastSeenTransientPacketKey = -1L;

    public FixedSizeSwapRedoLogFile(FixedSizeSwapRedoLogFileConfig config, String name, AbstractSingleFileGroupBacklog groupBacklog) {
        this._memoryMaxCapacity = config.getMemoryMaxPackets();
        this._externalStorage = config.getRedoLogFileStorage();
        this._fetchBatchCapacity = config.getFetchBatchSize();
        this._combinedMemoryMaxCapacity = config.getCombinedMemoryMaxCapacity();
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config("FixedSizeSwapRedoLogFile created:\n\tmemoryMaxPackets = " + this._memoryMaxCapacity + "\n\tfetchBatchSize = " + this._fetchBatchCapacity);
        }
        this._memoryRedoLogFile = new MemoryRedoLogFile(name, groupBacklog);
        this._name = name;
        this._groupBacklog = groupBacklog;
    }

    @Override
    public void add(T replicationPacket) {
        int packetWeight = replicationPacket.getWeight();
        if (!this._insertToExternal) {
            if (this._memoryRedoLogFile.isEmpty() && packetWeight > this._combinedMemoryMaxCapacity) {
                this._memoryRedoLogFile.add(replicationPacket);
                _logger.warning("inserting to " + this._name + " memory an operation which weight is larger than the max memory capacity: packet[key=" + replicationPacket.getKey() + ",Type=" + replicationPacket.getClass() + ", weight=" + replicationPacket.getWeight() + "]\n");
                return;
            }
            if (this._memoryRedoLogFile.getWeight() + (long)packetWeight <= (long)this._memoryMaxCapacity) {
                this._memoryRedoLogFile.add(replicationPacket);
            } else {
                this._insertToExternal = true;
            }
        }
        if (this._insertToExternal) {
            this.addToStorage(replicationPacket);
        }
        if (RedoLogCompactionUtil.isCompactable(replicationPacket)) {
            this._lastSeenTransientPacketKey = replicationPacket.getKey();
        }
    }

    @Override
    public T getOldest() {
        if (!this._memoryRedoLogFile.isEmpty()) {
            return this._memoryRedoLogFile.getOldest();
        }
        return this.getOldestFromDataStorage();
    }

    private T getOldestFromDataStorage() {
        try {
            StorageReadOnlyIterator storageIterator = this._externalStorage.readOnlyIterator();
            IReplicationOrderedPacket oldest = (IReplicationOrderedPacket)storageIterator.next();
            storageIterator.close();
            return (T)oldest;
        }
        catch (StorageException e) {
            throw new SwapStorageException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this._memoryRedoLogFile.isEmpty() && (!this._insertToExternal || this._externalStorage.isEmpty());
        }
        catch (StorageException e) {
            throw new SwapStorageException(e);
        }
    }

    @Override
    public ReadOnlyIterator<T> readOnlyIterator(long fromIndex) {
        long memRedoFileSize = this._memoryRedoLogFile.size();
        if (fromIndex < memRedoFileSize) {
            return new SwapReadOnlyIterator(this._memoryRedoLogFile.readOnlyIterator(fromIndex));
        }
        return new SwapReadOnlyIterator(fromIndex - memRedoFileSize);
    }

    @Override
    public T removeOldest() {
        if (!this._memoryRedoLogFile.isEmpty()) {
            return this._memoryRedoLogFile.removeOldest();
        }
        this.moveOldestBatchFromStorage();
        return this._memoryRedoLogFile.removeOldest();
    }

    @Override
    public long size() {
        try {
            return this._memoryRedoLogFile.size() + (this._insertToExternal ? this._externalStorage.size() : 0L);
        }
        catch (StorageException e) {
            throw new SwapStorageException(e);
        }
    }

    @Override
    public long getApproximateSize() {
        try {
            return this._memoryRedoLogFile.getApproximateSize() + this._externalStorage.size();
        }
        catch (StorageException e) {
            throw new SwapStorageException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this._memoryRedoLogFile.iterator();
    }

    @Override
    public ReadOnlyIterator<T> readOnlyIterator() {
        ReadOnlyIterator<T> memoryIterator = this._memoryRedoLogFile.readOnlyIterator();
        return new SwapReadOnlyIterator(memoryIterator);
    }

    @Override
    public void deleteOldestPackets(long packetsCount) {
        long memorySize = this._memoryRedoLogFile.size();
        this._memoryRedoLogFile.deleteOldestPackets(packetsCount);
        if (memorySize < packetsCount) {
            this.deleteOldestPacketsFromStorage(packetsCount - memorySize);
        }
        if (this._memoryRedoLogFile.isEmpty() && this._insertToExternal) {
            this.moveOldestBatchFromStorage();
        }
    }

    private void deleteOldestPacketsFromStorage(long packetsCount) {
        try {
            this._externalStorage.deleteOldestPackets(packetsCount);
        }
        catch (StorageException e) {
            throw new SwapStorageException(e);
        }
    }

    private void moveOldestBatchFromStorage() {
        try {
            WeightedBatch batch = this._externalStorage.removeFirstBatch(this._fetchBatchCapacity, this._lastCompactionRangeEndKey);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Moved a batch of packets from storage into memory, batch weight is " + batch.getWeight());
            }
            if (batch.getWeight() + this.getCacheSize() > (long)this._combinedMemoryMaxCapacity) {
                _logger.warning("Moved a batch of packets from storage into memory which weight causes a breach of memory max capacity, batch weight: " + batch.getWeight() + ", current memory weight: " + this.getCacheSize() + "\n");
            }
            for (IReplicationOrderedPacket packet : batch.getBatch()) {
                this._memoryRedoLogFile.add(packet);
            }
            if (this._externalStorage.isEmpty() && batch.getWeight() < (long)this._memoryMaxCapacity) {
                this._insertToExternal = false;
            }
            if (!batch.getCompactionResult().isEmpty()) {
                this._groupBacklog.updateMirrorWeightAfterCompaction(batch.getCompactionResult());
            }
        }
        catch (StorageException e) {
            throw new SwapStorageException(e);
        }
    }

    private long getCacheSize() {
        return this._externalStorage.getCacheWeight();
    }

    private void addToStorage(T replicationPacket) {
        try {
            this._externalStorage.append(replicationPacket);
        }
        catch (StorageException e) {
            throw new SwapStorageException(e);
        }
    }

    public long getMemoryPacketCount() {
        return this._memoryRedoLogFile.size();
    }

    public long getStoragePacketCount() {
        try {
            return this._externalStorage.size();
        }
        catch (StorageException e) {
            throw new SwapStorageException(e);
        }
    }

    @Override
    public long getExternalStorageSpaceUsed() {
        return this._externalStorage.getSpaceUsed();
    }

    @Override
    public long getExternalStoragePacketsCount() {
        return this._externalStorage.getExternalPacketsCount();
    }

    @Override
    public long getMemoryPacketsCount() {
        return this._memoryRedoLogFile.getMemoryPacketsCount() + this._externalStorage.getMemoryPacketsCount();
    }

    @Override
    public void validateIntegrity() throws RedoLogFileCompromisedException {
        this._memoryRedoLogFile.validateIntegrity();
        this._externalStorage.validateIntegrity();
    }

    @Override
    public void close() {
        this._memoryRedoLogFile.close();
        this._externalStorage.close();
    }

    @Override
    public long getWeight() {
        return this._memoryRedoLogFile.getWeight() + this._externalStorage.getWeight();
    }

    @Override
    public long getDiscardedPacketsCount() {
        return this._memoryRedoLogFile.getDiscardedPacketsCount() + this._externalStorage.getDiscardedPacketsCount();
    }

    @Override
    public CompactionResult performCompaction(long from, long to) {
        CompactionResult result = new CompactionResult();
        if (this._lastCompactionRangeEndKey != -1L) {
            from = this._lastCompactionRangeEndKey + 1L;
        }
        if ((float)(to - from) < ReplicationPolicy.DEFAULT_REDO_LOG_COMPACTION_BATCH_SIZE) {
            return result;
        }
        if (from > this._lastSeenTransientPacketKey) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.fine("[" + this._name + "]: No transient packets in range " + from + "-" + to + ", lastSeenTransientPacketKey = " + this._lastSeenTransientPacketKey);
            }
            return result;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[" + this._name + "]: Performing Compaction " + from + "-" + to);
        }
        result.appendResult(this._memoryRedoLogFile.performCompaction(from, to));
        result.appendResult(this._externalStorage.performCompaction(from, to));
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[" + this._name + "]: Discarded of " + result.getDiscardedCount() + " packets and deleted " + result.getDeletedFromTxn() + " transient packets from transactions during compaction process");
        }
        this._lastCompactionRangeEndKey = to;
        return result;
    }

    public MemoryRedoLogFile<T> getMemoryRedoLogFile() {
        return this._memoryRedoLogFile;
    }

    private class SwapReadOnlyIterator
    implements ReadOnlyIterator<T> {
        private final ReadOnlyIterator<T> _memoryIterator;
        private boolean _memoryIteratorExhausted = false;
        private StorageReadOnlyIterator<T> _externalIterator = null;

        public SwapReadOnlyIterator(ReadOnlyIterator<T> memoryIterator) {
            this._memoryIterator = memoryIterator;
        }

        public SwapReadOnlyIterator(long inSwapStartIndex) {
            this._memoryIteratorExhausted = true;
            this._memoryIterator = null;
            try {
                this._externalIterator = FixedSizeSwapRedoLogFile.this._externalStorage.readOnlyIterator(inSwapStartIndex);
            }
            catch (StorageException e) {
                throw new SwapStorageException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (!this._memoryIteratorExhausted) {
                boolean bl = this._memoryIteratorExhausted = !this._memoryIterator.hasNext();
                if (!this._memoryIteratorExhausted) {
                    return true;
                }
            }
            try {
                if (this._externalIterator == null) {
                    this._externalIterator = FixedSizeSwapRedoLogFile.this._externalStorage.readOnlyIterator();
                }
                return this._externalIterator.hasNext();
            }
            catch (StorageException e) {
                throw new SwapStorageException(e);
            }
        }

        @Override
        public T next() {
            if (!this._memoryIteratorExhausted) {
                try {
                    return (IReplicationOrderedPacket)this._memoryIterator.next();
                }
                catch (NoSuchElementException e) {
                    this._memoryIteratorExhausted = true;
                }
            }
            try {
                if (this._externalIterator == null) {
                    this._externalIterator = FixedSizeSwapRedoLogFile.this._externalStorage.readOnlyIterator();
                }
                return (IReplicationOrderedPacket)this._externalIterator.next();
            }
            catch (StorageException e) {
                throw new SwapStorageException(e);
            }
        }

        @Override
        public void close() {
            if (this._memoryIterator != null) {
                this._memoryIterator.close();
            }
            if (this._externalIterator != null) {
                try {
                    this._externalIterator.close();
                }
                catch (StorageException e) {
                    throw new SwapStorageException(e);
                }
            }
        }
    }
}

