/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.redolog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.server.space.redolog.storage.INonBatchRedoLogFileStorage;

@InternalApi
public class FixedSizeSwapRedoLogFileConfig<T extends IReplicationOrderedPacket> {
    private final int _memoryMaxCapacity;
    private final INonBatchRedoLogFileStorage<T> _redoLogFileStorage;
    private final int _fetchBatchSize;
    private final int _combinedMemoryMaxCapacity;

    public FixedSizeSwapRedoLogFileConfig(int memoryMaxCapacity, int fetchBatchSize, int combinedMemoryMaxCapacity, INonBatchRedoLogFileStorage<T> redoLogFileStorage) {
        if (fetchBatchSize > memoryMaxCapacity) {
            throw new IllegalArgumentException("fetchBatchSize cannot be more than memoryMaxCapacity");
        }
        this._memoryMaxCapacity = memoryMaxCapacity;
        this._fetchBatchSize = fetchBatchSize;
        this._redoLogFileStorage = redoLogFileStorage;
        this._combinedMemoryMaxCapacity = combinedMemoryMaxCapacity;
    }

    public int getMemoryMaxPackets() {
        return this._memoryMaxCapacity;
    }

    public INonBatchRedoLogFileStorage<T> getRedoLogFileStorage() {
        return this._redoLogFileStorage;
    }

    public int getFetchBatchSize() {
        return this._fetchBatchSize;
    }

    public int getCombinedMemoryMaxCapacity() {
        return this._combinedMemoryMaxCapacity;
    }
}

