/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.redolog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.DataTypeIntroducePacketData;
import com.gigaspaces.internal.cluster.node.impl.backlog.AbstractSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.server.space.redolog.IRedoLogFile;
import com.gigaspaces.internal.server.space.redolog.RedoLogFileCompromisedException;
import com.gigaspaces.internal.utils.collections.ReadOnlyIterator;
import com.gigaspaces.internal.utils.collections.ReadOnlyIteratorAdapter;
import com.j_spaces.core.cluster.startup.CompactionResult;
import com.j_spaces.core.cluster.startup.RedoLogCompactionUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Logger;

@InternalApi
public class MemoryRedoLogFile<T extends IReplicationOrderedPacket>
implements IRedoLogFile<T> {
    private final LinkedList<T> _redoFile = new LinkedList();
    private final String _name;
    private final AbstractSingleFileGroupBacklog _groupBacklog;
    private long _weight;
    private long _discardedPacketCount;
    private final Logger _logger;

    public MemoryRedoLogFile(String name, AbstractSingleFileGroupBacklog groupBacklog) {
        this._name = name;
        this._logger = Logger.getLogger("com.gigaspaces.replication.backlog." + this._name);
        this._groupBacklog = groupBacklog;
    }

    @Override
    public void add(T replicationPacket) {
        this._redoFile.addLast(replicationPacket);
        this.increaseWeight(replicationPacket);
    }

    @Override
    public T getOldest() {
        return (T)((IReplicationOrderedPacket)this._redoFile.getFirst());
    }

    @Override
    public boolean isEmpty() {
        return this._redoFile.isEmpty();
    }

    @Override
    public long getExternalStorageSpaceUsed() {
        return 0L;
    }

    @Override
    public long getExternalStoragePacketsCount() {
        return 0L;
    }

    @Override
    public long getMemoryPacketsCount() {
        return this.size();
    }

    @Override
    public ReadOnlyIterator<T> readOnlyIterator(long fromIndex) {
        return new ReadOnlyIteratorAdapter<T>(this._redoFile.listIterator((int)fromIndex));
    }

    @Override
    public Iterator<T> iterator() {
        return this._redoFile.iterator();
    }

    @Override
    public ReadOnlyIterator<T> readOnlyIterator() {
        return new ReadOnlyIteratorAdapter<T>(this.iterator());
    }

    @Override
    public T removeOldest() {
        IReplicationOrderedPacket first = (IReplicationOrderedPacket)this._redoFile.removeFirst();
        this.decreaseWeight(first);
        return (T)first;
    }

    @Override
    public long size() {
        return this._redoFile.size();
    }

    @Override
    public long getApproximateSize() {
        return this._redoFile.size();
    }

    @Override
    public void deleteOldestPackets(long packetsCount) {
        if (packetsCount > (long)this._redoFile.size()) {
            this._redoFile.clear();
            this._weight = 0L;
            this._discardedPacketCount = 0L;
        } else {
            for (long i = 0L; i < packetsCount; ++i) {
                IReplicationOrderedPacket first = (IReplicationOrderedPacket)this._redoFile.removeFirst();
                this.decreaseWeight(first);
            }
        }
    }

    private void printRedoFile(String s) {
        if (this._name.contains("1_1")) {
            return;
        }
        this._logger.info("");
        this._logger.info(s);
        for (IReplicationOrderedPacket t : this._redoFile) {
            String dataString = t.getData().toString();
            if (t.getData() instanceof DataTypeIntroducePacketData) {
                dataString = "DataTypeIntroduce";
            }
            this._logger.info("key=" + t.getKey() + ", data=" + dataString);
        }
        this._logger.info("Total weight = " + this.getWeight());
        this._logger.info("");
    }

    @Override
    public void validateIntegrity() throws RedoLogFileCompromisedException {
    }

    @Override
    public void close() {
        this._redoFile.clear();
        this._weight = 0L;
        this._discardedPacketCount = 0L;
    }

    @Override
    public long getWeight() {
        return RedoLogCompactionUtil.calculateWeight(this._weight, this._discardedPacketCount);
    }

    @Override
    public long getDiscardedPacketsCount() {
        return this._discardedPacketCount;
    }

    @Override
    public CompactionResult performCompaction(long from, long to) {
        ListIterator iterator = this._redoFile.listIterator();
        CompactionResult compactionResult = RedoLogCompactionUtil.compact(from, to, iterator);
        this._weight -= compactionResult.getDiscardedCount() + (long)compactionResult.getDeletedFromTxn();
        this._discardedPacketCount += compactionResult.getDiscardedCount();
        return compactionResult;
    }

    private void increaseWeight(T packet) {
        if (packet.isDiscardedPacket()) {
            ++this._discardedPacketCount;
            if (this._groupBacklog.hasMirror()) {
                this._groupBacklog.increaseMirrorDiscardedCount(1L);
            }
        } else {
            this._weight += (long)packet.getWeight();
        }
    }

    private void decreaseWeight(T packet) {
        if (packet.isDiscardedPacket()) {
            --this._discardedPacketCount;
            if (this._groupBacklog.hasMirror()) {
                this._groupBacklog.decreaseMirrorDiscardedCount(1L);
            }
        } else {
            this._weight -= (long)packet.getWeight();
        }
    }
}

