/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.redolog.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.server.space.redolog.RedoLogFileCompromisedException;
import com.gigaspaces.internal.server.space.redolog.storage.INonBatchRedoLogFileStorage;
import com.gigaspaces.internal.server.space.redolog.storage.IRedoLogFileStorage;
import com.gigaspaces.internal.server.space.redolog.storage.IRedoLogFileStorageStatistics;
import com.gigaspaces.internal.server.space.redolog.storage.StorageException;
import com.gigaspaces.internal.server.space.redolog.storage.StorageReadOnlyIterator;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.WeightedBatch;
import com.j_spaces.core.cluster.startup.CompactionResult;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class BufferedRedoLogFileStorageDecorator<T extends IReplicationOrderedPacket>
implements INonBatchRedoLogFileStorage<T> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.backlog");
    private final int _bufferCapacity;
    private final IRedoLogFileStorage<T> _storage;
    private final LinkedList<T> _buffer = new LinkedList();
    private long _bufferWeight;

    public BufferedRedoLogFileStorageDecorator(int bufferSize, IRedoLogFileStorage storage) {
        this._bufferCapacity = bufferSize;
        this._storage = storage;
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config("BufferedRedoLogFileStorageDecorator created:\n\tbufferSize = " + this._bufferCapacity);
        }
        this._bufferWeight = 0L;
    }

    @Override
    public void append(T replicationPacket) throws StorageException {
        if (this._bufferWeight + (long)replicationPacket.getWeight() > (long)this._bufferCapacity && !this._buffer.isEmpty()) {
            this.flushBuffer();
        }
        this._buffer.add(replicationPacket);
        this.increaseWeight(replicationPacket);
        if (this._bufferWeight >= (long)this._bufferCapacity && this._buffer.size() >= 1) {
            this.flushBuffer();
        }
    }

    private void increaseWeight(T replicationPacket) {
        this._bufferWeight += (long)replicationPacket.getWeight();
    }

    private void decreaseWeight(T packet) {
        this._bufferWeight -= (long)packet.getWeight();
    }

    @Override
    public void appendBatch(List<T> replicationPackets) throws StorageException {
        this._buffer.addAll(replicationPackets);
        for (IReplicationOrderedPacket replicationPacket : replicationPackets) {
            this.increaseWeight(replicationPacket);
        }
        if (this._buffer.size() >= this._bufferCapacity) {
            this.flushBuffer();
        }
    }

    @Override
    public void deleteOldestPackets(long packetsCount) throws StorageException {
        long storageSize = this._storage.size();
        this._storage.deleteOldestPackets(packetsCount);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("delete a batch of size " + Math.min(packetsCount, storageSize) + " from storage");
        }
        int bufferSize = this._buffer.size();
        for (long i = 0L; i < Math.min((long)bufferSize, packetsCount - storageSize); ++i) {
            IReplicationOrderedPacket firstPacket = (IReplicationOrderedPacket)this._buffer.removeFirst();
            this.decreaseWeight(firstPacket);
        }
    }

    @Override
    public StorageReadOnlyIterator<T> readOnlyIterator() throws StorageException {
        return new BufferedReadOnlyIterator(this._storage.readOnlyIterator());
    }

    @Override
    public StorageReadOnlyIterator<T> readOnlyIterator(long fromIndex) throws StorageException {
        long storageSize = this._storage.size();
        if (fromIndex < storageSize) {
            return new BufferedReadOnlyIterator(this._storage.readOnlyIterator(fromIndex));
        }
        return new BufferedReadOnlyIterator((int)(fromIndex - storageSize));
    }

    @Override
    public WeightedBatch<T> removeFirstBatch(int batchCapacity, long lastCompactionRangeEndKey) throws StorageException {
        WeightedBatch<IReplicationOrderedPacket> batch = this._storage.removeFirstBatch(batchCapacity, lastCompactionRangeEndKey);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("removed a batch of weight " + batch.getWeight() + " from storage");
        }
        while (!this._buffer.isEmpty() && batch.getWeight() < (long)batchCapacity && !batch.isLimitReached()) {
            IReplicationOrderedPacket firstPacket = (IReplicationOrderedPacket)this._buffer.getFirst();
            if (batch.size() > 0 && batch.getWeight() + (long)firstPacket.getWeight() > (long)batchCapacity) {
                batch.setLimitReached(true);
                break;
            }
            this._buffer.removeFirst();
            batch.addToBatch(firstPacket);
            this.decreaseWeight(firstPacket);
        }
        if (batch.size() >= batchCapacity) {
            batch.setLimitReached(true);
        }
        return batch;
    }

    @Override
    public long size() throws StorageException {
        return (long)this._buffer.size() + this._storage.size();
    }

    @Override
    public long getSpaceUsed() {
        return this._storage.getSpaceUsed();
    }

    @Override
    public long getExternalPacketsCount() {
        return this._storage.getExternalPacketsCount();
    }

    @Override
    public long getMemoryPacketsCount() {
        return (long)this._buffer.size() + this._storage.getMemoryPacketsCount();
    }

    @Override
    public boolean isEmpty() throws StorageException {
        return this._buffer.isEmpty() && this._storage.isEmpty();
    }

    @Override
    public void validateIntegrity() throws RedoLogFileCompromisedException {
        this._storage.validateIntegrity();
    }

    @Override
    public void close() {
        this._storage.close();
    }

    @Override
    public long getWeight() {
        return this._bufferWeight + this._storage.getWeight();
    }

    @Override
    public long getDiscardedPacketsCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompactionResult performCompaction(long from, long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getCacheWeight() {
        return 0L;
    }

    public IRedoLogFileStorageStatistics getUnderlyingStorage() {
        return this._storage;
    }

    private void flushBuffer() throws StorageException {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("flushing buffer to underlying storage, buffer size is " + this._buffer.size());
            }
            this._storage.appendBatch(this._buffer);
        }
        finally {
            this._buffer.clear();
            this._bufferWeight = 0L;
        }
    }

    private class BufferedReadOnlyIterator
    implements StorageReadOnlyIterator<T> {
        private final StorageReadOnlyIterator<T> _externalIterator;
        private boolean _externalIteratorExhausted;
        private Iterator<T> _bufferIterator;

        public BufferedReadOnlyIterator(StorageReadOnlyIterator<T> externalIterator) {
            this._externalIterator = externalIterator;
        }

        public BufferedReadOnlyIterator(int fromIndex) {
            this._externalIteratorExhausted = true;
            this._externalIterator = null;
            this._bufferIterator = BufferedRedoLogFileStorageDecorator.this._buffer.listIterator(fromIndex);
        }

        @Override
        public boolean hasNext() throws StorageException {
            if (!this._externalIteratorExhausted) {
                boolean bl = this._externalIteratorExhausted = !this._externalIterator.hasNext();
                if (!this._externalIteratorExhausted) {
                    return true;
                }
            }
            if (this._bufferIterator == null) {
                this._bufferIterator = BufferedRedoLogFileStorageDecorator.this._buffer.iterator();
            }
            return this._bufferIterator.hasNext();
        }

        @Override
        public T next() throws StorageException {
            if (!this._externalIteratorExhausted) {
                try {
                    return (IReplicationOrderedPacket)this._externalIterator.next();
                }
                catch (NoSuchElementException e) {
                    this._externalIteratorExhausted = true;
                }
            }
            if (this._bufferIterator == null) {
                this._bufferIterator = BufferedRedoLogFileStorageDecorator.this._buffer.iterator();
            }
            return (IReplicationOrderedPacket)this._bufferIterator.next();
        }

        @Override
        public void close() throws StorageException {
            if (this._externalIterator != null) {
                this._externalIterator.close();
            }
        }
    }
}

