/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.redolog.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.AbstractSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.server.space.redolog.RedoLogFileCompromisedException;
import com.gigaspaces.internal.server.space.redolog.storage.INonBatchRedoLogFileStorage;
import com.gigaspaces.internal.server.space.redolog.storage.StorageException;
import com.gigaspaces.internal.server.space.redolog.storage.StorageFullException;
import com.gigaspaces.internal.server.space.redolog.storage.StorageReadOnlyIterator;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.WeightedBatch;
import com.j_spaces.core.cluster.startup.CompactionResult;
import com.j_spaces.core.cluster.startup.RedoLogCompactionUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class CacheLastRedoLogFileStorageDecorator<T extends IReplicationOrderedPacket>
implements INonBatchRedoLogFileStorage<T> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.backlog");
    private final int _bufferCapacity;
    private final INonBatchRedoLogFileStorage<T> _storage;
    private final LinkedList<T> _buffer = new LinkedList();
    private final AbstractSingleFileGroupBacklog _groupBacklog;
    private long _bufferWeight;
    private long _discardedPacketCount;

    public CacheLastRedoLogFileStorageDecorator(int bufferSize, INonBatchRedoLogFileStorage<T> storage, AbstractSingleFileGroupBacklog groupBacklog) {
        this._bufferCapacity = bufferSize;
        this._storage = storage;
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config("CacheLastRedoLogFileStorageDecorator created:\n\tbufferSize = " + this._bufferCapacity);
        }
        this._bufferWeight = 0L;
        this._groupBacklog = groupBacklog;
    }

    @Override
    public void append(T replicationPacket) throws StorageException, StorageFullException {
        this._buffer.addLast(replicationPacket);
        if (replicationPacket.isDiscardedPacket()) {
            ++this._discardedPacketCount;
        } else {
            this.increaseBufferWeight(replicationPacket);
        }
        this.flushOldest();
    }

    private void increaseBufferWeight(T replicationPacket) {
        if (replicationPacket.isDiscardedPacket()) {
            ++this._discardedPacketCount;
            if (this._groupBacklog.hasMirror()) {
                this._groupBacklog.increaseMirrorDiscardedCount(1L);
            }
        } else {
            this._bufferWeight += (long)replicationPacket.getWeight();
        }
    }

    private void decreaseBufferWeight(T replicationPacket) {
        if (replicationPacket.isDiscardedPacket()) {
            --this._discardedPacketCount;
            if (this._groupBacklog.hasMirror()) {
                this._groupBacklog.decreaseMirrorDiscardedCount(1L);
            }
        } else {
            this._bufferWeight -= (long)replicationPacket.getWeight();
        }
    }

    @Override
    public void appendBatch(List<T> replicationPackets) throws StorageException, StorageFullException {
        for (IReplicationOrderedPacket replicationPacket : replicationPackets) {
            this.increaseBufferWeight(replicationPacket);
        }
        this._buffer.addAll(replicationPackets);
        this.flushOldest();
    }

    private void flushOldest() throws StorageException, StorageFullException {
        try {
            while (this._bufferWeight > (long)this._bufferCapacity && this._buffer.size() > 1) {
                IReplicationOrderedPacket packet = (IReplicationOrderedPacket)this._buffer.removeFirst();
                this._storage.append(packet);
                this.decreaseBufferWeight(packet);
            }
        }
        catch (StorageFullException e) {
            LinkedList<IReplicationOrderedPacket> newDeniedPackets = new LinkedList<IReplicationOrderedPacket>();
            List deniedPackets = e.getDeniedPackets();
            for (int i = deniedPackets.size() - 1; i >= 0; --i) {
                this._buffer.addFirst((IReplicationOrderedPacket)deniedPackets.get(i));
                this.increaseBufferWeight((IReplicationOrderedPacket)deniedPackets.get(i));
                IReplicationOrderedPacket last = (IReplicationOrderedPacket)this._buffer.removeLast();
                this.decreaseBufferWeight(last);
                newDeniedPackets.addFirst(last);
            }
            throw new StorageFullException(e.getMessage(), e.getCause(), newDeniedPackets);
        }
    }

    @Override
    public void validateIntegrity() throws RedoLogFileCompromisedException {
        this._storage.validateIntegrity();
    }

    @Override
    public void close() {
        this._buffer.clear();
        this._storage.close();
        this._bufferWeight = 0L;
    }

    @Override
    public long getWeight() {
        return this._bufferWeight + this._storage.getWeight();
    }

    @Override
    public long getDiscardedPacketsCount() {
        return this._discardedPacketCount;
    }

    @Override
    public CompactionResult performCompaction(long from, long to) {
        ListIterator iterator = this._buffer.listIterator();
        CompactionResult compactionResult = RedoLogCompactionUtil.compact(from, to, iterator);
        this._bufferWeight -= compactionResult.getDiscardedCount() + (long)compactionResult.getDeletedFromTxn();
        this._discardedPacketCount += compactionResult.getDiscardedCount();
        return compactionResult;
    }

    @Override
    public void deleteOldestPackets(long packetsCount) throws StorageException {
        long storageSize = this._storage.size();
        this._storage.deleteOldestPackets(packetsCount);
        int bufferSize = this._buffer.size();
        for (long i = 0L; i < Math.min((long)bufferSize, packetsCount - storageSize); ++i) {
            IReplicationOrderedPacket first = (IReplicationOrderedPacket)this._buffer.removeFirst();
            this.decreaseBufferWeight(first);
        }
    }

    @Override
    public boolean isEmpty() throws StorageException {
        return this._buffer.isEmpty() && this._storage.isEmpty();
    }

    @Override
    public long getSpaceUsed() {
        return this._storage.getSpaceUsed();
    }

    @Override
    public long getExternalPacketsCount() {
        return this._storage.getExternalPacketsCount();
    }

    @Override
    public long getMemoryPacketsCount() {
        return (long)this._buffer.size() + this._storage.getMemoryPacketsCount();
    }

    @Override
    public StorageReadOnlyIterator<T> readOnlyIterator() throws StorageException {
        return new CacheReadOnlyIterator(this._storage.readOnlyIterator());
    }

    @Override
    public StorageReadOnlyIterator<T> readOnlyIterator(long fromIndex) throws StorageException {
        long storageSize = this._storage.size();
        if (fromIndex < storageSize) {
            return new CacheReadOnlyIterator(this._storage.readOnlyIterator(fromIndex));
        }
        return new CacheReadOnlyIterator((int)(fromIndex - storageSize));
    }

    @Override
    public WeightedBatch<T> removeFirstBatch(int batchCapacity, long lastCompactionRangeEndKey) throws StorageException {
        WeightedBatch<IReplicationOrderedPacket> batch = this._storage.removeFirstBatch(batchCapacity, lastCompactionRangeEndKey);
        while (!this._buffer.isEmpty() && batch.getWeight() < (long)batchCapacity && !batch.isLimitReached()) {
            IReplicationOrderedPacket first = (IReplicationOrderedPacket)this._buffer.getFirst();
            if (batch.size() > 0 && batch.getWeight() + (long)first.getWeight() > (long)batchCapacity) {
                batch.setLimitReached(true);
                break;
            }
            this._buffer.removeFirst();
            this.decreaseBufferWeight(first);
            batch.addToBatch(first);
        }
        if (batch.size() >= batchCapacity) {
            batch.setLimitReached(true);
        }
        return batch;
    }

    @Override
    public long size() throws StorageException {
        return (long)this._buffer.size() + this._storage.size();
    }

    @Override
    public long getCacheWeight() {
        return RedoLogCompactionUtil.calculateWeight(this._bufferWeight, this._discardedPacketCount);
    }

    private class CacheReadOnlyIterator
    implements StorageReadOnlyIterator<T> {
        private final StorageReadOnlyIterator<T> _externalIterator;
        private boolean _externalIteratorExhausted;
        private Iterator<T> _bufferIterator;

        public CacheReadOnlyIterator(StorageReadOnlyIterator<T> externalIterator) {
            this._externalIterator = externalIterator;
        }

        public CacheReadOnlyIterator(int fromIndex) {
            this._externalIteratorExhausted = true;
            this._externalIterator = null;
            this._bufferIterator = CacheLastRedoLogFileStorageDecorator.this._buffer.listIterator(fromIndex);
        }

        @Override
        public boolean hasNext() throws StorageException {
            if (!this._externalIteratorExhausted) {
                boolean bl = this._externalIteratorExhausted = !this._externalIterator.hasNext();
                if (!this._externalIteratorExhausted) {
                    return true;
                }
            }
            if (this._bufferIterator == null) {
                this._bufferIterator = CacheLastRedoLogFileStorageDecorator.this._buffer.iterator();
            }
            return this._bufferIterator.hasNext();
        }

        @Override
        public T next() throws StorageException {
            if (!this._externalIteratorExhausted) {
                try {
                    return (IReplicationOrderedPacket)this._externalIterator.next();
                }
                catch (NoSuchElementException e) {
                    this._externalIteratorExhausted = true;
                }
            }
            if (this._bufferIterator == null) {
                this._bufferIterator = CacheLastRedoLogFileStorageDecorator.this._buffer.iterator();
            }
            return (IReplicationOrderedPacket)this._bufferIterator.next();
        }

        @Override
        public void close() throws StorageException {
            if (this._externalIterator != null) {
                this._externalIterator.close();
            }
        }
    }
}

