/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.redolog.storage.bytebuffer;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogWeightPolicy;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogWeightPolicyFactory;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.server.space.redolog.storage.IRedoLogFileStorage;
import com.gigaspaces.internal.server.space.redolog.storage.StorageException;
import com.gigaspaces.internal.server.space.redolog.storage.StorageFullException;
import com.gigaspaces.internal.server.space.redolog.storage.StorageReadOnlyIterator;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ByteBufferRedoLogFileConfig;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ByteBufferStorageCompromisedException;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ByteBufferStorageException;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.EmptyStorageReadOnlyIterator;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.IByteBufferStorageCursor;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.IByteBufferStorageFactory;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.IStorageSegmentsMediator;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.PacketSerializer;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.StorageSegment;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.WeightedBatch;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.logger.TraceableLogger;
import com.j_spaces.core.cluster.startup.CompactionResult;
import com.j_spaces.kernel.pool.IResourceFactory;
import com.j_spaces.kernel.pool.IResourcePool;
import com.j_spaces.kernel.pool.Resource;
import com.j_spaces.kernel.pool.ResourcePool;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ByteBufferRedoLogFileStorage<T extends IReplicationOrderedPacket>
implements IRedoLogFileStorage<T>,
IStorageSegmentsMediator {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.backlog");
    private static final TraceableLogger _traceableLogger = TraceableLogger.getLogger((String)"com.gigaspaces.replication.backlog");
    private final StorageReadOnlyIterator<T> EMPTY_ITERATOR = new EmptyStorageReadOnlyIterator();
    private static final int END_OF_PACKETS_MARKER = -1;
    private static final int END_OF_SEGMENT_MARKER = -2;
    private final IByteBufferStorageFactory _byteBufferStorageProvider;
    private final PacketSerializer<T> _packetSerializer;
    private final IResourcePool<ByteArrayResource> _byteArrayPool = new ResourcePool<ByteArrayResource>(new IResourceFactory<ByteArrayResource>(){

        @Override
        public ByteArrayResource allocate() {
            return new ByteArrayResource(1024);
        }
    }, 0, 128);
    private final LinkedList<StorageSegment> _segments = new LinkedList();
    private final LinkedList<StorageSegment.SegmentCursor> _allocatedReaders = new LinkedList();
    private final int _maxCursors;
    private ByteBuffer _writerBuffer;
    private final long _maxSwapSize;
    private final long _maxSizePerSegment;
    private final int _maxWriteBufferSize;
    private final int _maxScanLength;
    private boolean _initialized = false;
    private long _dataStartPos = 0L;
    private long _size;
    private static final int INTEGER_SERIALIZE_LENGTH = 4;
    private static final int PACKET_PROTOCOL_OVERHEAD = 4;
    private long _weight;
    private BacklogWeightPolicy backlogWeightPolicy;

    public ByteBufferRedoLogFileStorage(IByteBufferStorageFactory byteBufferStorageProvider) {
        this(byteBufferStorageProvider, new ByteBufferRedoLogFileConfig(), BacklogWeightPolicyFactory.create("fixed"));
    }

    public ByteBufferRedoLogFileStorage(IByteBufferStorageFactory byteBufferStorageProvider, ByteBufferRedoLogFileConfig<T> config, BacklogWeightPolicy backlogWeightPolicy) {
        this._byteBufferStorageProvider = byteBufferStorageProvider;
        this._maxWriteBufferSize = config.getWriterMaxBufferSize();
        this._maxSwapSize = config.getMaxSwapSize();
        this._maxSizePerSegment = config.getMaxSizePerSegment();
        this._maxScanLength = config.getMaxScanLength();
        this._maxCursors = config.getMaxOpenStorageCursors() - 1;
        this._writerBuffer = ByteBuffer.allocate(config.getWriterBufferSize());
        this._packetSerializer = new PacketSerializer<T>(config.getPacketStreamSerializer());
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config("ByteBufferRedoLogFileStorage created:\n\tmaxWriteBufferSize = " + config.getWriterMaxBufferSize() / 1024 + "kb\n\tmaxSwapSize = " + (config.getMaxSwapSize() == -1L ? "UNLIMITED" : this._maxSwapSize / 0x100000L + "mb") + "\n\tmaxSizePerSegment = " + config.getMaxSizePerSegment() / 0x100000L + "mb\n\tmaxScanLength = " + config.getMaxScanLength() / 1024 + "kb\n\tmaxCursors = " + config.getMaxOpenStorageCursors());
        }
        this._weight = 0L;
        this.backlogWeightPolicy = backlogWeightPolicy;
    }

    @Override
    public void appendBatch(List<T> replicationPackets) throws StorageException, StorageFullException {
        this.initIfNeeded();
        StorageSegment initLastSegment = this.getLastSegment();
        long segmentSizeAfterPacket = initLastSegment.getPosition() - 4L;
        StorageSegment.SegmentCursor writer = null;
        boolean firstPacket = true;
        int segmentAddedPackets = 0;
        int writtenPackets = 0;
        long addedPacketsWeight = 0L;
        int unindexedLength = initLastSegment.getUnindexedLength();
        int unindexedPacketsCount = initLastSegment.getUnindexedPackets();
        try {
            for (IReplicationOrderedPacket packet : replicationPackets) {
                boolean wasAppended;
                boolean hasRemaining;
                ByteBuffer bufferedPacket = this._packetSerializer.serializePacket(packet);
                int packetSerializeLength = bufferedPacket.remaining() + 4;
                boolean bl = hasRemaining = (segmentSizeAfterPacket += (long)packetSerializeLength) <= this._maxSizePerSegment;
                if (!hasRemaining) {
                    StorageSegment currentLastSegment = this.getLastSegment();
                    if (writer == null) {
                        writer = currentLastSegment.getCursorForWriting();
                        writer.movePosition(-4L);
                    }
                    this.flushWriterBufferToStorage(writer);
                    this.markEndOfSegment(writer);
                    currentLastSegment.increaseNumOfPackets(segmentAddedPackets);
                    currentLastSegment.increaseWeight(addedPacketsWeight);
                    this._weight += addedPacketsWeight;
                    this.createNewSegment();
                    StorageSegment lastSegment = this.getLastSegment();
                    segmentSizeAfterPacket = packetSerializeLength;
                    segmentAddedPackets = 0;
                    addedPacketsWeight = 0L;
                    unindexedLength = 0;
                    unindexedPacketsCount = 0;
                    currentLastSegment.sealWriter();
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("segment sealed, a new segment created, current segment count is " + this._segments.size());
                    }
                    StorageSegment.SegmentCursor tempWriter = writer;
                    writer = null;
                    tempWriter.release();
                    writer = lastSegment.getCursorForWriting();
                }
                if (firstPacket) {
                    if (writer == null) {
                        writer = this.getLastSegment().getCursorForWriting();
                        writer.movePosition(-4L);
                    }
                    firstPacket = false;
                }
                if (!(wasAppended = this.appendPacketToWriterBuffer(bufferedPacket))) {
                    this.flushWriterBufferToStorage(writer);
                    this.writePacketByteBufferToStorage(writer, bufferedPacket);
                }
                ++segmentAddedPackets;
                addedPacketsWeight += (long)packet.getWeight();
                ++writtenPackets;
                ++unindexedPacketsCount;
                if ((unindexedLength += packetSerializeLength) < this._maxScanLength) continue;
                this.getLastSegment().addIndex(unindexedPacketsCount, unindexedLength);
                unindexedPacketsCount = 0;
                unindexedLength = 0;
            }
            if (this._writerBuffer.remaining() < this._writerBuffer.capacity()) {
                this.flushWriterBufferToStorage(writer);
            }
            this.getLastSegment().increaseNumOfPackets(segmentAddedPackets);
            this.getLastSegment().increaseWeight(addedPacketsWeight);
            this._weight += addedPacketsWeight;
            this.getLastSegment().setUnindexedState(unindexedLength, unindexedPacketsCount);
            this.markEndOfPackets(writer);
        }
        catch (StorageFullException e) {
            if (writer != null) {
                writer.movePosition(-4L);
                this.markEndOfPackets(writer);
            }
            ArrayList<T> deniedPackets = new ArrayList<T>();
            for (int i = writtenPackets; i < replicationPackets.size(); ++i) {
                deniedPackets.add(replicationPackets.get(i));
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Storage is full, denied " + deniedPackets.size() + " packets");
            }
            throw new StorageFullException(e.getMessage(), e.getCause(), deniedPackets);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "error appending replications packets to storage", e);
            }
            throw new StorageException("error appending replications packets to storage", e);
        }
        finally {
            if (writer != null) {
                writer.release();
            }
            this._size += (long)writtenPackets;
        }
    }

    private void createNewSegment() throws StorageException, StorageFullException {
        StorageSegment newSegment;
        try {
            long swapSize;
            if (this._maxSwapSize != -1L && (swapSize = (long)this._segments.size() * this._maxSizePerSegment) + this._maxSizePerSegment > this._maxSwapSize) {
                throw new StorageFullException("storage is full", null);
            }
            newSegment = new StorageSegment(this._byteBufferStorageProvider, this, this._maxCursors);
        }
        catch (ByteBufferStorageException e) {
            throw new StorageException("error while creating a new segment", e);
        }
        this._segments.addLast(newSegment);
    }

    private StorageSegment getLastSegment() {
        return this._segments.getLast();
    }

    private void flushWriterBufferToStorage(IByteBufferStorageCursor writer) {
        this._writerBuffer.limit(this._writerBuffer.position());
        this._writerBuffer.position(0);
        writer.writeBytes(this._writerBuffer.array(), 0, this._writerBuffer.limit());
        this.rewindWriterBuffer();
    }

    private boolean appendPacketToWriterBuffer(ByteBuffer buffer) {
        int packetLength = buffer.remaining();
        if (this._writerBuffer.remaining() < packetLength + 4) {
            int newCapacity = (int)((double)(this._writerBuffer.capacity() + packetLength + 4) * 1.5);
            if (newCapacity > this._maxWriteBufferSize) {
                return false;
            }
            ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
            newBuffer.limit(newBuffer.capacity());
            this._writerBuffer.limit(this._writerBuffer.position());
            this._writerBuffer.position(0);
            newBuffer.put(this._writerBuffer);
            this._writerBuffer = newBuffer;
        }
        this._writerBuffer.putInt(packetLength);
        this._writerBuffer.put(buffer);
        return true;
    }

    private void rewindWriterBuffer() {
        this._writerBuffer.rewind();
        this._writerBuffer.limit(this._writerBuffer.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOldestPackets(long packetsCount) throws StorageException {
        if (!this._initialized) {
            return;
        }
        long remainingBatch = this.deleteEntireSegments(packetsCount);
        if (remainingBatch <= 0L) {
            return;
        }
        StorageSegment.SegmentCursor reader = null;
        try {
            StorageSegment currentSegment = this.getFirstSegment();
            reader = currentSegment.getCursorForReading();
            reader.setPosition(this._dataStartPos);
            int i = 0;
            while ((long)i < remainingBatch) {
                T packet = this.readSinglePacketFromStorage(reader);
                this._weight -= (long)packet.getWeight();
                ++i;
            }
            this._size -= Math.min(remainingBatch, this._size);
            this._dataStartPos = reader.getPosition();
            currentSegment.decreaseNumOfPackets(remainingBatch);
        }
        catch (ByteBufferStorageException e) {
            throw new StorageException("error when deleting first batch from storage", e);
        }
        catch (ClassNotFoundException e) {
            throw new StorageException("error when deleting first batch from storage", e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.release();
            }
        }
    }

    private StorageSegment getFirstSegment() {
        return this._segments.getFirst();
    }

    private long deleteEntireSegments(long packetsCount) throws StorageException {
        int numberOfSegments = this._segments.size();
        int currentSegmentCounter = 0;
        int deletedSegments = 0;
        long remaining = packetsCount;
        for (StorageSegment segment : this._segments) {
            ++currentSegmentCounter;
            long numOfPackets = segment.getNumOfPackets();
            if (remaining < numOfPackets) break;
            this._weight -= segment.getWeight();
            if (currentSegmentCounter < numberOfSegments) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("deleted segment " + currentSegmentCounter);
                }
                segment.delete();
                remaining -= numOfPackets;
                ++deletedSegments;
                this._size -= numOfPackets;
                this._dataStartPos = 0L;
                continue;
            }
            try {
                this.clearStorageAndReset();
            }
            catch (ByteBufferStorageException e) {
                throw new StorageException("error clearing storage", e);
            }
            this._size = 0L;
            remaining = 0L;
        }
        this.removeDeletedSegments(deletedSegments);
        return remaining;
    }

    @Override
    public WeightedBatch<T> removeFirstBatch(int batchCapacity, long lastCompactionRangeEndKey) throws StorageException {
        WeightedBatch<T> batch = new WeightedBatch<T>(lastCompactionRangeEndKey);
        if (this._initialized) {
            StorageSegment.SegmentCursor reader = null;
            try {
                Iterator segments = this._segments.iterator();
                StorageSegment currentSegment = (StorageSegment)segments.next();
                reader = currentSegment.getCursorForReading();
                reader.setPosition(this._dataStartPos);
                int removedFromCurrentSegment = 0;
                int numberOfDeletedSegments = 0;
                long weightDeletedFromCurrentSegment = 0L;
                while (batch.getWeight() < (long)batchCapacity) {
                    T packet = this.readSinglePacketFromStorage(reader);
                    if (packet != null && batch.size() > 0 && batch.getWeight() + (long)packet.getWeight() > (long)batchCapacity) {
                        batch.setLimitReached(true);
                        break;
                    }
                    if (packet == null) {
                        if (!segments.hasNext()) break;
                        reader.release();
                        this._weight -= currentSegment.getWeight();
                        currentSegment.delete();
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("deleted segment " + numberOfDeletedSegments);
                        }
                        ++numberOfDeletedSegments;
                        currentSegment = (StorageSegment)segments.next();
                        removedFromCurrentSegment = 0;
                        weightDeletedFromCurrentSegment = 0L;
                        reader = currentSegment.getCursorForReading();
                        reader.setPosition(0L);
                        packet = this.readSinglePacketFromStorage(reader);
                    }
                    ++removedFromCurrentSegment;
                    weightDeletedFromCurrentSegment += (long)packet.getWeight();
                    batch.addToBatch(packet);
                    this._dataStartPos = reader.getPosition();
                }
                currentSegment.decreaseNumOfPackets(removedFromCurrentSegment);
                currentSegment.decreaseWeight(weightDeletedFromCurrentSegment);
                this._weight -= weightDeletedFromCurrentSegment;
                if (0L == currentSegment.getNumOfPackets()) {
                    if (numberOfDeletedSegments < this._segments.size() - 1) {
                        ++numberOfDeletedSegments;
                        reader.release();
                        reader = null;
                        currentSegment.delete();
                        this._dataStartPos = 0L;
                    } else {
                        reader.release();
                        reader = null;
                        this.clearStorageAndReset();
                    }
                }
                this._size -= (long)batch.size();
                this.removeDeletedSegments(numberOfDeletedSegments);
            }
            catch (IOException e) {
                throw new StorageException("error when removing first batch from storage", e);
            }
            catch (ClassNotFoundException e) {
                throw new StorageException("error when removing first batch from storage", e);
            }
            catch (ByteBufferStorageException e) {
                throw new StorageException("error when removing first batch from storage", e);
            }
            finally {
                if (reader != null) {
                    reader.release();
                }
            }
        }
        if (batch.size() >= batchCapacity) {
            batch.setLimitReached(true);
        }
        return batch;
    }

    @Override
    public StorageReadOnlyIterator<T> readOnlyIterator() throws StorageException {
        return this.createReadOnlyIterator(0L);
    }

    @Override
    public StorageReadOnlyIterator<T> readOnlyIterator(long fromIndex) throws StorageException {
        return this.createReadOnlyIterator(fromIndex);
    }

    @Override
    public long size() throws StorageException {
        return this._size;
    }

    @Override
    public boolean isEmpty() throws StorageException {
        return this.size() == 0L;
    }

    @Override
    public long getSpaceUsed() {
        int segmentCount = this._segments.size();
        if (segmentCount == 0) {
            return 0L;
        }
        return (long)(segmentCount - 1) * this._maxSizePerSegment + this.getLastSegment().getPosition();
    }

    @Override
    public long getExternalPacketsCount() {
        return this._size;
    }

    @Override
    public long getMemoryPacketsCount() {
        return 0L;
    }

    @Override
    public synchronized void close() {
        for (StorageSegment segment : this._segments) {
            segment.delete();
        }
        this._segments.clear();
        this._initialized = false;
        this._dataStartPos = 0L;
        this._size = 0L;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("closed storage");
        }
    }

    @Override
    public long getWeight() {
        return this._weight;
    }

    @Override
    public long getDiscardedPacketsCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompactionResult performCompaction(long from, long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getCacheWeight() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() throws StorageException {
        if (!this._initialized) {
            ByteBufferRedoLogFileStorage byteBufferRedoLogFileStorage = this;
            synchronized (byteBufferRedoLogFileStorage) {
                if (!this._initialized) {
                    StorageSegment.SegmentCursor writer = null;
                    try {
                        StorageSegment firstSegment = new StorageSegment(this._byteBufferStorageProvider, this, this._maxCursors);
                        writer = firstSegment.getCursorForWriting();
                        this.markEndOfPackets(writer);
                        this._segments.add(firstSegment);
                        this._initialized = true;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("disk is used for the first time, created first storage segment");
                        }
                    }
                    catch (ByteBufferStorageException e) {
                        throw new StorageException(e);
                    }
                    finally {
                        if (writer != null) {
                            writer.release();
                        }
                    }
                }
            }
        }
    }

    private void removeDeletedSegments(int numberOfDeletedSegments) {
        for (int i = 0; i < numberOfDeletedSegments; ++i) {
            this._segments.removeFirst();
        }
    }

    private void writePacketByteBufferToStorage(IByteBufferStorageCursor writer, ByteBuffer bufferedPacket) {
        int length = bufferedPacket.remaining();
        writer.writeInt(length);
        writer.writeBytes(bufferedPacket.array(), 0, bufferedPacket.limit());
    }

    private void clearStorageAndReset() throws ByteBufferStorageException {
        StorageSegment segment = this.getLastSegment();
        segment.clear();
        this._dataStartPos = 0L;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("first segments cleared");
        }
        StorageSegment.SegmentCursor writer = segment.getCursorForWriting();
        try {
            this.markEndOfPackets(writer);
        }
        finally {
            writer.release();
            this._weight = 0L;
        }
    }

    private ByteArrayResource readBytesFromStorage(IByteBufferStorageCursor reader) {
        int length = reader.readInt();
        if (length == -1) {
            return null;
        }
        if (length == -2) {
            return null;
        }
        ByteArrayResource byteArrayResource = this.getByteArrayResource(length);
        reader.readBytes(byteArrayResource.array(), 0, length);
        return byteArrayResource;
    }

    private ByteArrayResource getByteArrayResource(int length) {
        ByteArrayResource resource = this._byteArrayPool.getResource();
        resource.ensureCapacity(length);
        return resource;
    }

    private void markEndOfPackets(IByteBufferStorageCursor writer) {
        writer.writeInt(-1);
    }

    private void markEndOfSegment(IByteBufferStorageCursor writer) {
        writer.writeInt(-2);
    }

    private StorageReadOnlyIterator<T> createReadOnlyIterator(long fromIndex) throws StorageException {
        if (!this._initialized) {
            return this.EMPTY_ITERATOR;
        }
        if (fromIndex >= this._size) {
            return this.EMPTY_ITERATOR;
        }
        try {
            return new ByteBufferReadOnlyIterator(fromIndex);
        }
        catch (ByteBufferStorageException e) {
            throw new StorageException("error creating a readonly iterator over the storage", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T readSinglePacketFromStorage(IByteBufferStorageCursor reader) throws IOException, ClassNotFoundException {
        ByteArrayResource serializedPacket = this.readBytesFromStorage(reader);
        if (serializedPacket == null) {
            return null;
        }
        try {
            IReplicationOrderedPacket packet = (IReplicationOrderedPacket)this._packetSerializer.deserializePacket(serializedPacket.array());
            IReplicationPacketData<?> packetData = packet.getData();
            if (packetData != null) {
                packetData.setWeight(this.backlogWeightPolicy.calculateWeight(packetData));
            }
            IReplicationOrderedPacket iReplicationOrderedPacket = packet;
            return (T)iReplicationOrderedPacket;
        }
        finally {
            serializedPacket.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void allocatedNewResource(StorageSegment.SegmentCursor resource) {
        if (this._allocatedReaders.size() >= this._maxCursors) {
            Iterator readers = this._allocatedReaders.iterator();
            while (readers.hasNext()) {
                StorageSegment.SegmentCursor reader = (StorageSegment.SegmentCursor)readers.next();
                if (!reader.isSegmentSealedForWriting() || !reader.tryAcquire()) continue;
                try {
                    reader.clearStorageCursor();
                    break;
                }
                finally {
                    readers.remove();
                    reader.release();
                }
            }
        }
        this._allocatedReaders.addLast(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateIntegrity() throws ByteBufferStorageCompromisedException {
        ByteBufferRedoLogFileStorage byteBufferRedoLogFileStorage = this;
        synchronized (byteBufferRedoLogFileStorage) {
            if (!this._initialized) {
                return;
            }
        }
        try {
            StorageSegment.SegmentCursor reader = null;
            int segmentIndex = 0;
            int packetCount = 0;
            long unindexedLength = 0L;
            int packetInSegment = 0;
            long position = 0L;
            try {
                StorageSegment currentSegment = this.getFirstSegment();
                reader = currentSegment.getCursorForReading();
                reader.setPosition(0L);
                boolean firstIteration = true;
                while (true) {
                    IReplicationOrderedPacket deserializePacket;
                    position = reader.getPosition();
                    if (_traceableLogger.isLoggable(Level.FINEST)) {
                        _traceableLogger.finest("start index integrity iteration [" + packetCount + "], position=" + position + " segment index [" + segmentIndex + "] in segment packet index [" + packetInSegment + "] unindexed length [" + unindexedLength + "]");
                    }
                    if (!firstIteration && unindexedLength >= (long)this._maxScanLength) {
                        long indexPos = currentSegment.getIndexPosition(packetInSegment);
                        if (_traceableLogger.isLoggable(Level.FINEST)) {
                            _traceableLogger.finest("index position=" + indexPos + " reader position=" + position);
                        }
                        if (indexPos != reader.getPosition()) {
                            throw new ByteBufferStorageCompromisedException("Error while checking index integrity, segment index [" + segmentIndex + "] packet index [" + packetCount + "] in segment packet index [" + packetInSegment + "] expected index [" + reader.getPosition() + "] actual [" + indexPos + "]");
                        }
                        unindexedLength = 0L;
                    }
                    firstIteration = false;
                    int length = reader.readInt();
                    if (_traceableLogger.isLoggable(Level.FINEST)) {
                        _traceableLogger.finest("next packet length=" + length);
                    }
                    if (length == -1) {
                        if (!_traceableLogger.isLoggable(Level.FINEST)) break;
                        _traceableLogger.finest("reached end of packets marker");
                        break;
                    }
                    if (length == -2) {
                        if (_traceableLogger.isLoggable(Level.FINEST)) {
                            _traceableLogger.finest("reached end of segment marker");
                        }
                        StorageSegment.SegmentCursor tempReader = reader;
                        reader = null;
                        if (_traceableLogger.isLoggable(Level.FINEST)) {
                            _traceableLogger.finest("releasing reader");
                        }
                        tempReader.release();
                        currentSegment = this._segments.get(++segmentIndex);
                        reader = currentSegment.getCursorForReading();
                        reader.setPosition(0L);
                        position = 0L;
                        packetInSegment = 0;
                        unindexedLength = 0L;
                        if (!_traceableLogger.isLoggable(Level.FINEST)) continue;
                        _traceableLogger.finest("moved to next segment");
                        continue;
                    }
                    byte[] packetBuffer = new byte[length];
                    reader.readBytes(packetBuffer, 0, length);
                    if (_traceableLogger.isLoggable(Level.FINEST)) {
                        _traceableLogger.finest("deserializing packet");
                    }
                    if ((deserializePacket = (IReplicationOrderedPacket)this._packetSerializer.deserializePacket(packetBuffer)) == null) {
                        throw new ByteBufferStorageCompromisedException("Error while checking data integrity, packet at index " + packetCount + " is null");
                    }
                    if (packetInSegment >= currentSegment.getNumOfDeletedPackets()) {
                        ++packetCount;
                    }
                    ++packetInSegment;
                    unindexedLength += reader.getPosition() - position;
                }
                if (_traceableLogger.isLoggable(Level.FINEST)) {
                    _traceableLogger.finest("done index integrity check, releasing last reader");
                }
                StorageSegment.SegmentCursor tempReader = reader;
                reader = null;
                if (tempReader != null) {
                    tempReader.release();
                }
            }
            catch (Exception e) {
                if (reader != null) {
                    try {
                        reader.release();
                    }
                    catch (Exception ei) {
                        throw new ByteBufferStorageCompromisedException("Error while checking data integrity, reached packet index " + packetCount + " additionally exception occurred when releasing the reader " + ei.toString(), e);
                    }
                }
                if (e instanceof ByteBufferStorageCompromisedException) {
                    throw (ByteBufferStorageCompromisedException)e;
                }
                throw new ByteBufferStorageCompromisedException("Error while checking data integrity, reached packet index " + packetCount, e);
            }
            if (_traceableLogger.isLoggable(Level.FINEST)) {
                _traceableLogger.finest("validating size integrity, expected size=" + packetCount + " known size=" + this._size);
            }
            if ((long)packetCount != this._size) {
                throw new ByteBufferStorageCompromisedException("Calculated size [" + packetCount + "] does not match kept size [" + this._size + "]");
            }
            if (_traceableLogger.isLoggable(Level.FINEST)) {
                _traceableLogger.finest("perform one entire scan using iterator");
            }
            StorageReadOnlyIterator<T> iterator = null;
            int count = 0;
            try {
                iterator = this.readOnlyIterator();
                while (iterator.hasNext()) {
                    if (iterator.next() == null) {
                        throw new ByteBufferStorageCompromisedException("Error while checking full iteration indexes, at packet index " + count + " iterator returned null packet");
                    }
                    if (_traceableLogger.isLoggable(Level.FINEST)) {
                        _traceableLogger.finest("iteration count " + count);
                    }
                    ++count;
                }
                if (_traceableLogger.isLoggable(Level.FINEST)) {
                    _traceableLogger.finest("done iterator integrity check, closing iterator");
                }
                StorageReadOnlyIterator<T> tempIterator = iterator;
                iterator = null;
                tempIterator.close();
                if (_traceableLogger.isLoggable(Level.FINEST)) {
                    _traceableLogger.finest("validating iterator size integrity, expected size=" + count + " known size=" + this._size);
                }
                if ((long)count != this._size) {
                    throw new ByteBufferStorageCompromisedException("Full iteration size [" + packetCount + "] does not match kept size [" + this._size + "]");
                }
            }
            catch (Exception e) {
                if (iterator != null) {
                    try {
                        iterator.close();
                    }
                    catch (StorageException ei) {
                        throw new ByteBufferStorageCompromisedException("Error while checking full iteration integrity, at packet index " + count + " additionally an error occurred while closing iterator " + ei.toString(), e);
                    }
                }
                if (e instanceof ByteBufferStorageCompromisedException) {
                    throw (ByteBufferStorageCompromisedException)e;
                }
                throw new ByteBufferStorageCompromisedException("Error while checking full iteration integrity, at packet index " + count, e);
            }
            if (_traceableLogger.isLoggable(Level.FINEST)) {
                _traceableLogger.finest("validating fetch iterator by index integrity");
            }
            iterator = null;
            int i = 0;
            try {
                while ((long)i < this._size) {
                    iterator = this.readOnlyIterator(i);
                    if (!iterator.hasNext()) {
                        throw new ByteBufferStorageCompromisedException("Error while validating indexes, at packet index " + i + " iterator has no next");
                    }
                    IReplicationOrderedPacket packet = (IReplicationOrderedPacket)iterator.next();
                    if (packet == null) {
                        throw new ByteBufferStorageCompromisedException("Error while validating indexes, at packet index " + i + " iterator returned null packet");
                    }
                    if (_traceableLogger.isLoggable(Level.FINEST)) {
                        _traceableLogger.finest("validated fetch iterator by index [" + i + "] integrity done, closing iterator");
                    }
                    StorageReadOnlyIterator<T> tempIterator = iterator;
                    iterator = null;
                    tempIterator.close();
                    ++i;
                }
            }
            catch (Exception e) {
                if (iterator != null) {
                    try {
                        iterator.close();
                    }
                    catch (StorageException ei) {
                        throw new ByteBufferStorageCompromisedException("Error while validating indexes, at packet index " + i + " additionally an error occurred while closing iterator " + ei.toString(), e);
                    }
                }
                if (e instanceof ByteBufferStorageCompromisedException) {
                    throw (ByteBufferStorageCompromisedException)e;
                }
                throw new ByteBufferStorageCompromisedException("Error while validating indexes, at packet index " + i, e);
            }
        }
        catch (ByteBufferStorageCompromisedException e) {
            this.logGeneralStatusOnError();
            if (_traceableLogger.isLoggable(Level.FINEST)) {
                _traceableLogger.finest(e.getMessage());
            }
            _traceableLogger.showThreadTrace();
            throw e;
        }
        catch (Exception e) {
            this.logGeneralStatusOnError();
            if (_traceableLogger.isLoggable(Level.FINEST)) {
                _traceableLogger.finest(e.getMessage());
            }
            _traceableLogger.showThreadTrace();
            throw new ByteBufferStorageCompromisedException(e);
        }
        finally {
            _traceableLogger.clearThreadTrace();
        }
    }

    private void logGeneralStatusOnError() {
        if (_logger.isLoggable(Level.SEVERE)) {
            _logger.severe("integrity validation failed, general state:" + StringUtils.NEW_LINE + "dataStartPos=" + this._dataStartPos + StringUtils.NEW_LINE + "known size=" + this._size + StringUtils.NEW_LINE + "number of segments=" + this._segments.size() + StringUtils.NEW_LINE + "configured segment size=" + this._maxSizePerSegment + StringUtils.NEW_LINE + "configured max scan length=" + this._maxScanLength + StringUtils.NEW_LINE + "segments details:" + StringUtils.NEW_LINE + this.displaySegmentDetails());
        }
    }

    private String displaySegmentDetails() {
        StringBuilder result = new StringBuilder("segments count=");
        result.append(this._segments.size());
        result.append(StringUtils.NEW_LINE);
        int index = 0;
        for (StorageSegment segment : this._segments) {
            result.append("segment ");
            result.append(index++);
            result.append(": name=");
            result.append(segment.getName());
            result.append(" held packets=");
            result.append(segment.getNumOfPackets());
            result.append(" deleted packets=");
            result.append(segment.getNumOfDeletedPackets());
            result.append(" position=");
            result.append(segment.getPosition());
            result.append(" unindexed length=");
            result.append(segment.getUnindexedLength());
            result.append(" unindexed packets=");
            result.append(segment.getUnindexedPackets());
            result.append(StringUtils.NEW_LINE);
        }
        return result.toString();
    }

    public class ByteArrayResource
    extends Resource {
        private SoftReference<byte[]> _bufferRef;
        private byte[] _tempBuffer;

        public ByteArrayResource(int length) {
            this._bufferRef = new SoftReference<byte[]>(new byte[length]);
        }

        public void ensureCapacity(int length) {
            this._tempBuffer = this._bufferRef.get();
            if (this._tempBuffer == null || this._tempBuffer.length < length) {
                this._tempBuffer = new byte[length];
                this._bufferRef = new SoftReference<byte[]>(this._tempBuffer);
            }
        }

        @Override
        public void clear() {
            this._tempBuffer = null;
        }

        public byte[] array() {
            return this._tempBuffer;
        }
    }

    private class ByteBufferReadOnlyIterator
    implements StorageReadOnlyIterator<T> {
        private StorageSegment.SegmentCursor _reader;
        private T _next;
        private int _segmentIndex = 0;
        private volatile boolean _released = false;

        public ByteBufferReadOnlyIterator(long fromIndex) throws ByteBufferStorageException {
            this.advanceToPacket(fromIndex);
        }

        private void advanceToPacket(long fromIndex) throws ByteBufferStorageException {
            long firstPacketInSegment = 0L;
            long firstPacketInNextSegment = 0L;
            StorageSegment startSegment = null;
            for (StorageSegment segment : ByteBufferRedoLogFileStorage.this._segments) {
                if (fromIndex < (firstPacketInNextSegment += segment.getNumOfPackets())) {
                    startSegment = segment;
                    break;
                }
                firstPacketInSegment = firstPacketInNextSegment;
                ++this._segmentIndex;
            }
            try {
                if (startSegment == null) {
                    StorageSegment lastSegment = ByteBufferRedoLogFileStorage.this.getLastSegment();
                    this._reader = lastSegment.getCursorForReading();
                    this._reader.setPosition(lastSegment.getPosition() - 4L);
                    return;
                }
                this._reader = startSegment.getCursorForReading();
                if (fromIndex == 0L) {
                    this._reader.setPosition(ByteBufferRedoLogFileStorage.this._dataStartPos);
                } else {
                    long positionInBlock = startSegment.adjustReader(this._reader, fromIndex - firstPacketInSegment);
                    for (long i = 0L; i < positionInBlock; ++i) {
                        int length = this._reader.readInt();
                        this._reader.movePosition(length);
                    }
                }
            }
            catch (ByteBufferStorageException e) {
                this.releaseReader();
                throw e;
            }
            catch (Exception e) {
                this.releaseReader();
                throw new ByteBufferStorageException(e);
            }
        }

        @Override
        public boolean hasNext() throws StorageException {
            boolean hasNext = false;
            try {
                if (this._reader == null) {
                    boolean bl = false;
                    return bl;
                }
                while (true) {
                    this._next = ByteBufferRedoLogFileStorage.this.readSinglePacketFromStorage(this._reader);
                    if (this._next != null || ++this._segmentIndex >= ByteBufferRedoLogFileStorage.this._segments.size()) break;
                    try {
                        this._reader.release();
                        this._reader = ((StorageSegment)ByteBufferRedoLogFileStorage.this._segments.get(this._segmentIndex)).getCursorForReading();
                        this._reader.setPosition(0L);
                    }
                    catch (ByteBufferStorageException e) {
                        throw new StorageException("error while iterating over the storage", e);
                    }
                }
                boolean e = hasNext = this._next != null;
                return e;
            }
            catch (Exception e) {
                throw new StorageException("error while iterating over the storage", e);
            }
            finally {
                if (!hasNext) {
                    this.releaseReader();
                }
            }
        }

        @Override
        public T next() throws StorageException {
            if (this._next == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this._next;
            this._next = null;
            return result;
        }

        protected void finalize() throws Throwable {
            this.releaseReader();
        }

        @Override
        public void close() throws StorageException {
            this.releaseReader();
        }

        private void releaseReader() {
            if (!this._released) {
                if (this._reader != null) {
                    this._reader.release();
                    this._reader = null;
                }
                this._released = true;
            }
        }
    }
}

