/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.redolog.storage.bytebuffer;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.GSByteArrayInputStream;
import com.gigaspaces.internal.io.GSByteArrayOutputStream;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ByteBufferObjectInputStream;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ByteBufferObjectOutputStream;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.IPacketStreamSerializer;
import com.j_spaces.kernel.pool.IResourceFactory;
import com.j_spaces.kernel.pool.IResourcePool;
import com.j_spaces.kernel.pool.Resource;
import com.j_spaces.kernel.pool.ResourcePool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class PacketSerializer<T> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.backlog");
    private final ByteBufferObjectOutputStream _oss;
    private final GSByteArrayOutputStream _gsByteOutputStream;
    private final IPacketStreamSerializer<T> _packetStreamSerializer;
    private byte[] _buffer;
    private ByteBuffer _byteBuffer;
    private IResourcePool<InputStreamsResource> _inputStreamsPool = new ResourcePool<InputStreamsResource>(new IResourceFactory<InputStreamsResource>(){

        @Override
        public InputStreamsResource allocate() {
            return new InputStreamsResource();
        }
    }, 0, 16);
    private static final byte[] _resetBuffer = new byte[]{121, 112};
    private static final byte[] _dummyBuffer = new byte[0];

    PacketSerializer(int initBufferSize, IPacketStreamSerializer<T> packetStreamSerializer) {
        this._packetStreamSerializer = packetStreamSerializer;
        this._buffer = new byte[initBufferSize];
        this._gsByteOutputStream = new GSByteArrayOutputStream();
        this._gsByteOutputStream.setBuffer(this._buffer);
        this._byteBuffer = ByteBuffer.wrap(this._buffer);
        try {
            this._oss = new ByteBufferObjectOutputStream(this._gsByteOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error creating PacketSerializer", e);
        }
    }

    public PacketSerializer(IPacketStreamSerializer<T> packetStreamSerializer) {
        this(65536, packetStreamSerializer);
    }

    public ByteBuffer serializePacket(T packet) throws IOException {
        this._packetStreamSerializer.writePacketToStream(this._oss, packet);
        this._oss.flush();
        this._oss.reset();
        byte[] actualBuffer = this._gsByteOutputStream.getBuffer();
        if (actualBuffer != this._buffer) {
            this._buffer = actualBuffer;
            this._byteBuffer = ByteBuffer.wrap(this._buffer);
        }
        this._byteBuffer.limit(this._gsByteOutputStream.size() - 1);
        this._byteBuffer.position(0);
        this._gsByteOutputStream.setSize(0);
        return this._byteBuffer;
    }

    public T deserializePacket(byte[] serializedPacket) throws IOException, ClassNotFoundException {
        InputStreamsResource resource = this._inputStreamsPool.getResource();
        try {
            resource.setBuffer(serializedPacket);
            Object t = resource.readPacket();
            return t;
        }
        catch (IOException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Unexpected error when deserializing replication packet from the swap space", e);
            }
            resource.markCorrupted();
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Unexpected error when deserializing replication packet from the swap space", e);
            }
            resource.markCorrupted();
            throw e;
        }
        catch (RuntimeException re) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Unexpected error when deserializing replication packet from the swap space", re);
            }
            resource.markCorrupted();
            throw re;
        }
        finally {
            resource.release();
        }
    }

    public class InputStreamsResource
    extends Resource {
        private GSByteArrayInputStream gsByteArrayInputStream = new GSByteArrayInputStream(PacketSerializer.access$000());
        private ByteBufferObjectInputStream objectInputStream;
        private boolean _corrupted;

        public T readPacket() throws IOException, ClassNotFoundException {
            if (this.objectInputStream == null) {
                this.objectInputStream = new ByteBufferObjectInputStream(this.gsByteArrayInputStream);
            }
            return PacketSerializer.this._packetStreamSerializer.readPacketFromStream(this.objectInputStream);
        }

        public void markCorrupted() {
            this._corrupted = true;
        }

        public void setBuffer(byte[] serializedPacket) {
            this.gsByteArrayInputStream.setBuffer(serializedPacket);
        }

        @Override
        public void clear() {
            if (this._corrupted) {
                this.recreateStream();
                return;
            }
            this.gsByteArrayInputStream.setBuffer(_resetBuffer);
            try {
                this.objectInputStream.readObject();
                this.gsByteArrayInputStream.setBuffer(_dummyBuffer);
            }
            catch (IOException e) {
                this.recreateStream();
                throw new RuntimeException("Unexpected error when clearing packet serializer resource", e);
            }
            catch (ClassNotFoundException e) {
                this.recreateStream();
                throw new RuntimeException("Unexpected error when clearing packet serializer resource", e);
            }
        }

        private void recreateStream() {
            this.gsByteArrayInputStream = new GSByteArrayInputStream(_dummyBuffer);
            try {
                this.objectInputStream = new ByteBufferObjectInputStream(this.gsByteArrayInputStream);
                this._corrupted = false;
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected error when resetting packet serializer resource streams", e);
            }
        }
    }
}

