/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.redolog.storage.bytebuffer;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ByteBufferStorageException;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.IByteBufferStorage;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.IByteBufferStorageCursor;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.IByteBufferStorageFactory;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.IStorageSegmentsMediator;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@InternalApi
public class StorageSegment {
    private static final Index START_SEGMENT = new Index(0L, 0L);
    private final SegmentCursor _cursor;
    private final IByteBufferStorage _storage;
    private final IStorageSegmentsMediator _segmentsMediator;
    private long _numberOfPackets;
    private int _deletedPacketsCount;
    private long _weight;
    private final ArrayList<Index> _indexes = new ArrayList();
    private Index _lastIndex = START_SEGMENT;
    private boolean _sealedWriter = false;
    private long _writerPosition;
    private int _unindexedLength;
    private int _unindexedPacketsCount;

    public StorageSegment(IByteBufferStorageFactory storageProvider, IStorageSegmentsMediator segmentsMediator, int maxReaders) throws ByteBufferStorageException {
        this._segmentsMediator = segmentsMediator;
        this._storage = storageProvider.createStorage();
        this._cursor = new SegmentCursor(this._storage.getCursor());
    }

    public String getName() {
        return this._storage.getName();
    }

    public SegmentCursor getCursorForWriting() {
        if (this._sealedWriter) {
            throw new IllegalStateException("Cannot request cursor for writing after segment has been sealed");
        }
        this._cursor.setAsWriter();
        return this._cursor;
    }

    public void sealWriter() {
        this._sealedWriter = true;
    }

    public SegmentCursor getCursorForReading() throws ByteBufferStorageException {
        this._cursor.acquire();
        try {
            this._cursor.initIfNeeded();
        }
        catch (Exception e) {
            this._cursor.release();
            if (e instanceof ByteBufferStorageException) {
                throw (ByteBufferStorageException)e;
            }
            throw new ByteBufferStorageException("error creating cursor", e);
        }
        return this._cursor;
    }

    public void clear() throws ByteBufferStorageException {
        this._storage.clear();
        this._numberOfPackets = 0L;
        this._deletedPacketsCount = 0;
        this._writerPosition = 0L;
        this._indexes.clear();
        this._unindexedLength = 0;
        this._unindexedPacketsCount = 0;
        this._weight = 0L;
        this._lastIndex = START_SEGMENT;
    }

    public long getPosition() {
        return this._writerPosition;
    }

    public void increaseNumOfPackets(long numOfPackets) {
        this._numberOfPackets += numOfPackets;
    }

    public long getNumOfPackets() {
        return this._numberOfPackets;
    }

    public int getNumOfDeletedPackets() {
        return this._deletedPacketsCount;
    }

    public void delete() {
        this._storage.close();
    }

    public void decreaseNumOfPackets(long numOfPackets) {
        this._deletedPacketsCount = (int)((long)this._deletedPacketsCount + numOfPackets);
        this._numberOfPackets -= numOfPackets;
    }

    public void setUnindexedState(int unindexedLength, int unindexedPacketsCount) {
        this._unindexedLength = unindexedLength;
        this._unindexedPacketsCount = unindexedPacketsCount;
    }

    public int getUnindexedLength() {
        return this._unindexedLength;
    }

    public int getUnindexedPackets() {
        return this._unindexedPacketsCount;
    }

    public void addIndex(int packetCountFromLastIndex, long distanceFromLastIndex) {
        Index newIndex = new Index(this._lastIndex.getPacketCount() + (long)packetCountFromLastIndex, this._lastIndex.getPosition() + distanceFromLastIndex);
        this._indexes.add(newIndex);
        this._lastIndex = newIndex;
    }

    public long adjustReader(IByteBufferStorageCursor reader, long packetPosition) {
        long actualPosition = packetPosition + (long)this._deletedPacketsCount;
        Index closestBlockStart = this.searchIndex(actualPosition);
        reader.setPosition(closestBlockStart.getPosition());
        return actualPosition - closestBlockStart.getPacketCount();
    }

    public long getIndexPosition(int packetPosition) {
        long actualPosition = packetPosition;
        Index closestBlockStart = this.searchIndex(actualPosition);
        return closestBlockStart.getPosition();
    }

    public Index searchIndex(long packetPosition) {
        if (this._indexes.isEmpty()) {
            return START_SEGMENT;
        }
        return this.binarySearch(packetPosition, 0, this._indexes.size() - 1);
    }

    private Index binarySearch(long packetPosition, int startInd, int endInd) {
        int middleIndex;
        Index index;
        if (startInd == endInd) {
            Index index2 = this._indexes.get(startInd);
            if (index2.getPacketCount() > packetPosition) {
                if (startInd == 0) {
                    return START_SEGMENT;
                }
                return this._indexes.get(startInd - 1);
            }
            if (index2.getPacketCount() <= packetPosition) {
                return index2;
            }
        }
        if ((index = this._indexes.get(middleIndex = (endInd - startInd) / 2 + startInd)).getPacketCount() < packetPosition) {
            return this.binarySearch(packetPosition, middleIndex + 1, endInd);
        }
        if (index.getPacketCount() > packetPosition) {
            return this.binarySearch(packetPosition, startInd, middleIndex);
        }
        return index;
    }

    public void increaseWeight(long weight) {
        this._weight += weight;
    }

    public void decreaseWeight(long weight) {
        this._weight -= weight;
    }

    public long getWeight() {
        return this._weight;
    }

    public class SegmentCursor
    implements IByteBufferStorageCursor {
        private IByteBufferStorageCursor _storageCursor;
        private final Lock _lock = new ReentrantLock();
        private volatile boolean _actAsWriter;

        public SegmentCursor(IByteBufferStorageCursor cursor) {
            this._storageCursor = cursor;
        }

        public void setAsWriter() {
            this._actAsWriter = true;
            this._storageCursor.setPosition(StorageSegment.this._writerPosition);
        }

        public boolean tryAcquire() {
            return this._lock.tryLock();
        }

        public void acquire() {
            this._lock.lock();
        }

        public void initIfNeeded() throws ByteBufferStorageException {
            if (this._storageCursor == null) {
                StorageSegment.this._segmentsMediator.allocatedNewResource(this);
                this._storageCursor = StorageSegment.this._storage.getCursor();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void release() {
            if (this._actAsWriter) {
                try {
                    StorageSegment.this._writerPosition = this._storageCursor.getPosition();
                    if (!StorageSegment.this._sealedWriter) return;
                    this.clearStorageCursor();
                    return;
                }
                finally {
                    this._actAsWriter = false;
                }
            } else {
                this._lock.unlock();
            }
        }

        @Override
        public void close() {
            this._storageCursor.close();
        }

        @Override
        public long getPosition() {
            return this._storageCursor.getPosition();
        }

        @Override
        public void movePosition(long offset) {
            this._storageCursor.movePosition(offset);
        }

        @Override
        public byte readByte() {
            return this._storageCursor.readByte();
        }

        @Override
        public void readBytes(byte[] result, int offset, int length) {
            this._storageCursor.readBytes(result, offset, length);
        }

        @Override
        public int readInt() {
            return this._storageCursor.readInt();
        }

        @Override
        public long readLong() {
            return this._storageCursor.readLong();
        }

        @Override
        public void setPosition(long position) {
            this._storageCursor.setPosition(position);
        }

        @Override
        public void writeByte(byte value) {
            this._storageCursor.writeByte(value);
        }

        @Override
        public void writeBytes(byte[] array, int offset, int length) {
            this._storageCursor.writeBytes(array, offset, length);
        }

        @Override
        public void writeInt(int value) {
            this._storageCursor.writeInt(value);
        }

        @Override
        public void writeLong(long value) {
            this._storageCursor.writeLong(value);
        }

        public boolean isSegmentSealedForWriting() {
            return StorageSegment.this._sealedWriter;
        }

        public synchronized void clearStorageCursor() {
            this._storageCursor.close();
            this._storageCursor = null;
        }
    }

    private static class Index {
        private final long _packetCount;
        private final long _position;

        public Index(long packetCount, long position) {
            this._packetCount = packetCount;
            this._position = position;
        }

        public long getPacketCount() {
            return this._packetCount;
        }

        public long getPosition() {
            return this._position;
        }

        public String toString() {
            return "Index[packetCount=" + this._packetCount + ", position=" + this._position + "]";
        }
    }
}

