/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.redolog.storage.bytebuffer;

import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDiscardedReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractTransactionReplicationPacketData;
import com.j_spaces.core.cluster.startup.CompactionResult;
import com.j_spaces.core.cluster.startup.RedoLogCompactionUtil;
import java.util.ArrayList;
import java.util.List;

public class WeightedBatch<T> {
    private List<T> batch;
    private long weight;
    private boolean limitReached = false;
    private CompactionResult compactionResult = new CompactionResult();
    private final long lastCompactionRangeKey;

    public WeightedBatch(long lastCompactionRangeEndKey) {
        this.batch = new ArrayList<T>();
        this.lastCompactionRangeKey = lastCompactionRangeEndKey;
    }

    public List<T> getBatch() {
        return this.batch;
    }

    public void setBatch(List<T> batch) {
        this.batch = batch;
    }

    public long getWeight() {
        return RedoLogCompactionUtil.calculateWeight(this.weight, this.compactionResult.getDiscardedCount());
    }

    public void setWeight(long weight) {
        this.weight = weight;
    }

    public boolean isLimitReached() {
        return this.limitReached;
    }

    public void setLimitReached(boolean limitReached) {
        this.limitReached = limitReached;
    }

    public CompactionResult getCompactionResult() {
        return this.compactionResult;
    }

    public void addToBatch(T packet) {
        long packetWeight = ((IReplicationOrderedPacket)packet).getWeight();
        if (((IReplicationOrderedPacket)packet).getKey() <= this.lastCompactionRangeKey && RedoLogCompactionUtil.isCompactable((IReplicationOrderedPacket)packet)) {
            if (((IReplicationOrderedPacket)packet).getData().isSingleEntryData()) {
                GlobalOrderDiscardedReplicationPacket discarded = new GlobalOrderDiscardedReplicationPacket(((IReplicationOrderedPacket)packet).getKey());
                this.batch.add(discarded);
                this.compactionResult.increaseDiscardedCount(1);
                this.weight -= packetWeight;
            } else {
                AbstractTransactionReplicationPacketData txnPacketData = (AbstractTransactionReplicationPacketData)((IReplicationOrderedPacket)packet).getData();
                int deletedFromTxn = RedoLogCompactionUtil.compactTxn(txnPacketData.listIterator());
                this.compactionResult.increaseDeletedFromTxnCount(deletedFromTxn);
                txnPacketData.setWeight(txnPacketData.getWeight() - this.compactionResult.getDeletedFromTxn());
                this.batch.add(packet);
                this.weight += packetWeight;
            }
        } else {
            this.batch.add(packet);
            this.weight += packetWeight;
        }
    }

    public int size() {
        return this.batch.size();
    }
}

