/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.raf;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ByteBufferStorageException;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.IByteBufferStorage;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.IByteBufferStorageCursor;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.raf.RAFByteBufferStorageException;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

@InternalApi
public class RAFByteBufferStorage
implements IByteBufferStorage {
    private final File _file;
    private volatile Cursor _cursor;
    private volatile boolean _closed;

    public RAFByteBufferStorage(String fileName) throws ByteBufferStorageException {
        try {
            File workLocation = new File(SystemInfo.singleton().locations().work());
            workLocation.mkdirs();
            File replicationDirName = new File("replication");
            File replicationDirPath = new File(workLocation, replicationDirName.getPath());
            replicationDirPath.mkdirs();
            this._file = File.createTempFile(fileName, "tmp", replicationDirPath);
        }
        catch (IOException e) {
            throw new ByteBufferStorageException("error creating temp file", e);
        }
        try {
            this.getFile().deleteOnExit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void clear() throws ByteBufferStorageException {
        if (this._cursor == null) {
            this.getCursor();
        }
        this._cursor.clear();
    }

    @Override
    public synchronized void close() {
        if (this._cursor != null) {
            this._cursor.close();
        }
        this._cursor = null;
        this.getFile().delete();
        this._closed = true;
    }

    public File getFile() {
        return this._file;
    }

    @Override
    public synchronized IByteBufferStorageCursor getCursor() throws ByteBufferStorageException {
        if (this._closed) {
            throw new RAFByteBufferStorageException("storage is closed");
        }
        if (this._cursor == null) {
            try {
                this._cursor = new Cursor();
            }
            catch (FileNotFoundException e) {
                throw new ByteBufferStorageException("error creating cursor over the temp file", e);
            }
        }
        return this._cursor;
    }

    @Override
    public String getName() {
        try {
            return this._file.getAbsolutePath();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private class Cursor
    implements IByteBufferStorageCursor {
        private final RandomAccessFile _raf;

        public Cursor() throws FileNotFoundException {
            this._raf = new RandomAccessFile(RAFByteBufferStorage.this._file, "rw");
        }

        public void clear() {
            try {
                this._raf.setLength(0L);
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }

        @Override
        public void close() {
            try {
                this._raf.close();
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
            finally {
                RAFByteBufferStorage.this._cursor = null;
            }
        }

        @Override
        public long getPosition() {
            try {
                return this._raf.getFilePointer();
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }

        @Override
        public void movePosition(long offset) {
            try {
                this._raf.seek(this._raf.getFilePointer() + offset);
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }

        @Override
        public byte readByte() {
            try {
                return this._raf.readByte();
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }

        @Override
        public void readBytes(byte[] result, int offset, int length) {
            try {
                this._raf.read(result, offset, length);
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }

        @Override
        public int readInt() {
            try {
                return this._raf.readInt();
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }

        @Override
        public long readLong() {
            try {
                return this._raf.readLong();
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }

        @Override
        public void setPosition(long position) {
            try {
                this._raf.seek(position);
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }

        @Override
        public void writeByte(byte value) {
            try {
                this._raf.writeByte(value);
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }

        @Override
        public void writeBytes(byte[] array, int offset, int length) {
            try {
                this._raf.write(array, offset, length);
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }

        @Override
        public void writeInt(int value) {
            try {
                this._raf.writeInt(value);
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }

        @Override
        public void writeLong(long value) {
            try {
                this._raf.writeLong(value);
            }
            catch (IOException e) {
                throw new RAFByteBufferStorageException(e);
            }
        }
    }
}

