/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.replication;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.IncomingReplicationOutOfSyncException;
import com.gigaspaces.internal.cluster.node.AbstractReplicationNodeStateListener;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.groups.BrokenReplicationTopologyException;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.exception.internal.InternalInactiveSpaceException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ReplicationNodeStateListener
extends AbstractReplicationNodeStateListener {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.engine");
    private final SpaceEngine _spaceEngine;
    private final String _fullSpaceName;
    private final ClusterPolicy _clusterPolicy;
    private final SpaceImpl _spaceImpl;

    public ReplicationNodeStateListener(SpaceEngine spaceEngine) {
        this._spaceEngine = spaceEngine;
        this._fullSpaceName = spaceEngine.getFullSpaceName();
        this._clusterPolicy = spaceEngine.getClusterPolicy();
        this._spaceImpl = spaceEngine.getSpaceImpl();
    }

    @Override
    public boolean onTargetChannelOutOfSync(String groupName, String channelSourceLookupName, IncomingReplicationOutOfSyncException outOfSyncReason) {
        String message = "Space [" + this._fullSpaceName + "] received out of sync indication from replication group [" + groupName + "] source member [" + channelSourceLookupName + "]";
        if (this._spaceImpl.isPrimary()) {
            message = message + StringUtils.NEW_LINE + "The current space is an active space, it will resynchronize with the source and may lose packets";
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.severe(message);
            }
            return true;
        }
        if (this._clusterPolicy != null) {
            switch (this._clusterPolicy.getReplicationPolicy().getOnMissingPackets()) {
                case IGNORE: {
                    message = message + StringUtils.NEW_LINE + "The current space is an inactive space (backup), it is set to ignore missing packets, it will resynchronize with the source and may lose packets";
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.severe(message);
                    }
                    return true;
                }
                case RECOVER: {
                    message = message + StringUtils.NEW_LINE + "The current space is an inactive space (backup), it will be restarted and perform full recovery from its primary space";
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.warning(message);
                    }
                    this._spaceEngine.setReplicationUnhealthyReason(outOfSyncReason);
                    return false;
                }
            }
        }
        this._spaceEngine.setReplicationUnhealthyReason(outOfSyncReason);
        return false;
    }

    @Override
    public void onTargetChannelBacklogDropped(String groupName, String channelSourceLookupName, IBacklogMemberState memberState) {
        if (_logger.isLoggable(Level.WARNING)) {
            _logger.warning("Space [" + this._fullSpaceName + "] received backlog dropped notification from replication group [" + groupName + "] source member [" + channelSourceLookupName + "]" + StringUtils.NEW_LINE + "Current space will be restarted and perform full recovery from its primary space");
        }
        this._spaceEngine.setReplicationUnhealthyReason(new IncomingReplicationOutOfSyncException("Replication is out of sync, backlog was dropped by source, replication state " + memberState.toLogMessage()));
    }

    @Override
    public void onSourceBrokenReplicationTopology(String groupName, String channelTargetMemberName, BrokenReplicationTopologyException error) {
    }

    @Override
    public void onSourceChannelActivated(String groupName, String memberName) {
    }

    @Override
    public void onTargetChannelCreationValidation(String groupName, String sourceMemberName, Object sourceUniqueId) {
    }

    @Override
    public void onNewReplicaRequest(String groupName, String memberName, boolean isSynchronizeRequest) {
        if (isSynchronizeRequest && !this._spaceImpl.isPrimary()) {
            String message = "Space [" + this._fullSpaceName + "] received new replica request from replication group [" + groupName + "] , source member [" + memberName + "]";
            message = message + StringUtils.NEW_LINE + "The current space is not an active space. New replica request was denied.";
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning(message);
            }
            throw new InternalInactiveSpaceException(message);
        }
    }
}

