/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.replication;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilterBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.GatewayChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.notification.NotificationReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.view.ViewReplicationChannelDataFilter;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.server.storage.TemplateHolderFactory;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.LeaseManager;

@InternalApi
public class SpaceReplicationChannelDataFilterBuilder
implements IReplicationChannelDataFilterBuilder {
    private final SpaceEngine _spaceEngine;

    public SpaceReplicationChannelDataFilterBuilder(SpaceEngine spaceEngine) {
        this._spaceEngine = spaceEngine;
    }

    @Override
    public IReplicationChannelDataFilter createFilter(String name, String groupName, Object ... arguments) throws Exception {
        if (name.equals(ViewReplicationChannelDataFilter.class.getName())) {
            ITemplatePacket[] templates = new ITemplatePacket[arguments.length];
            for (int i = 0; i < templates.length; ++i) {
                templates[i] = (ITemplatePacket)arguments[i];
                this._spaceEngine.getTypeManager().loadServerTypeDesc(templates[i]);
            }
            return new ViewReplicationChannelDataFilter(this._spaceEngine.getCacheManager(), groupName, templates, this._spaceEngine.getTemplateScanner().getRegexCache(), this._spaceEngine.getTypeManager());
        }
        if (name.equals(NotificationReplicationChannelDataFilter.class.getName())) {
            ITemplatePacket template = (ITemplatePacket)arguments[0];
            NotifyInfo notifyInfo = (NotifyInfo)arguments[1];
            Long eventId = (Long)arguments[2];
            IServerTypeDesc typeDesc = this._spaceEngine.getTypeManager().loadServerTypeDesc(template);
            NotifyTemplateHolder tHolder = TemplateHolderFactory.createNotifyTemplateHolder(typeDesc, template, template.getUID(), LeaseManager.toAbsoluteTime(Long.MAX_VALUE), eventId, notifyInfo, false);
            return new NotificationReplicationChannelDataFilter(this._spaceEngine.getCacheManager(), groupName, this._spaceEngine.getTemplateScanner().getRegexCache(), this._spaceEngine.getTypeManager(), this._spaceEngine.getFilterManager(), tHolder);
        }
        if (name.equals(GatewayChannelDataFilter.class.getName())) {
            boolean sendChangeAsUpdate = false;
            if (arguments != null && arguments.length == 1) {
                sendChangeAsUpdate = (Boolean)arguments[0];
            }
            return new GatewayChannelDataFilter(sendChangeAsUpdate);
        }
        throw new UnsupportedOperationException("Cannot create a filter with name " + name);
    }
}

