/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.replication;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.ReplicationFilterManager;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNodeBuilder;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationBacklogBuilder;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderBacklogBuilder;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileBacklogBuilder;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.MultiSourceSingleFileBacklogBuilder;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfig;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfigBuilder;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySyncHandler;
import com.gigaspaces.internal.cluster.node.impl.groups.AllSpaceItemGroupsExtractor;
import com.gigaspaces.internal.cluster.node.impl.handlers.AbstractSpaceReplicationEntryEventHandler;
import com.gigaspaces.internal.cluster.node.impl.handlers.ActiveActiveSpaceReplicationEntryEventHandler;
import com.gigaspaces.internal.cluster.node.impl.handlers.BlobstorePrimaryBackupSpaceReplicationEntryEventHandler;
import com.gigaspaces.internal.cluster.node.impl.handlers.PrimaryBackupSpaceReplicationEntryEventHandler;
import com.gigaspaces.internal.cluster.node.impl.handlers.PrimaryBackupSpaceReplicationEvictionProtectionEntryEventHandler;
import com.gigaspaces.internal.cluster.node.impl.handlers.SpaceReplicationEntryLeaseEventHandler;
import com.gigaspaces.internal.cluster.node.impl.handlers.SpaceReplicationMetadataEventHandler;
import com.gigaspaces.internal.cluster.node.impl.handlers.SpaceReplicationTemplateEventHandler;
import com.gigaspaces.internal.cluster.node.impl.handlers.SpaceReplicationTransactionEventHandler;
import com.gigaspaces.internal.cluster.node.impl.packets.data.BlobstoreReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.BlobstoreReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.SpaceEngineFixFacade;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.MultiSourceSingleFileProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaDataProducerBuilder;
import com.gigaspaces.internal.extension.XapExtensions;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.SpaceEngineReplicaConsumerFacade;
import com.gigaspaces.internal.server.space.SpaceEngineReplicaDirectPersistencySyncConsumerFacade;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.space.replication.ReplicationNodeStateListener;
import com.gigaspaces.internal.server.space.replication.SpaceReplicationChannelDataFilterBuilder;
import com.gigaspaces.internal.server.space.replication.SpaceReplicationLifeCycleBuilder;
import com.gigaspaces.internal.sync.mirror.MirrorConfig;
import com.gigaspaces.internal.sync.mirror.MirrorService;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.ScheduledThreadPoolAsyncHandlerProvider;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.ReplicationProcessingType;
import com.j_spaces.core.sadapter.IStorageAdapter;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SpaceReplicationInitializer {
    private static final Logger _replicationNodeLogger = Logger.getLogger("com.gigaspaces.replication.node");
    private final SpaceConfigReader _configReader;
    private final SpaceImpl _spaceImpl;
    private final SpaceTypeManager _typeManager;
    private final IStorageAdapter _storageAdapter;
    private final SpaceEngine _spaceEngine;
    private final String _fullSpaceName;
    private final SpaceClusterInfo _clusterInfo;
    private final ClusterPolicy _clusterPolicy;
    private final boolean _isReplicated;
    private final boolean _isSyncReplication;
    private final ReplicationFilterManager _replicationFilterManager;
    private final ReplicationNode _replicationNode;
    private final MirrorService _mirrorService;
    private boolean _alreadyWarnedUnsupportedConfig = false;
    private final boolean _replicationBlobstoreBackupBulks = Boolean.parseBoolean(System.getProperty("space-config.engine.blobstore_use_bulks", "true")) && Boolean.parseBoolean(System.getProperty("com.gs.replication.blobstore.use_backup_bulks", "true"));
    private final boolean _syncListEnabled = Boolean.parseBoolean(System.getProperty("com.gs.replication.blobstore.use_sync_list", "true"));

    public SpaceReplicationInitializer(SpaceConfigReader configReader, SpaceImpl spaceImpl, SpaceTypeManager typeManager, IStorageAdapter storageAdapter, SpaceEngine spaceEngine) throws RemoteException {
        this._configReader = configReader;
        this._spaceImpl = spaceImpl;
        this._typeManager = typeManager;
        this._storageAdapter = storageAdapter;
        this._spaceEngine = spaceEngine;
        this._fullSpaceName = configReader.getFullSpaceName();
        this._clusterInfo = spaceImpl.getClusterInfo();
        this._clusterPolicy = spaceImpl.getClusterPolicy();
        this._isReplicated = this._clusterPolicy != null && this._clusterPolicy.m_Replicated;
        this._isSyncReplication = this._clusterPolicy != null && this._clusterPolicy.m_ReplicationPolicy != null && this._clusterPolicy.m_ReplicationPolicy.isOwnerMemberHasSyncReplication();
        boolean isMirrorService = configReader.getBooleanSpaceProperty("mirror-service.enabled", "false");
        if (isMirrorService) {
            this._mirrorService = this.initMirrorService();
            this._replicationFilterManager = null;
            this._replicationNode = this._mirrorService.getReplicationNode();
        } else {
            this._mirrorService = null;
            if (this._isReplicated) {
                this._replicationFilterManager = new ReplicationFilterManager(this._clusterPolicy.getReplicationPolicy(), spaceImpl.getURL(), spaceImpl.getSingleProxy());
                this._replicationNode = this.createReplicationNode(this._replicationFilterManager, configReader);
            } else {
                this._replicationFilterManager = null;
                this._replicationNode = this.createEmptyReplicationNode();
            }
        }
    }

    public boolean isReplicated() {
        return this._isReplicated;
    }

    public boolean isSyncReplication() {
        return this._isSyncReplication;
    }

    public ReplicationFilterManager getReplicationFilterManager() {
        return this._replicationFilterManager;
    }

    public ReplicationNode getReplicationNode() {
        return this._replicationNode;
    }

    public MirrorService getMirrorService() {
        return this._mirrorService;
    }

    private MirrorService initMirrorService() {
        if (this._clusterPolicy != null) {
            throw new IllegalStateException("Mirror service cannot be deployed as a clustered topology, it should not contain any cluster schema");
        }
        return new MirrorService(this._fullSpaceName, this._spaceImpl.getUuid(), new MirrorConfig(this._configReader), this._storageAdapter.getSynchronizationInterceptor(), this._storageAdapter.getDataClass(), this._typeManager, this._spaceEngine.getMetricRegistrator());
    }

    public boolean isReplicatedPersistentBlobstore() {
        boolean isBlobstorePersistent = Boolean.parseBoolean(this._spaceImpl.getCustomProperties().getProperty("space-config.engine.blobstore_persistent"));
        boolean isReplicated = this._spaceEngine.getClusterInfo().getNumberOfBackups() > 0;
        return isBlobstorePersistent && isReplicated;
    }

    private ReplicationNode createReplicationNode(ReplicationFilterManager filterManager, SpaceConfigReader configReader) {
        ReplicationNodeBuilder nodeBuilder = new ReplicationNodeBuilder();
        nodeBuilder.setSpaceItemGroupsExtractor(new AllSpaceItemGroupsExtractor());
        nodeBuilder.setReplicationRouterBuilder(XapExtensions.getInstance().getReplicationRouterBuilderFactory().create(this._spaceImpl));
        ReplicationPacketDataMediator packetDataMediator = new ReplicationPacketDataMediator();
        nodeBuilder.setReplicationProcessLogBuilder(this.createReplicationProcessLog(packetDataMediator));
        nodeBuilder.setReplicationBacklogBuilder(this.createReplicationBacklog(this._storageAdapter, packetDataMediator));
        nodeBuilder.setReplicaDataProducerBuilder(new SpaceReplicaDataProducerBuilder(this._spaceEngine));
        if (this.isReplicatedPersistentBlobstore() && this._syncListEnabled) {
            if (_replicationNodeLogger.isLoggable(Level.INFO)) {
                _replicationNodeLogger.info("[" + this._fullSpaceName + "] initialized with direct persistency sync list recovery mode");
            }
            nodeBuilder.setReplicaDataConsumer(new SpaceReplicaDataConsumer(this._typeManager, new SpaceEngineReplicaDirectPersistencySyncConsumerFacade(this._spaceEngine)));
            nodeBuilder.setDirectPersistencySyncHandler(new DirectPersistencySyncHandler(this._spaceEngine));
        } else {
            nodeBuilder.setReplicaDataConsumer(new SpaceReplicaDataConsumer(this._typeManager, new SpaceEngineReplicaConsumerFacade(this._spaceEngine)));
        }
        int corePoolSize = 4;
        nodeBuilder.setAsyncHandlerProvider(new ScheduledThreadPoolAsyncHandlerProvider("ReplicationNodePool-" + this._fullSpaceName, corePoolSize));
        int partitionId = this._spaceEngine.getPartitionIdOneBased();
        if (partitionId == 0) {
            partitionId = 1;
        }
        ReplicationNodeConfig replicationNodeConfig = ReplicationNodeConfigBuilder.getInstance().createConfig(this._clusterInfo, this._clusterPolicy, nodeBuilder, filterManager, partitionId, this._storageAdapter, configReader, new SpaceReplicationChannelDataFilterBuilder(this._spaceEngine), new SpaceReplicationLifeCycleBuilder(this._spaceEngine));
        ReplicationNode replicationNode = new ReplicationNode(replicationNodeConfig, nodeBuilder, this._fullSpaceName, this._spaceEngine.getMetricRegistrator());
        AbstractSpaceReplicationEntryEventHandler entryHandler = this.getEntryHandler();
        replicationNode.setInEntryHandler(entryHandler);
        replicationNode.setInEvictEntryHandler(entryHandler);
        replicationNode.setInTransactionHandler(new SpaceReplicationTransactionEventHandler(this._spaceEngine, entryHandler));
        SpaceReplicationEntryLeaseEventHandler entryLeaseHandler = new SpaceReplicationEntryLeaseEventHandler(this._spaceEngine);
        replicationNode.setInEntryLeaseCancelledHandler(entryLeaseHandler);
        replicationNode.setInEntryLeaseExtendedHandler(entryLeaseHandler);
        replicationNode.setInEntryLeaseExpiredHandler(entryLeaseHandler);
        SpaceReplicationTemplateEventHandler templateHandler = new SpaceReplicationTemplateEventHandler(this._spaceEngine);
        replicationNode.setInNotifyTemplateCreatedHandler(templateHandler);
        replicationNode.setInNotifyTemplateRemovedHandler(templateHandler);
        replicationNode.setInNotifyTemplateLeaseExtendedHandler(templateHandler);
        replicationNode.setInNotifyTemplateLeaseExpiredHandler(templateHandler);
        SpaceReplicationMetadataEventHandler metadataHandler = new SpaceReplicationMetadataEventHandler(this._spaceEngine.getTypeManager(), this._spaceEngine);
        replicationNode.setInDataTypeCreatedHandler(metadataHandler);
        replicationNode.setInDataTypeIndexAddedHandler(metadataHandler);
        replicationNode.getAdmin().setNodeStateListener(new ReplicationNodeStateListener(this._spaceEngine));
        replicationNode.getAdmin().getRouterAdmin().enableIncomingCommunication();
        return replicationNode;
    }

    private AbstractSpaceReplicationEntryEventHandler getEntryHandler() {
        boolean requiresEvictionReplicationProtection;
        boolean allInCache;
        boolean isCentralAndExternalDB = this._storageAdapter.supportsExternalDB() && this._spaceEngine.getClusterPolicy().m_CacheLoaderConfig.centralDataSource;
        boolean bl = allInCache = this._spaceEngine.getConfigReader().getIntSpaceProperty("engine.cache_policy", !this._storageAdapter.supportsExternalDB() ? String.valueOf(1) : String.valueOf(0)) == 1;
        boolean blobStore = !allInCache && this._spaceEngine.getConfigReader().getIntSpaceProperty("engine.cache_policy", !this._storageAdapter.supportsExternalDB() ? String.valueOf(1) : String.valueOf(0)) == 3;
        boolean bl2 = requiresEvictionReplicationProtection = this._spaceEngine.hasMirror() && this._storageAdapter.supportsExternalDB() && !allInCache && !blobStore;
        AbstractSpaceReplicationEntryEventHandler entryHandler = this._clusterPolicy.isPrimaryElectionAvailable() ? (requiresEvictionReplicationProtection ? new PrimaryBackupSpaceReplicationEvictionProtectionEntryEventHandler(this._spaceEngine, isCentralAndExternalDB) : (this.isReplicatedPersistentBlobstore() && this._replicationBlobstoreBackupBulks ? new BlobstorePrimaryBackupSpaceReplicationEntryEventHandler(this._spaceEngine, isCentralAndExternalDB) : new PrimaryBackupSpaceReplicationEntryEventHandler(this._spaceEngine, isCentralAndExternalDB))) : new ActiveActiveSpaceReplicationEntryEventHandler(this._spaceEngine, isCentralAndExternalDB);
        return entryHandler;
    }

    private ReplicationNode createEmptyReplicationNode() {
        ReplicationNodeBuilder nodeBuilder = new ReplicationNodeBuilder();
        nodeBuilder.setReplicationRouterBuilder(XapExtensions.getInstance().getReplicationRouterBuilderFactory().createSpaceProxyReplicationRouterBuilder(this._spaceImpl, true));
        nodeBuilder.setReplicaDataProducerBuilder(new SpaceReplicaDataProducerBuilder(this._spaceEngine));
        nodeBuilder.setReplicaDataConsumer(new SpaceReplicaDataConsumer(this._typeManager, new SpaceEngineReplicaConsumerFacade(this._spaceEngine)));
        nodeBuilder.setAsyncHandlerProvider(new ScheduledThreadPoolAsyncHandlerProvider("ReplicationNodePool-" + this._fullSpaceName, 1));
        ReplicationNode replicationNode = new ReplicationNode(new ReplicationNodeConfig(), nodeBuilder, this._fullSpaceName, this._spaceEngine.getMetricRegistrator());
        replicationNode.getAdmin().getRouterAdmin().enableIncomingCommunication();
        return replicationNode;
    }

    private IReplicationProcessLogBuilder createReplicationProcessLog(ReplicationPacketDataMediator packetDataMediator) {
        ReplicationPacketDataConsumer dataConsumer = this.isReplicatedPersistentBlobstore() && this._replicationBlobstoreBackupBulks ? new BlobstoreReplicationPacketDataConsumer(this._typeManager, new SpaceEngineFixFacade(this._spaceEngine), packetDataMediator) : new ReplicationPacketDataConsumer(this._typeManager, new SpaceEngineFixFacade(this._spaceEngine), packetDataMediator);
        ReplicationProcessingType processingType = this._clusterPolicy.m_ReplicationPolicy.getProcessingType();
        switch (processingType) {
            case MULTIPLE_BUCKETS: {
                if (this.supportsConcurrentReplication()) {
                    return new MultiBucketSingleFileProcessLogBuilder(dataConsumer);
                }
                return new GlobalOrderProcessLogBuilder(dataConsumer);
            }
            case MULTIPLE_SOURCES: {
                if (this.supportsMultiSourceReplication()) {
                    return new MultiSourceSingleFileProcessLogBuilder(dataConsumer);
                }
                return new GlobalOrderProcessLogBuilder(dataConsumer);
            }
            case GLOBAL_ORDER: {
                return new GlobalOrderProcessLogBuilder(dataConsumer);
            }
        }
        throw new IllegalArgumentException();
    }

    private IReplicationBacklogBuilder createReplicationBacklog(IStorageAdapter storageAdapter, ReplicationPacketDataMediator packetDataMediator) {
        ReplicationPacketDataProducer dataProducer = this.isReplicatedPersistentBlobstore() && this._replicationBlobstoreBackupBulks ? new BlobstoreReplicationPacketDataProducer(this._spaceEngine, this._spaceEngine.isClusteredExternalDBEnabled(storageAdapter), this._clusterPolicy.getReplicationPolicy().isReplicateFullTake(), packetDataMediator) : new ReplicationPacketDataProducer(this._spaceEngine, this._spaceEngine.isClusteredExternalDBEnabled(storageAdapter), this._clusterPolicy.getReplicationPolicy().isReplicateFullTake(), packetDataMediator);
        ReplicationProcessingType processingType = this._clusterPolicy.m_ReplicationPolicy.getProcessingType();
        switch (processingType) {
            case MULTIPLE_BUCKETS: {
                if (this.supportsConcurrentReplication()) {
                    return new MultiBucketSingleFileBacklogBuilder(this._fullSpaceName, dataProducer);
                }
                return new GlobalOrderBacklogBuilder(dataProducer, this._fullSpaceName);
            }
            case MULTIPLE_SOURCES: {
                if (this.supportsMultiSourceReplication()) {
                    return new MultiSourceSingleFileBacklogBuilder(this._fullSpaceName, dataProducer);
                }
                return new GlobalOrderBacklogBuilder(dataProducer, this._fullSpaceName);
            }
            case GLOBAL_ORDER: {
                return new GlobalOrderBacklogBuilder(dataProducer, this._fullSpaceName);
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean supportsMultiSourceReplication() {
        String errorMessage = XapExtensions.getInstance().getReplicationNodeConfigBuilder().supportsMultiSourceReplication(this._clusterInfo);
        if (errorMessage != null) {
            boolean throwOnError;
            boolean bl = throwOnError = !Boolean.getBoolean("com.gs.replication.module.multisource");
            if (throwOnError) {
                throw new IllegalArgumentException(errorMessage + ", use 'cluster-config.groups.group.repl-policy.processing-type=global-order' instead");
            }
            if (!this._alreadyWarnedUnsupportedConfig) {
                if (_replicationNodeLogger.isLoggable(Level.WARNING)) {
                    _replicationNodeLogger.warning(StringUtils.NEW_LINE + "*********************************************************************" + StringUtils.NEW_LINE + errorMessage + "," + StringUtils.NEW_LINE + "reverting to Global order replication processing" + StringUtils.NEW_LINE + "*********************************************************************");
                }
                this._alreadyWarnedUnsupportedConfig = true;
            }
        }
        return errorMessage == null;
    }

    private boolean supportsConcurrentReplication() {
        String errorMessage = SpaceReplicationInitializer.supportsConcurrentReplication(this._clusterPolicy);
        if (errorMessage != null) {
            boolean throwOnError;
            boolean bl = throwOnError = !Boolean.getBoolean("com.gs.replication.module.concurrent");
            if (throwOnError) {
                throw new IllegalArgumentException(errorMessage + ", use 'cluster-config.groups.group.repl-policy.processing-type=global-order' instead");
            }
            if (!this._alreadyWarnedUnsupportedConfig) {
                if (_replicationNodeLogger.isLoggable(Level.WARNING)) {
                    _replicationNodeLogger.warning(StringUtils.NEW_LINE + "*********************************************************************" + StringUtils.NEW_LINE + errorMessage + "," + StringUtils.NEW_LINE + "reverting to Global order replication processing" + StringUtils.NEW_LINE + "*********************************************************************");
                }
                this._alreadyWarnedUnsupportedConfig = true;
            }
        }
        return errorMessage == null;
    }

    private static String supportsConcurrentReplication(ClusterPolicy clusterPolicy) {
        boolean hasExistingReplicationMembers;
        boolean primaryBackupGroup = clusterPolicy.isPrimaryElectionAvailable();
        boolean syncReplication = clusterPolicy.getReplicationPolicy().m_IsSyncReplicationEnabled;
        boolean hasMirror = clusterPolicy.getReplicationPolicy().isMirrorServiceEnabled();
        boolean isReliableAsync = clusterPolicy.getReplicationPolicy().isReliableAsyncRepl();
        boolean bl = hasExistingReplicationMembers = clusterPolicy.getReplicationPolicy().getReplicationTargetsCount() > 0;
        if (!syncReplication || !hasExistingReplicationMembers) {
            return "Async replication is not supported in Multiple bucket replication processing";
        }
        if (hasMirror && isReliableAsync && syncReplication && !primaryBackupGroup) {
            return "Mirror service with no backups is not supported in Multiple bucket replication processing";
        }
        return null;
    }
}

