/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.replication;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.ReplicationFilterManager;
import com.gigaspaces.internal.cluster.node.IReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationRouterBuilder;
import com.gigaspaces.internal.server.space.replication.SpaceReplicationInitializer;
import com.gigaspaces.internal.sync.mirror.MirrorService;

@InternalApi
public class SpaceReplicationManager {
    private final boolean _isReplicated;
    private final boolean _isReplicatedPersistentBlobstore;
    private final boolean _isSyncReplication;
    private final MirrorService _mirrorService;
    private final ReplicationFilterManager _replicationFilterManager;
    private final ReplicationNode _replicationNode;

    public SpaceReplicationManager(SpaceReplicationInitializer replicationInitializer) {
        this._isReplicated = replicationInitializer.isReplicated();
        this._isReplicatedPersistentBlobstore = replicationInitializer.isReplicatedPersistentBlobstore();
        this._isSyncReplication = replicationInitializer.isSyncReplication();
        this._mirrorService = replicationInitializer.getMirrorService();
        this._replicationFilterManager = replicationInitializer.getReplicationFilterManager();
        this._replicationNode = replicationInitializer.getReplicationNode();
    }

    public void close() {
        this._replicationNode.close();
        if (this._replicationFilterManager != null) {
            this._replicationFilterManager.close();
        }
    }

    public boolean isReplicated() {
        return this._isReplicated;
    }

    public boolean isReplicatedPersistentBlobstore() {
        return this._isReplicatedPersistentBlobstore;
    }

    public boolean isMirrorService() {
        return this._mirrorService != null;
    }

    public boolean isSyncReplication() {
        return this._isSyncReplication;
    }

    public MirrorService getMirrorService() {
        return this._mirrorService;
    }

    public ReplicationFilterManager getReplicationFilterManager() {
        return this._replicationFilterManager;
    }

    public IReplicationNode getReplicationNode() {
        return this._replicationNode;
    }

    public ReplicationRouterBuilder getReplicationRouterBuilder() {
        return this._replicationNode.getReplicationRouterBuilder();
    }

    public IReplicationRouter getReplicationRouter() {
        return this._replicationNode.getReplicationRouter();
    }
}

