/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.entry.VirtualEntry;
import com.gigaspaces.internal.metadata.EntryTypeDesc;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryPathGetter;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.gigaspaces.internal.utils.ReflectionUtils;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.cache.DefaultValueCloner;
import com.j_spaces.core.server.transaction.EntryXtnInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.jini.core.transaction.server.ServerTransaction;

public abstract class AbstractEntryData
implements ITransactionalEntryData {
    private static final long DUMMY_TTL_FOR_EXPIRED_ENTRIES = 1L;
    protected final EntryTypeDesc _entryTypeDesc;
    protected final int _versionID;
    protected final long _expirationTime;
    private final EntryXtnInfo _entryTxnInfo;

    protected AbstractEntryData(EntryTypeDesc entryTypeDesc, int version, long expirationTime, boolean createEmptyTxnInfoIfNon) {
        this._entryTypeDesc = entryTypeDesc;
        this._versionID = version;
        this._expirationTime = expirationTime;
        this._entryTxnInfo = createEmptyTxnInfoIfNon ? new EntryXtnInfo() : null;
    }

    protected AbstractEntryData(EntryTypeDesc entryTypeDesc, int version, long expirationTime, boolean cloneXtnInfo, AbstractEntryData other, boolean createEmptyTxnInfoIfNon) {
        this._entryTypeDesc = entryTypeDesc;
        this._versionID = version;
        this._expirationTime = expirationTime;
        this._entryTxnInfo = cloneXtnInfo && other._entryTxnInfo != null ? new EntryXtnInfo(other._entryTxnInfo) : (other._entryTxnInfo != null ? other._entryTxnInfo : (createEmptyTxnInfoIfNon ? new EntryXtnInfo() : null));
    }

    protected AbstractEntryData(AbstractEntryData other, EntryXtnInfo xtnInfo) {
        this._entryTypeDesc = other._entryTypeDesc;
        this._versionID = other._versionID;
        this._expirationTime = other._expirationTime;
        this._entryTxnInfo = xtnInfo;
    }

    @Override
    public ITypeDesc getSpaceTypeDescriptor() {
        return this._entryTypeDesc.getTypeDesc();
    }

    @Override
    public EntryTypeDesc getEntryTypeDesc() {
        return this._entryTypeDesc;
    }

    @Override
    public Object getPropertyValue(String name) {
        ITypeDesc typeDesc = this._entryTypeDesc.getTypeDesc();
        int pos = typeDesc.getFixedPropertyPosition(name);
        if (pos != -1) {
            return this.getFixedPropertyValue(pos);
        }
        if (typeDesc.supportsDynamicProperties()) {
            Map<String, Object> dynamicProperties = this.getDynamicProperties();
            return dynamicProperties != null ? dynamicProperties.get(name) : null;
        }
        throw new IllegalArgumentException("Unknown property name '" + name + "' in type " + this.getSpaceTypeDescriptor().getTypeName());
    }

    @Override
    public int getVersion() {
        return this._versionID;
    }

    @Override
    public long getExpirationTime() {
        return this._expirationTime;
    }

    @Override
    public long getTimeToLive(boolean useDummyIfRelevant) {
        return AbstractEntryData.getTimeToLive(this._expirationTime, useDummyIfRelevant);
    }

    public static long getTimeToLive(long expirationTime, boolean useDummyIfRelevant) {
        long timeToLive = expirationTime != Long.MAX_VALUE ? expirationTime - SystemTime.timeMillis() : expirationTime;
        return useDummyIfRelevant && timeToLive <= 0L && expirationTime != Long.MAX_VALUE ? 1L : timeToLive;
    }

    @Override
    public EntryXtnInfo getEntryXtnInfo() {
        return this._entryTxnInfo;
    }

    @Override
    public boolean anyReadLockXtn() {
        return this._entryTxnInfo == null ? false : this._entryTxnInfo.anyReadLockXtn();
    }

    @Override
    public List<XtnEntry> getReadLocksOwners() {
        return this._entryTxnInfo == null ? null : this._entryTxnInfo.getReadLocksOwners();
    }

    @Override
    public void addReadLockOwner(XtnEntry xtn) {
        this._entryTxnInfo.addReadLockOwner(xtn);
    }

    @Override
    public void removeReadLockOwner(XtnEntry xtn) {
        if (this._entryTxnInfo != null) {
            this._entryTxnInfo.removeReadLockOwner(xtn);
        }
    }

    @Override
    public void clearReadLockOwners() {
        if (this._entryTxnInfo != null) {
            this._entryTxnInfo.clearReadLockOwners();
        }
    }

    @Override
    public XtnEntry getWriteLockOwner() {
        return this._entryTxnInfo == null ? null : this._entryTxnInfo.getWriteLockOwner();
    }

    @Override
    public void setWriteLockOwner(XtnEntry writeLockOwner) {
        if (this._entryTxnInfo == null && writeLockOwner != null) {
            throw new RuntimeException("entryTxnInfo is null");
        }
        if (this._entryTxnInfo != null) {
            this._entryTxnInfo.setWriteLockOwner(writeLockOwner);
        }
    }

    @Override
    public ServerTransaction getWriteLockTransaction() {
        XtnEntry owner = this.getWriteLockOwner();
        return owner == null ? null : owner.m_Transaction;
    }

    @Override
    public int getWriteLockOperation() {
        return this._entryTxnInfo == null ? 0 : this._entryTxnInfo.getWriteLockOperation();
    }

    @Override
    public void setWriteLockOperation(int writeLockOperation) {
        this._entryTxnInfo.setWriteLockOperation(writeLockOperation);
    }

    @Override
    public XtnEntry getXidOriginated() {
        return this._entryTxnInfo == null ? null : this._entryTxnInfo.getXidOriginated();
    }

    @Override
    public void setXidOriginated(XtnEntry xidOriginated) {
        if (this._entryTxnInfo == null && xidOriginated != null) {
            throw new RuntimeException("entryTxnInfo is null");
        }
        if (this._entryTxnInfo != null) {
            this._entryTxnInfo.setXidOriginated(xidOriginated);
        }
    }

    @Override
    public ServerTransaction getXidOriginatedTransaction() {
        XtnEntry originated = this.getXidOriginated();
        return originated == null ? null : originated.m_Transaction;
    }

    @Override
    public IEntryHolder getOtherUpdateUnderXtnEntry() {
        return this._entryTxnInfo == null ? null : this._entryTxnInfo.getOtherUpdateUnderXtnEntry();
    }

    @Override
    public void setOtherUpdateUnderXtnEntry(IEntryHolder eh) {
        if (this._entryTxnInfo == null) {
            if (eh == null) {
                return;
            }
            throw new RuntimeException("entryTxnInfo is null");
        }
        this._entryTxnInfo.setOtherUpdateUnderXtnEntry(eh);
    }

    @Override
    public Collection<ITemplateHolder> getWaitingFor() {
        return this._entryTxnInfo == null ? null : this._entryTxnInfo.getWaitingFor();
    }

    @Override
    public void initWaitingFor() {
        this._entryTxnInfo.initWaitingFor();
    }

    @Override
    public boolean isExpired(long limit) {
        IEntryHolder original;
        long leaseToCompare = this.getExpirationTime();
        if (this.getWriteLockOwner() != null && this.getOtherUpdateUnderXtnEntry() != null && (original = this.getOtherUpdateUnderXtnEntry()) != null) {
            leaseToCompare = Math.max(leaseToCompare, original.getEntryData().getExpirationTime());
        }
        return leaseToCompare < limit;
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(SystemTime.timeMillis());
    }

    @Override
    public Object getPathValue(String path) {
        if (!path.contains(".")) {
            return this.getPropertyValue(path);
        }
        return new SpaceEntryPathGetter(path).getValue(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setPathValue(String path, Object value) {
        if (!path.contains(".")) {
            int pos;
            if (this.getSpaceTypeDescriptor().getIdPropertyName().equals(path)) {
                this.throwChangeIdException(value);
            }
            if ((pos = this.getSpaceTypeDescriptor().getFixedPropertyPosition(path)) >= 0) {
                PropertyInfo fixedProperty = this.getSpaceTypeDescriptor().getFixedProperty(pos);
                if (value == null) {
                    this.validateCanSetNull(path, pos, fixedProperty);
                } else {
                    boolean illegalAssignment = false;
                    if (ReflectionUtils.isPrimitive(fixedProperty.getTypeName())) {
                        illegalAssignment = !ReflectionUtils.isPrimitiveAssignable(fixedProperty.getTypeName(), value.getClass());
                    } else {
                        boolean bl = illegalAssignment = !fixedProperty.getType().isAssignableFrom(value.getClass());
                    }
                    if (illegalAssignment) {
                        throw new IllegalArgumentException("Cannot set value [" + value + "] of class [" + value.getClass() + "] to property '" + path + "' of class [" + fixedProperty.getType() + "]");
                    }
                }
                this.setFixedPropertyValue(pos, value);
                return;
            } else {
                if (!this.getSpaceTypeDescriptor().supportsDynamicProperties()) throw new IllegalArgumentException("Unknown property name '" + path + "'");
                this.setDynamicPropertyValue(path, value);
            }
            return;
        } else {
            String rootPropertyName = path.substring(0, path.indexOf("."));
            if (this.getSpaceTypeDescriptor().getIdPropertyName().equals(rootPropertyName)) {
                this.throwChangeIdException(value);
            }
            this.deepCloneProperty(rootPropertyName);
            int propertyNameSeperatorIndex = path.lastIndexOf(".");
            String pathToParent = path.substring(0, propertyNameSeperatorIndex);
            String propertyName = path.substring(propertyNameSeperatorIndex + 1);
            Object valueParent = new SpaceEntryPathGetter(pathToParent).getValue(this);
            if (valueParent instanceof Map) {
                ((Map)valueParent).put(propertyName, value);
                return;
            } else if (valueParent instanceof VirtualEntry) {
                ((VirtualEntry)valueParent).setProperty(propertyName, value);
                return;
            } else {
                Class<?> type = valueParent.getClass();
                SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(type);
                SpacePropertyInfo propertyInfo = typeInfo.getProperty(propertyName);
                if (propertyInfo == null) {
                    throw new IllegalArgumentException("Property '" + propertyName + "' is not a member of " + type.getName() + " in '" + path + "'");
                }
                propertyInfo.setValue(valueParent, value);
            }
        }
    }

    private void validateCanSetNull(String path, int pos, SpacePropertyDescriptor fixedProperty) {
        if (ReflectionUtils.isPrimitive(fixedProperty.getTypeName()) && !this.getSpaceTypeDescriptor().getIntrospector(null).propertyHasNullValue(pos)) {
            throw new IllegalArgumentException("Cannot set null to property '" + path + "' of class [" + fixedProperty.getType() + "] because it has no null value defined");
        }
    }

    private void throwChangeIdException(Object value) {
        Object currentId = this.getPropertyValue(this.getSpaceTypeDescriptor().getIdPropertyName());
        throw new UnsupportedOperationException("Attempting to change the id property named '" + this.getSpaceTypeDescriptor().getIdPropertyName() + "' of type '" + this.getSpaceTypeDescriptor().getTypeName() + "' which has a current value of [" + currentId + "] with a new value [" + value + "]. Changing the id property of an existing entry is not allowed.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unsetPath(String path) {
        if (!path.contains(".")) {
            int pos = this.getSpaceTypeDescriptor().getFixedPropertyPosition(path);
            if (pos >= 0) {
                PropertyInfo fixedProperty = this.getSpaceTypeDescriptor().getFixedProperty(pos);
                this.validateCanSetNull(path, pos, fixedProperty);
                this.setFixedPropertyValue(pos, null);
                return;
            } else {
                if (!this.getSpaceTypeDescriptor().supportsDynamicProperties()) throw new IllegalArgumentException("Unknown property name '" + path + "'");
                this.unsetDynamicPropertyValue(path);
            }
            return;
        } else {
            String rootPropertyName = path.substring(0, path.indexOf("."));
            if (this.getSpaceTypeDescriptor().getIdPropertyName().equals(rootPropertyName)) {
                throw new UnsupportedOperationException("Attempting to unset the id property named '" + this.getSpaceTypeDescriptor().getIdPropertyName() + "' of type '" + this.getSpaceTypeDescriptor().getTypeName() + "' which has a current value of [" + this.getPropertyValue(this.getSpaceTypeDescriptor().getIdPropertyName()) + "]. Changing the id property of an existing entry is not allowed.");
            }
            this.deepCloneProperty(rootPropertyName);
            int propertyNameSeperatorIndex = path.lastIndexOf(".");
            String pathToParent = path.substring(0, propertyNameSeperatorIndex);
            String propertyName = path.substring(propertyNameSeperatorIndex + 1);
            Object valueParent = new SpaceEntryPathGetter(pathToParent).getValue(this);
            if (valueParent instanceof Map) {
                ((Map)valueParent).remove(propertyName);
                return;
            } else if (valueParent instanceof VirtualEntry) {
                ((VirtualEntry)valueParent).removeProperty(propertyName);
                return;
            } else {
                Class<?> type = valueParent.getClass();
                SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(type);
                SpacePropertyInfo propertyInfo = typeInfo.getProperty(propertyName);
                if (propertyInfo == null) {
                    throw new IllegalArgumentException("Property '" + propertyName + "' is not a member of " + type.getName() + " in '" + path + "'");
                }
                propertyInfo.setValue(valueParent, null);
            }
        }
    }

    private void deepCloneProperty(String rootPropertyName) {
        Object propertyValue = this.getPropertyValue(rootPropertyName);
        Object cloneValue = DefaultValueCloner.get().cloneValue(propertyValue, false, null, "", this.getSpaceTypeDescriptor().getTypeName());
        this.setPathValue(rootPropertyName, cloneValue);
    }
}

