/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceUidFactory;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ISpaceItem;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import com.j_spaces.kernel.locks.IEvictableLockObject;
import java.rmi.MarshalledObject;
import java.util.logging.Logger;

public abstract class AbstractSpaceItem
implements ISpaceItem,
Textualizable {
    private final transient IServerTypeDesc _typeDesc;
    private String _uid;
    private long _scn;
    private boolean _transient;
    private volatile transient boolean _deleted;
    private volatile transient boolean _maybeUnderXtn;
    private int _order;

    protected AbstractSpaceItem(IServerTypeDesc typeDesc, String uid, long scn, boolean isTransient) {
        this._typeDesc = typeDesc;
        this._uid = uid;
        this._scn = scn;
        this._transient = isTransient;
    }

    protected AbstractSpaceItem(IEntryHolder other) {
        this(other.getServerTypeDesc(), other.getUID(), other.getSCN(), other.isTransient());
    }

    @Override
    public IServerTypeDesc getServerTypeDesc() {
        return this._typeDesc;
    }

    @Override
    public String getClassName() {
        return this._typeDesc.getTypeName();
    }

    @Override
    public String getUID() {
        return this._uid;
    }

    public void setUID(String uid) {
        this._uid = uid;
    }

    @Override
    public long getSCN() {
        return this._scn;
    }

    public void setSCN(long scn) {
        this._scn = scn;
    }

    public long getExpirationTime() {
        return this.getEntryData().getExpirationTime();
    }

    @Override
    public abstract void setExpirationTime(long var1);

    public int getVersionID() {
        return this.getEntryData().getVersion();
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public boolean isMaybeUnderXtn() {
        return this._maybeUnderXtn;
    }

    @Override
    public void setMaybeUnderXtn(boolean value) {
        this._maybeUnderXtn = value;
    }

    @Override
    public boolean isDeleted() {
        return this._deleted;
    }

    @Override
    public void setDeleted(boolean isDeleted) {
        this._deleted = isDeleted;
    }

    public void dump(Logger logger, String msg) {
        logger.info(msg);
        logger.info("Start Dumping " + this.getClass().getName());
        logger.info("Class Name: " + this.getClassName());
        logger.info("UID: " + this.getUID());
        logger.info("SCN: " + this.getSCN());
        logger.info("Transient: " + this.isTransient());
        logger.info("Expiration Time : " + this.getExpirationTime());
        logger.info("Deleted: " + this.isDeleted());
        logger.info("MaybeUnderXtn: " + this.isMaybeUnderXtn());
        logger.info("HasWaitingFor: " + this.isHasWaitingFor());
    }

    @Override
    public boolean isLockSubject() {
        return true;
    }

    public IEvictableLockObject getEvictableLockObject() {
        return null;
    }

    public boolean isShadow() {
        return false;
    }

    public boolean hasShadow() {
        return this.hasShadow(false);
    }

    public abstract boolean hasShadow(boolean var1);

    public int getNotifyType() {
        return 0;
    }

    public MarshalledObject getHandback() {
        return null;
    }

    public int getOrder() {
        return this._order;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public Object getRoutingValue() {
        IEntryData edata = this.getEntryData();
        if (edata.getNumOfFixedProperties() == 0) {
            return null;
        }
        ITypeDesc typeDesc = edata.getEntryTypeDesc().getTypeDesc();
        String routingPropertyName = typeDesc.getRoutingPropertyName();
        if (routingPropertyName == null) {
            return null;
        }
        if (typeDesc.isAutoGenerateRouting()) {
            return SpaceUidFactory.extractPartitionId(this.getUID());
        }
        return edata.getPropertyValue(routingPropertyName);
    }

    public Object getEntryId() {
        if (this.getEntryData().getEntryTypeDesc().getTypeDesc().isAutoGenerateId()) {
            return this.getUID();
        }
        int identifierPropertyId = this.getEntryData().getEntryTypeDesc().getTypeDesc().getIdentifierPropertyId();
        if (identifierPropertyId == -1) {
            return null;
        }
        return this.getEntryData().getFixedPropertyValue(identifierPropertyId);
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("typeName", this.getClassName());
        textualizer.append("uid", this.getUID());
    }

    public String toString() {
        return Textualizer.toString(this);
    }
}

