/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.storage.AbstractSpaceItem;
import com.gigaspaces.internal.server.storage.FlatEntryData;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.gigaspaces.internal.server.storage.ShadowEntryHolder;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.server.transaction.EntryXtnInfo;
import com.j_spaces.kernel.locks.ILockObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class EntryHolder
extends AbstractSpaceItem
implements IEntryHolder {
    private ITransactionalEntryData _entryData;
    private boolean _hasWaitingFor;
    private boolean _unStable;

    public EntryHolder(IServerTypeDesc typeDesc, String uid, long scn, boolean isTransient, ITransactionalEntryData entryData) {
        super(typeDesc, uid, scn, isTransient);
        if (entryData != null) {
            this._entryData = entryData;
            this.setMaybeUnderXtn(entryData.getXidOriginated() != null);
        }
    }

    protected EntryHolder(IEntryHolder other) {
        super(other);
        this._entryData = other.getTxnEntryData().createCopyWithoutTxnInfo();
    }

    @Override
    public IEntryHolder createCopy() {
        return new EntryHolder(this);
    }

    @Override
    public IEntryHolder createDummy() {
        FlatEntryData ed = new FlatEntryData(new Object[this.getEntryData().getNumOfFixedProperties()], null, this.getEntryData().getEntryTypeDesc(), 1, Long.MAX_VALUE, false);
        EntryHolder dummy = new EntryHolder(this.getServerTypeDesc(), this.getUID(), this.getSCN(), this.isTransient(), ed);
        dummy.setDeleted(true);
        return dummy;
    }

    @Override
    public boolean isHasWaitingFor() {
        return this._hasWaitingFor;
    }

    @Override
    public void setHasWaitingFor(boolean value) {
        this._hasWaitingFor = value;
    }

    @Override
    public boolean isUnstable() {
        return this._unStable;
    }

    @Override
    public void setunStable(boolean value) {
        this._unStable = value;
    }

    @Override
    public IEntryData getEntryData() {
        return this._entryData;
    }

    @Override
    public ITransactionalEntryData getTxnEntryData() {
        return this._entryData;
    }

    @Override
    public void updateVersionAndExpiration(int versionID, long expiration) {
        this._entryData = this._entryData.createCopyWithTxnInfo(versionID, expiration);
    }

    @Override
    public void updateEntryData(IEntryData newEntryData, long expirationTime) {
        this._entryData = this._entryData.createCopy(false, newEntryData, expirationTime);
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        ITransactionalEntryData ed = this._entryData;
        if (ed.getExpirationTime() == expirationTime) {
            return;
        }
        this._entryData = ed.createCopyWithTxnInfo(ed.getVersion(), expirationTime);
    }

    @Override
    public void resetEntryXtnInfo() {
        this._entryData = this._entryData.createCopyWithoutTxnInfo();
    }

    @Override
    public void resetWriteLockOwner() {
        if (this._entryData.getWriteLockOwner() == null) {
            return;
        }
        EntryXtnInfo ex = new EntryXtnInfo(this._entryData.getEntryXtnInfo());
        ex.setWriteLockOwner(null);
        this._entryData = this._entryData.createCopyWithSuppliedTxnInfo(ex);
    }

    @Override
    public void setWriteLockOwnerAndOperation(XtnEntry writeLockOwner, int writeLockOperation) {
        this.setWriteLockOwnerAndOperation(writeLockOwner, writeLockOperation, true);
    }

    @Override
    public void setWriteLockOwnerAndOperation(XtnEntry writeLockOwner, int writeLockOperation, boolean createSnapshot) {
        if (!createSnapshot && this._entryData.getEntryXtnInfo() == null) {
            createSnapshot = true;
        }
        if (!createSnapshot) {
            ITransactionalEntryData ed = this._entryData;
            ed.setWriteLockOwner(writeLockOwner);
            ed.setWriteLockOperation(writeLockOperation);
        } else {
            EntryXtnInfo ex = EntryXtnInfo.createCloneOrEmptyInfo(this._entryData.getEntryXtnInfo());
            ex.setWriteLockOwner(writeLockOwner);
            ex.setWriteLockOperation(writeLockOperation);
            this._entryData = this._entryData.createCopyWithSuppliedTxnInfo(ex);
        }
    }

    @Override
    public void setWriteLockOwnerOperationAndShadow(XtnEntry writeLockOwner, int writeLockOperation, IEntryHolder otherEh) {
        EntryXtnInfo ex = EntryXtnInfo.createCloneOrEmptyInfo(this._entryData.getEntryXtnInfo());
        ex.setWriteLockOwner(writeLockOwner);
        ex.setWriteLockOperation(writeLockOperation);
        ex.setOtherUpdateUnderXtnEntry(otherEh);
        this._entryData = this._entryData.createCopyWithSuppliedTxnInfo(ex);
    }

    @Override
    public void restoreUpdateXtnRollback(IEntryData entryData) {
        ITransactionalEntryData newed = this._entryData.createCopy(false, entryData, entryData.getExpirationTime());
        EntryXtnInfo ex = null;
        ex = ((ITransactionalEntryData)entryData).getEntryXtnInfo() != null ? new EntryXtnInfo(this._entryData.getEntryXtnInfo()) : new EntryXtnInfo();
        ex.setOtherUpdateUnderXtnEntry(null);
        this._entryData = newed.createCopyWithSuppliedTxnInfo(ex);
    }

    @Override
    public void setWriteLockOperation(int writeLockOperation, boolean createSnapshot) {
        if (!createSnapshot && this._entryData.getEntryXtnInfo() == null) {
            createSnapshot = true;
        }
        if (createSnapshot) {
            EntryXtnInfo ex = EntryXtnInfo.createCloneOrEmptyInfo(this._entryData.getEntryXtnInfo());
            ex.setWriteLockOperation(writeLockOperation);
            this._entryData = this._entryData.createCopyWithSuppliedTxnInfo(ex);
        } else {
            this._entryData.setWriteLockOperation(writeLockOperation);
        }
    }

    @Override
    public void resetXidOriginated() {
        if (this._entryData.getEntryXtnInfo() != null) {
            this._entryData.setXidOriginated(null);
        }
    }

    @Override
    public XtnEntry getXidOriginated() {
        return this._entryData.getXidOriginated();
    }

    @Override
    public ServerTransaction getXidOriginatedTransaction() {
        return this._entryData.getXidOriginatedTransaction();
    }

    @Override
    public void setOtherUpdateUnderXtnEntry(IEntryHolder eh) {
        if (eh == null && this._entryData.getEntryXtnInfo() == null) {
            return;
        }
        EntryXtnInfo ex = EntryXtnInfo.createCloneOrEmptyInfo(this._entryData.getEntryXtnInfo());
        ex.setOtherUpdateUnderXtnEntry(eh);
        this._entryData = this._entryData.createCopyWithSuppliedTxnInfo(ex);
    }

    public boolean isUnderPendingUpdate() {
        return this.isShadow() || this.hasShadow();
    }

    @Override
    public String getUidToOperateBy() {
        return this.getUID();
    }

    @Override
    public void dump(Logger logger, String msg) {
        super.dump(logger, msg);
        logger.info("Order: " + this.getOrder());
        int numOfFields = this._entryData.getNumOfFixedProperties();
        for (int pos = 0; pos < numOfFields; ++pos) {
            logger.info("Object " + this._entryData.getFixedPropertyValue(pos));
        }
        logger.info("WriteLockOwner : " + this.getWriteLockTransaction());
        List<XtnEntry> rlo = this.getReadLockOwners();
        if (rlo != null) {
            for (int pos = 0; pos < this.getReadLockOwners().size(); ++pos) {
                logger.info("ReadLockOwners: " + rlo.get(pos));
            }
        }
        logger.info("WriteLockOperation : " + this.getWriteLockOperation());
        logger.info("XidOriginated : " + this.getXidOriginatedTransaction());
    }

    @Override
    public boolean anyReadLockXtn() {
        ITransactionalEntryData entryData = this._entryData;
        return entryData.anyReadLockXtn();
    }

    @Override
    public List<XtnEntry> getReadLockOwners() {
        ITransactionalEntryData entryData = this._entryData;
        return entryData.getReadLocksOwners();
    }

    @Override
    public void addReadLockOwner(XtnEntry xtn) {
        if (this._entryData.getEntryXtnInfo() == null) {
            this._entryData = this._entryData.createCopyWithTxnInfo(true);
        }
        ITransactionalEntryData entryData = this._entryData;
        entryData.addReadLockOwner(xtn);
    }

    @Override
    public void removeReadLockOwner(XtnEntry xtn) {
        if (this._entryData.getEntryXtnInfo() == null) {
            return;
        }
        ITransactionalEntryData entryData = this._entryData;
        entryData.removeReadLockOwner(xtn);
    }

    @Override
    public void clearReadLockOwners() {
        if (this._entryData.getEntryXtnInfo() == null) {
            return;
        }
        ITransactionalEntryData entryData = this._entryData;
        entryData.clearReadLockOwners();
    }

    @Override
    public XtnEntry getWriteLockOwner() {
        ITransactionalEntryData entryData = this._entryData;
        return entryData.getWriteLockOwner();
    }

    @Override
    public boolean isEntryUnderWriteLockXtn() {
        return this.getWriteLockOwner() != null;
    }

    @Override
    public int getWriteLockOperation() {
        ITransactionalEntryData entryData = this._entryData;
        return entryData.getWriteLockOperation();
    }

    @Override
    public ServerTransaction getWriteLockTransaction() {
        ITransactionalEntryData entryData = this._entryData;
        return entryData.getWriteLockTransaction();
    }

    private void initWaitingFor() {
        if (this._entryData.getEntryXtnInfo() == null) {
            this._entryData = this._entryData.createCopyWithTxnInfo(true);
        }
        ITransactionalEntryData entryData = this._entryData;
        entryData.initWaitingFor();
    }

    @Override
    public Collection<ITemplateHolder> getTemplatesWaitingForEntry() {
        ITransactionalEntryData entryData = this._entryData;
        return entryData.getWaitingFor();
    }

    @Override
    public Collection<ITemplateHolder> getCopyOfTemplatesWaitingForEntry() {
        if (this.getTemplatesWaitingForEntry() != null && !this.getTemplatesWaitingForEntry().isEmpty()) {
            return new ArrayList<ITemplateHolder>(this.getTemplatesWaitingForEntry());
        }
        return null;
    }

    @Override
    public void addTemplateWaitingForEntry(ITemplateHolder template) {
        if (this.getTemplatesWaitingForEntry() == null) {
            this.initWaitingFor();
        }
        if (!this.getTemplatesWaitingForEntry().contains(template)) {
            this.getTemplatesWaitingForEntry().add(template);
        }
        if (this.getTemplatesWaitingForEntry().size() == 1 && !this.isHasWaitingFor()) {
            this.setHasWaitingFor(true);
        }
    }

    @Override
    public void removeTemplateWaitingForEntry(ITemplateHolder template) {
        if (this.getTemplatesWaitingForEntry() != null) {
            this.getTemplatesWaitingForEntry().remove(template);
        }
        if (this.getTemplatesWaitingForEntry() != null && this.getTemplatesWaitingForEntry().isEmpty() && this.isHasWaitingFor()) {
            this.setHasWaitingFor(false);
        }
    }

    protected IEntryHolder getOtherUpdateUnderXtnEntry() {
        ITransactionalEntryData entryData = this._entryData;
        return entryData.getOtherUpdateUnderXtnEntry();
    }

    @Override
    public boolean hasShadow(boolean safeEntry) {
        boolean hasShadow;
        boolean bl = hasShadow = !this.isShadow() && this.getOtherUpdateUnderXtnEntry() != null;
        return safeEntry ? hasShadow : hasShadow && this.isMaybeUnderXtn();
    }

    @Override
    public ShadowEntryHolder getShadow() {
        if (this.isShadow()) {
            return (ShadowEntryHolder)this;
        }
        if (this.hasShadow()) {
            return (ShadowEntryHolder)this.getOtherUpdateUnderXtnEntry();
        }
        return null;
    }

    @Override
    public IEntryHolder getMaster() {
        return this.isShadow() ? this.getOtherUpdateUnderXtnEntry() : this;
    }

    @Override
    public boolean isExpired(long limit) {
        ITransactionalEntryData ed = this._entryData;
        return ed.isExpired(limit);
    }

    @Override
    public boolean isExpired() {
        ITransactionalEntryData ed = this._entryData;
        return ed.isExpired();
    }

    @Override
    public boolean isSameEntryInstance(IEntryHolder other) {
        return this == other;
    }

    @Override
    public boolean isBlobStoreEntry() {
        return false;
    }

    @Override
    public IEntryHolder getOriginalEntryHolder() {
        return this;
    }

    @Override
    public ILockObject getExternalLockObject() {
        return null;
    }
}

