/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.EntryTypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.server.storage.EntryHolder;
import com.gigaspaces.internal.server.storage.FlatEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.gigaspaces.internal.server.storage.ShadowEntryHolder;
import com.gigaspaces.internal.server.storage.UserTypeEntryData;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.cache.EntryCacheInfoFactory;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import com.j_spaces.core.client.ClientUIDHandler;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import java.util.ArrayList;

@InternalApi
public class EntryHolderFactory {
    protected EntryHolderFactory() {
    }

    public static IEntryHolder createEntryHolder(IServerTypeDesc typeDesc, IEntryPacket entryPacket, EntryDataType entryDataType, String uid, long expirationTime, XtnEntry xidOriginated, long scn, boolean blobStoreEntryHolder) {
        return EntryHolderFactory.createEntryHolder(typeDesc, entryPacket, entryDataType, uid, expirationTime, xidOriginated, scn, -1, false, blobStoreEntryHolder);
    }

    public static IEntryHolder createEntryHolder(IServerTypeDesc typeDesc, IEntryPacket entryPacket, EntryDataType entryDataType, String uid, long expirationTime, XtnEntry xidOriginated, long scn, int versionID, boolean keepExpiration, boolean blobStoreEntryHolder) {
        if (blobStoreEntryHolder) {
            return EntryHolderFactory.createBlobStoreEntryHolder(typeDesc, entryPacket, entryDataType, uid, expirationTime, xidOriginated, scn, versionID, keepExpiration);
        }
        ITransactionalEntryData entryData = EntryHolderFactory.createEntryData(entryPacket, entryDataType, versionID, expirationTime, xidOriginated != null, keepExpiration);
        if (xidOriginated != null) {
            entryData.setXidOriginated(xidOriginated);
        }
        return new EntryHolder(typeDesc, uid, scn, entryPacket.isTransient(), entryData);
    }

    public static IEntryHolder createEntryHolder(IServerTypeDesc typeDesc, IEntryPacket entryPacket, EntryDataType entryDataType) {
        String uid = entryPacket.getUID() != null ? entryPacket.getUID() : ClientUIDHandler.createUIDFromName(entryPacket.getPropertyValue(typeDesc.getTypeDesc().getDefaultPropertyName()).toString(), entryPacket.getTypeName());
        int version = entryPacket.getVersion();
        ITransactionalEntryData entryData = EntryHolderFactory.createEntryData(entryPacket, entryDataType, version > 0 ? version : 1, -1L, false, false);
        return new EntryHolder(typeDesc, uid, SystemTime.timeMillis(), entryPacket.isTransient(), entryData);
    }

    public static IEntryHolder createEntryHolder(IServerTypeDesc typeDesc, ITransactionalEntryData entryData, String uid, boolean isTransient) {
        return new EntryHolder(typeDesc, uid, SystemTime.timeMillis(), isTransient, entryData);
    }

    public static ShadowEntryHolder createShadowEntryHolder(IEntryHolder master, ArrayList<IObjectInfo<IEntryCacheInfo>> backRefs, int[] backrefIndexPos, IStoredList<Object> leaseManagerListRef, IObjectInfo<Object> leaseManagerPosRef) {
        return new ShadowEntryHolder(master, backRefs, backrefIndexPos, leaseManagerListRef, leaseManagerPosRef);
    }

    private static IEntryHolder createBlobStoreEntryHolder(IServerTypeDesc typeDesc, IEntryPacket entryPacket, EntryDataType entryDataType, String uid, long expirationTime, XtnEntry xidOriginated, long scn, int versionID, boolean keepExpiration) {
        ITransactionalEntryData entryData = EntryHolderFactory.createEntryData(entryPacket, entryDataType, versionID, expirationTime, xidOriginated != null, keepExpiration);
        if (xidOriginated != null) {
            entryData.setXidOriginated(xidOriginated);
        }
        BlobStoreEntryHolder entryHolder = new BlobStoreEntryHolder(typeDesc, uid, scn, entryPacket.isTransient(), entryData, false);
        EntryCacheInfoFactory.createBlobStoreEntryCacheInfo(entryHolder);
        return entryHolder;
    }

    private static ITransactionalEntryData createEntryData(IEntryPacket entryPacket, EntryDataType entryDataType, int versionID, long expiration, boolean createXtnEntryInfo, boolean keepExpiration) {
        long lease;
        EntryType entryType = entryPacket.getEntryType();
        if (entryType == null) {
            throw new IllegalStateException("entryPacket.getEntryType() is null (packet class: " + entryPacket.getClass().getName() + ").");
        }
        EntryTypeDesc entryTypeDesc = entryPacket.getTypeDescriptor().getEntryTypeDesc(entryType);
        int version = versionID > 0 ? versionID : entryPacket.getVersion();
        long l = lease = expiration > 0L || keepExpiration ? expiration : LeaseManager.toAbsoluteTime(entryPacket.getTTL());
        if (entryDataType == EntryDataType.FLAT) {
            return new FlatEntryData(entryPacket.getFieldValues(), entryPacket.getDynamicProperties(), entryTypeDesc, version, lease, createXtnEntryInfo);
        }
        return new UserTypeEntryData(entryPacket.toObject(entryType), entryTypeDesc, version, lease, createXtnEntryInfo);
    }
}

