/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.EntryTypeDesc;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryPathGetter;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ISwapExternalizable;
import com.gigaspaces.internal.server.storage.AbstractEntryData;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.server.storage.ICustomTypeDescLoader;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

@InternalApi
public class ExternalizableServerEntry
implements IEntryData,
Externalizable,
ICustomTypeDescLoader,
ISwapExternalizable {
    private static final long serialVersionUID = 1L;
    private transient EntryTypeDesc _entryTypeDesc;
    private transient ITypeDesc _typeDesc;
    private String _typeName;
    private int _typeChecksum;
    private Object[] _fixedProperties;
    private Map<String, Object> _dynamicProperties;
    private int _version;
    private long _expirationTime;
    private EntryType _entryType;

    public ExternalizableServerEntry() {
    }

    public ExternalizableServerEntry(IEntryData entry) {
        this._entryTypeDesc = entry.getEntryTypeDesc();
        this._entryType = entry.getEntryTypeDesc().getEntryType();
        this._typeDesc = entry.getEntryTypeDesc().getTypeDesc();
        this._typeName = this._typeDesc.getTypeName();
        this._typeChecksum = this._typeDesc.getChecksum();
        this._fixedProperties = entry.getFixedPropertiesValues();
        this._dynamicProperties = entry.getDynamicProperties();
        this._version = entry.getVersion();
        this._expirationTime = entry.getExpirationTime();
    }

    @Override
    public void loadTypeDescriptor(SpaceTypeManager typeManager) {
        ITypeDesc typeDesc = typeManager.getTypeDesc(this._typeName);
        if (typeDesc == null) {
            throw new SpaceMetadataException("Failed to load type descriptor for type [" + this._typeName + "].");
        }
        if (typeDesc.getChecksum() != this._typeChecksum) {
            throw new SpaceMetadataException("Inconsistent checksum for type [" + this._typeName + "] -  stream checksum: " + this._typeChecksum + ", space checksum: " + typeDesc.getChecksum());
        }
        this._typeDesc = typeDesc;
        this._entryTypeDesc = this._typeDesc.getEntryTypeDesc(this._entryType);
    }

    @Override
    public EntryTypeDesc getEntryTypeDesc() {
        return this._entryTypeDesc;
    }

    @Override
    public SpaceTypeDescriptor getSpaceTypeDescriptor() {
        return this._typeDesc;
    }

    @Override
    public Object getFixedPropertyValue(int position) {
        return this._fixedProperties[position];
    }

    @Override
    public Object getPropertyValue(String name) {
        int pos = this._typeDesc.getFixedPropertyPosition(name);
        if (pos != -1) {
            return this.getFixedPropertyValue(pos);
        }
        if (this._typeDesc.supportsDynamicProperties()) {
            return this._dynamicProperties != null ? this._dynamicProperties.get(name) : null;
        }
        throw new IllegalArgumentException("Unknown property name '" + name + "'");
    }

    @Override
    public Object getPathValue(String path) {
        if (!path.contains(".")) {
            return this.getPropertyValue(path);
        }
        return new SpaceEntryPathGetter(path).getValue(this);
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public long getExpirationTime() {
        return this._expirationTime;
    }

    @Override
    public EntryDataType getEntryDataType() {
        return EntryDataType.FLAT;
    }

    @Override
    public int getNumOfFixedProperties() {
        return this._fixedProperties.length;
    }

    @Override
    public void setFixedPropertyValue(int index, Object value) {
        this._fixedProperties[index] = value;
    }

    @Override
    public void setFixedPropertyValues(Object[] values) {
        if (values.length != this._fixedProperties.length) {
            throw new IllegalArgumentException("Cannot substitute fixed property values with array of different size!");
        }
        for (int i = 0; i < values.length; ++i) {
            this._fixedProperties[i] = values[i];
        }
    }

    @Override
    public Object[] getFixedPropertiesValues() {
        return this._fixedProperties;
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return this._dynamicProperties;
    }

    @Override
    public void setDynamicProperties(Map<String, Object> dynamicProperties) {
        this._dynamicProperties = dynamicProperties;
    }

    @Override
    public void setDynamicPropertyValue(String propertyName, Object value) {
        if (!this._entryTypeDesc.getTypeDesc().supportsDynamicProperties()) {
            throw new UnsupportedOperationException(this._entryTypeDesc.getTypeDesc().getTypeName() + " does not support dynamic properties");
        }
        if (this._dynamicProperties == null) {
            this._dynamicProperties = new DocumentProperties();
        }
        this._dynamicProperties.put(propertyName, value);
    }

    @Override
    public void unsetDynamicPropertyValue(String propertyName) {
        if (this._dynamicProperties != null) {
            this._dynamicProperties.remove(propertyName);
        }
    }

    @Override
    public long getTimeToLive(boolean useDummyIfRelevant) {
        return AbstractEntryData.getTimeToLive(this._expirationTime, useDummyIfRelevant);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    private void serialize(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._typeName);
        out.writeInt(this._typeChecksum);
        IOUtils.writeObjectArray(out, this._fixedProperties);
        IOUtils.writeObject(out, this._dynamicProperties);
        out.writeInt(this._version);
        out.writeLong(this._expirationTime);
        out.writeByte(this._entryType.getTypeCode());
    }

    private void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        this._typeName = IOUtils.readString(in);
        this._typeChecksum = in.readInt();
        this._fixedProperties = IOUtils.readObjectArray(in);
        this._dynamicProperties = (Map)IOUtils.readObject(in);
        this._version = in.readInt();
        this._expirationTime = in.readLong();
        this._entryType = EntryType.fromByte(in.readByte());
    }
}

