/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.internal.metadata.EntryTypeDesc;
import com.gigaspaces.internal.server.storage.AbstractEntryData;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.j_spaces.core.server.transaction.EntryXtnInfo;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class FlatEntryData
extends AbstractEntryData {
    private final Object[] _fieldsValues;
    private Map<String, Object> _dynamicProperties;

    public FlatEntryData(Object[] fieldsValues, Map<String, Object> dynamicProperties, EntryTypeDesc entryTypeDesc, int version, long expirationTime, boolean createEmptyTxnInfoIfNon) {
        super(entryTypeDesc, version, expirationTime, createEmptyTxnInfoIfNon);
        this._fieldsValues = fieldsValues;
        this._dynamicProperties = dynamicProperties;
    }

    private FlatEntryData(Object[] fieldsValues, Map<String, Object> dynamicProperties, EntryTypeDesc entryTypeDesc, int version, long expirationTime, boolean cloneXtnInfo, AbstractEntryData other, boolean createEmptyTxnInfoIfNon) {
        super(entryTypeDesc, version, expirationTime, cloneXtnInfo, other, createEmptyTxnInfoIfNon);
        this._fieldsValues = fieldsValues;
        this._dynamicProperties = dynamicProperties;
    }

    private FlatEntryData(FlatEntryData other, EntryXtnInfo xtnInfo) {
        super(other, xtnInfo);
        this._fieldsValues = other._fieldsValues;
        this._dynamicProperties = other._dynamicProperties;
    }

    @Override
    public ITransactionalEntryData createCopyWithoutTxnInfo() {
        return new FlatEntryData(this._fieldsValues, this._dynamicProperties, this._entryTypeDesc, this._versionID, this._expirationTime, false);
    }

    @Override
    public ITransactionalEntryData createCopyWithoutTxnInfo(long newExpirationTime) {
        return new FlatEntryData(this._fieldsValues, this._dynamicProperties, this._entryTypeDesc, this._versionID, newExpirationTime, false);
    }

    @Override
    public ITransactionalEntryData createCopyWithTxnInfo(int versionID, long newExpirationTime) {
        return new FlatEntryData(this._fieldsValues, this._dynamicProperties, this._entryTypeDesc, versionID, newExpirationTime, true, this, false);
    }

    @Override
    public ITransactionalEntryData createShallowClonedCopyWithSuppliedVersion(int versionID) {
        return this.createShallowClonedCopyWithSuppliedVersionAndExpiration(versionID, this._expirationTime);
    }

    @Override
    public ITransactionalEntryData createShallowClonedCopyWithSuppliedVersionAndExpiration(int versionID, long expirationTime) {
        Object[] clonedfieldsValues = new Object[this._fieldsValues.length];
        System.arraycopy(this._fieldsValues, 0, clonedfieldsValues, 0, this._fieldsValues.length);
        HashMap<String, Object> clonedDynamicProperties = this._dynamicProperties != null ? new HashMap<String, Object>(this._dynamicProperties) : null;
        return new FlatEntryData(clonedfieldsValues, clonedDynamicProperties, this._entryTypeDesc, versionID, expirationTime, true, this, false);
    }

    @Override
    public ITransactionalEntryData createCopyWithTxnInfo(boolean createEmptyTxnInfoIfNon) {
        return new FlatEntryData(this._fieldsValues, this._dynamicProperties, this._entryTypeDesc, this._versionID, this._expirationTime, true, this, createEmptyTxnInfoIfNon);
    }

    @Override
    public ITransactionalEntryData createCopy(boolean cloneXtnInfo, IEntryData newEntryData, long newExpirationTime) {
        return new FlatEntryData(newEntryData.getFixedPropertiesValues(), newEntryData.getDynamicProperties(), newEntryData.getEntryTypeDesc(), newEntryData.getVersion(), newExpirationTime, cloneXtnInfo, this, false);
    }

    @Override
    public ITransactionalEntryData createCopyWithSuppliedTxnInfo(EntryXtnInfo ex) {
        return new FlatEntryData(this, ex);
    }

    @Override
    public EntryDataType getEntryDataType() {
        return EntryDataType.FLAT;
    }

    @Override
    public int getNumOfFixedProperties() {
        return this._fieldsValues.length;
    }

    @Override
    public Object getFixedPropertyValue(int index) {
        return this._fieldsValues[index];
    }

    @Override
    public void setFixedPropertyValue(int index, Object value) {
        this._fieldsValues[index] = value;
    }

    @Override
    public Object[] getFixedPropertiesValues() {
        return this._fieldsValues;
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return this._dynamicProperties;
    }

    @Override
    public void setDynamicPropertyValue(String propertyName, Object value) {
        if (!this._entryTypeDesc.getTypeDesc().supportsDynamicProperties()) {
            throw new UnsupportedOperationException(this._entryTypeDesc.getTypeDesc().getTypeName() + " does not support dynamic properties");
        }
        if (this._dynamicProperties == null) {
            this._dynamicProperties = new DocumentProperties();
        }
        this._dynamicProperties.put(propertyName, value);
    }

    @Override
    public void setFixedPropertyValues(Object[] values) {
        if (values.length != this._fieldsValues.length) {
            throw new IllegalArgumentException("Cannot substitute fixed property values with array of different size!");
        }
        for (int i = 0; i < values.length; ++i) {
            this._fieldsValues[i] = values[i];
        }
    }

    @Override
    public void unsetDynamicPropertyValue(String propertyName) {
        if (this._dynamicProperties != null) {
            this._dynamicProperties.remove(propertyName);
        }
    }

    @Override
    public void setDynamicProperties(Map<String, Object> dynamicProperties) {
        this._dynamicProperties = dynamicProperties;
    }
}

