/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.FifoSearch;
import com.gigaspaces.internal.server.space.events.BatchNotifyExecutor;
import com.gigaspaces.internal.server.space.events.NotifyContextsHolder;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.TemplateHolder;
import com.gigaspaces.internal.transport.EntryPacketFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.client.INotifyDelegator;
import com.j_spaces.core.client.INotifyDelegatorFilter;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.NotifyModifiers;
import java.rmi.MarshalledObject;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class NotifyTemplateHolder
extends TemplateHolder {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.notify");
    private static final String EMPTY_STRING = "";
    private final long _eventId;
    private final NotifyInfo _notifyInfo;
    private final ITemplatePacket _generationTemplate;
    private final AtomicLong _sequenceNumber;
    private final AtomicBoolean _notifyInProgress;
    private final Queue<BatchNotifyExecutor.EventHolder> _pendingBatchEvents;
    private final AtomicInteger _numPendingBatchEvents;
    private long _batchOrder;

    public NotifyTemplateHolder(IServerTypeDesc typeDesc, ITemplatePacket template, String uid, long expirationTime, long eventId, NotifyInfo info, boolean isFifo) {
        super(typeDesc, template, uid, expirationTime, null, SystemTime.timeMillis(), 6, null, template.isReturnOnlyUids() | info.isReturnOnlyUids(), info.getModifiers(), isFifo);
        this._eventId = eventId;
        this._notifyInfo = info;
        this._generationTemplate = template.clone();
        this._sequenceNumber = new AtomicLong(0L);
        this._notifyInProgress = new AtomicBoolean(false);
        if (this._notifyInfo.isBatching()) {
            this._pendingBatchEvents = new ConcurrentLinkedQueue<BatchNotifyExecutor.EventHolder>();
            this._numPendingBatchEvents = new AtomicInteger();
        } else {
            this._pendingBatchEvents = null;
            this._numPendingBatchEvents = null;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Created notify template: eventId=" + this._eventId + ", templateUid=" + this._notifyInfo.getTemplateUID() + ", type=[" + template.getTypeName() + "], notifyType=" + NotifyModifiers.toString(this._notifyInfo.getNotifyType()) + ", fifo=" + this._notifyInfo.isFifo() + ", prevValue=" + this._notifyInfo.isReturnPrevValue());
        }
    }

    @Override
    public boolean isNotifyTemplate() {
        return true;
    }

    public int getSpaceItemType() {
        return this.isEmptyTemplate() ? 5 : 3;
    }

    public long getEventId() {
        return this._eventId;
    }

    public NotifyInfo getNotifyInfo() {
        return this._notifyInfo;
    }

    public ITemplatePacket getGenerationTemplate() {
        return this._generationTemplate;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber.get();
    }

    public boolean isTriggerNotify() {
        Boolean trigger = this._notifyInfo.getNotifyTemplate();
        return trigger != null ? trigger : false;
    }

    public boolean isReplicateNotify() {
        Boolean replicate = this._notifyInfo.getReplicateTemplate();
        return replicate != null ? replicate : false;
    }

    public boolean isGuaranteedNotification() {
        return this._notifyInfo.isGuaranteedNotifications();
    }

    public boolean isBroadcast() {
        return this._notifyInfo.isBroadcast();
    }

    @Override
    public int getNotifyType() {
        return this._notifyInfo.getNotifyType();
    }

    public boolean containsNotifyType(NotifyActionType notifyType) {
        return Modifiers.contains(this._notifyInfo.getNotifyType(), notifyType.getModifier());
    }

    @Override
    public MarshalledObject getHandback() {
        return this._notifyInfo.getHandback();
    }

    public INotifyDelegatorFilter getFilter() {
        return this._notifyInfo.getFilter();
    }

    public RemoteEventListener getREListener() {
        return this._notifyInfo.getListener();
    }

    public void setREListener(RemoteEventListener listener) {
        this._notifyInfo.setListener(listener);
    }

    public void addPendingEvent(BatchNotifyExecutor.EventHolder event) {
        this._numPendingBatchEvents.incrementAndGet();
        this._pendingBatchEvents.add(event);
    }

    public void clearPendingEvents() {
        this._pendingBatchEvents.clear();
        this._numPendingBatchEvents.set(0);
    }

    public BatchNotifyExecutor.EventHolder pollPendingEvent() {
        BatchNotifyExecutor.EventHolder res;
        BatchNotifyExecutor.EventHolder eventHolder = res = this._numPendingBatchEvents.get() > 0 ? this._pendingBatchEvents.poll() : null;
        if (res != null) {
            this._numPendingBatchEvents.decrementAndGet();
            return res;
        }
        return null;
    }

    public BatchNotifyExecutor.EventHolder peekPendingEvent() {
        return this._numPendingBatchEvents.get() > 0 ? this._pendingBatchEvents.peek() : null;
    }

    public int getPendingEventsSize() {
        return this._numPendingBatchEvents.get();
    }

    public boolean isBatching() {
        return this._notifyInfo.isBatching();
    }

    public int getBatchSize() {
        return this._notifyInfo.getBatchSize();
    }

    public long getBatchTime() {
        return this._notifyInfo.getBatchTime();
    }

    public long getBatchOrder() {
        return this._batchOrder;
    }

    public void setBatchOrder(long _batchOrder) {
        this._batchOrder = _batchOrder;
    }

    public boolean trySetNotifyInProgress() {
        return this._notifyInProgress.compareAndSet(false, true);
    }

    public void finnishedNotify() {
        this._notifyInProgress.set(false);
    }

    @Override
    public void dump(Logger logger, String msg) {
        super.dump(logger, msg);
        logger.info("SequenceNumber : " + this.getSequenceNumber());
        logger.info("EventId : " + this._eventId);
        logger.info("Handback : " + this.getHandback());
        logger.info("REListener : " + this.getREListener());
    }

    @Override
    public boolean isMatchByID() {
        return this.getUidToOperateBy() != null && NotifyModifiers.isMatchByID(this.getNotifyInfo().getNotifyType());
    }

    public RemoteEvent createRemoteEvent(IEntryHolder entryHolder, NotifyActionType notifyType, OperationID operationID, IJSpace spaceProxy, boolean fromReplication) {
        return this.createRemoteEvent(entryHolder, null, notifyType, operationID, spaceProxy, fromReplication);
    }

    public RemoteEvent createRemoteEvent(IEntryHolder entryHolder, IEntryHolder oldEntryHolder, NotifyActionType notifyType, OperationID operationID, IJSpace spaceProxy, boolean fromReplication) {
        RemoteEvent remoteEvent;
        long seqNum = this._sequenceNumber.get();
        if (this.getREListener() instanceof INotifyDelegator) {
            IEntryPacket entryPacket;
            IEntryPacket oldEntryPacket = null;
            if (this.isReturnOnlyUid()) {
                entryPacket = TemplatePacketFactory.createUidPacket(entryHolder.getUID(), entryHolder.getEntryData().getVersion());
                if (notifyType.equals(NotifyActionType.NOTIFY_UNMATCHED) || oldEntryHolder != null && this._notifyInfo.isReturnPrevValue()) {
                    oldEntryPacket = TemplatePacketFactory.createUidPacket(oldEntryHolder.getUID(), oldEntryHolder.getEntryData().getVersion());
                }
            } else {
                entryPacket = EntryPacketFactory.createFullPacket(entryHolder, this);
                if (notifyType.equals(NotifyActionType.NOTIFY_UNMATCHED) || oldEntryHolder != null && this._notifyInfo.isReturnPrevValue()) {
                    oldEntryPacket = EntryPacketFactory.createFullPacket(oldEntryHolder, this);
                }
            }
            entryPacket.setOperationID(operationID);
            if (this.getProjectionTemplate() != null) {
                this.getProjectionTemplate().filterOutNonProjectionProperties(entryPacket);
                if (oldEntryPacket != null) {
                    this.getProjectionTemplate().filterOutNonProjectionProperties(oldEntryPacket);
                }
            }
            EntryArrivedRemoteEvent event = new EntryArrivedRemoteEvent(spaceProxy, this._eventId, seqNum, this.getHandback(), entryPacket, oldEntryPacket, notifyType, fromReplication, this.getUID(), this.getQueryResultType());
            remoteEvent = this.filter(event);
        } else {
            remoteEvent = new RemoteEvent((Object)EMPTY_STRING, this._eventId, seqNum, this.getHandback());
        }
        if (remoteEvent != null) {
            this._sequenceNumber.incrementAndGet();
        }
        return remoteEvent;
    }

    private EntryArrivedRemoteEvent filter(EntryArrivedRemoteEvent event) {
        INotifyDelegatorFilter filter = this.getFilter();
        if (filter != null) {
            try {
                if (!filter.process(event)) {
                    return null;
                }
            }
            catch (Throwable e) {
                _logger.log(Level.FINE, "calling user filter caused an exception", e);
            }
        }
        return event;
    }

    public boolean quickReject(Context context, FifoSearch fifoSearch, ServerTransaction txn, NotifyContextsHolder notifyContextsHolder) {
        if (super.quickReject(context, fifoSearch)) {
            return true;
        }
        if (txn != null && txn != this.getXidOriginatedTransaction()) {
            return true;
        }
        boolean matchFound = false;
        for (NotifyActionType notifyType : notifyContextsHolder.getNotifyTypes()) {
            if (!this.containsNotifyType(notifyType)) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            return true;
        }
        if (context.isFromReplication() && !this.isTriggerNotify() && !this.isGuaranteedNotification()) {
            return true;
        }
        return context.getOperationVisibilityTime() != 0L && this.getSCN() > context.getOperationVisibilityTime();
    }
}

