/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.EntryHolder;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.ILeasedEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import java.util.ArrayList;

@InternalApi
public class ShadowEntryHolder
extends EntryHolder
implements ILeasedEntryCacheInfo {
    private ArrayList<IObjectInfo<IEntryCacheInfo>> _shadowBackRefs;
    private int[] _backrefIndexPos;
    private IStoredList<Object> _leaseManagerListRef;
    private IObjectInfo<Object> _leaseManagerPosRef;
    private int _numOfLeaseUpdates;
    private int _numOfIndexesUpdated;
    private int _numOfUpdates;

    public ShadowEntryHolder(IEntryHolder master, ArrayList<IObjectInfo<IEntryCacheInfo>> backRefs, int[] backrefIndexPos, IStoredList<Object> leaseManagerListRef, IObjectInfo<Object> leaseManagerPosRef) {
        super(master);
        this._backrefIndexPos = backrefIndexPos;
        this.resetXidOriginated();
        this.setOtherUpdateUnderXtnEntry(master);
        if (backRefs != null) {
            this._shadowBackRefs = new ArrayList(backRefs.size());
            for (IObjectInfo<IEntryCacheInfo> o : backRefs) {
                this._shadowBackRefs.add(o);
            }
        }
        this._leaseManagerListRef = leaseManagerListRef;
        this._leaseManagerPosRef = leaseManagerPosRef;
    }

    public ArrayList<IObjectInfo<IEntryCacheInfo>> getBackRefs() {
        return this._shadowBackRefs;
    }

    public void setShadowBackRefs(ArrayList<IObjectInfo<IEntryCacheInfo>> backRefs) {
        this._shadowBackRefs = backRefs;
    }

    public int[] getBackrefIndexPos() {
        return this._backrefIndexPos;
    }

    public void setBackrefIndexPos(int[] val) {
        this._backrefIndexPos = val;
    }

    @Override
    public boolean isShadow() {
        return true;
    }

    @Override
    public boolean hasShadow(boolean safeEntry) {
        return false;
    }

    @Override
    public ShadowEntryHolder getShadow() {
        return this;
    }

    @Override
    public IEntryHolder getMaster() {
        return this.getOtherUpdateUnderXtnEntry();
    }

    @Override
    public boolean isUnderPendingUpdate() {
        return true;
    }

    @Override
    public void setLeaseManagerListRefAndPosition(IStoredList<Object> entriesList, IObjectInfo<Object> entryPos) {
        this._leaseManagerListRef = entriesList;
        this._leaseManagerPosRef = entryPos;
    }

    @Override
    public IStoredList<Object> getLeaseManagerListRef() {
        return this._leaseManagerListRef;
    }

    @Override
    public IObjectInfo<Object> getLeaseManagerPosition() {
        return this._leaseManagerPosRef;
    }

    @Override
    public boolean isConnectedToLeaseManager() {
        if (this.isBlobStoreEntry()) {
            return this.getExpirationTime() != Long.MAX_VALUE;
        }
        return this.getLeaseManagerListRef() != null;
    }

    @Override
    public boolean isSameLeaseManagerRef(ILeasedEntryCacheInfo other) {
        if (this.isBlobStoreEntry()) {
            return other.getLeaseManagerPosition() == this.getLeaseManagerPosition();
        }
        return other.getLeaseManagerListRef() == this.getLeaseManagerListRef() && other.getLeaseManagerPosition() == this.getLeaseManagerPosition();
    }

    @Override
    public boolean isBlobStoreEntry() {
        return this.getOtherUpdateUnderXtnEntry().isBlobStoreEntry();
    }

    @Override
    public Object getObjectStoredInLeaseManager() {
        return this.isBlobStoreEntry() ? ((IBlobStoreEntryHolder)((Object)this.getOtherUpdateUnderXtnEntry())).getBlobStoreResidentPart().getObjectStoredInLeaseManager() : this.getOtherUpdateUnderXtnEntry();
    }

    public void incrementNumOfLeaseUpdates() {
        ++this._numOfLeaseUpdates;
    }

    public int getNumOfLeaseUpdates() {
        return this._numOfLeaseUpdates;
    }

    public void resetNumOfIndexesUpdated() {
        this._numOfIndexesUpdated = 0;
    }

    public void incrementNumOfIndexesUpdated() {
        ++this._numOfIndexesUpdated;
    }

    public int getNumOfIndexesUpdated() {
        return this._numOfIndexesUpdated;
    }

    public void incrementNumOfUpdates() {
        ++this._numOfUpdates;
    }

    public int getNumOfUpdates() {
        return this._numOfUpdates;
    }
}

