/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.protective.ProtectiveMode;
import com.gigaspaces.client.protective.ProtectiveModeException;
import com.gigaspaces.internal.metadata.EntryTypeDesc;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.RegexCache;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryPathGetter;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.storage.AbstractEntryData;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.ITransportPacket;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.server.ServerEntry;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.sadapter.datasource.DefaultSQLQueryBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalApi
public class TemplateEntryData
implements IEntryData {
    private final EntryTypeDesc _entryTypeDesc;
    private Object[] _fieldsValues;
    private Map<String, Object> _dynamicProperties;
    private ICustomQuery _customQuery;
    private int _versionID;
    private long _expirationTime;
    private final short[] _extendedMatchCodes;
    private final Object[] _rangeValues;
    private final boolean[] _rangeValuesInclusion;
    private final boolean _isIdQuery;

    public TemplateEntryData(ITypeDesc typeDesc, ITransportPacket packet, long expirationTime, boolean fromReplication) {
        boolean isTemplateQuery;
        ITemplatePacket templatePacket;
        this._entryTypeDesc = typeDesc.getEntryTypeDesc(packet.getEntryType());
        this._fieldsValues = packet.getFieldValues();
        this._dynamicProperties = typeDesc.supportsDynamicProperties() ? new HashMap() : null;
        this._customQuery = packet.getCustomQuery();
        this._versionID = packet.getVersion();
        this._expirationTime = expirationTime;
        ITemplatePacket iTemplatePacket = templatePacket = packet instanceof ITemplatePacket ? (ITemplatePacket)packet : null;
        if (templatePacket != null && templatePacket.supportExtendedMatching()) {
            this._extendedMatchCodes = templatePacket.getExtendedMatchCodes();
            this._rangeValues = templatePacket.getRangeValues();
            this._rangeValuesInclusion = templatePacket.getRangeValuesInclusion();
        } else {
            this._extendedMatchCodes = null;
            this._rangeValues = null;
            this._rangeValuesInclusion = null;
        }
        this._isIdQuery = templatePacket != null && templatePacket.isIdQuery();
        boolean bl = isTemplateQuery = templatePacket != null && templatePacket.isTemplateQuery();
        if (ProtectiveMode.isPrimitiveWithoutNullValueProtectionEnabled() && isTemplateQuery && typeDesc.getPrimitivePropertiesWithoutNullValues() != null && !fromReplication) {
            throw new ProtectiveModeException("Operation is rejected - template matching on type " + typeDesc.getTypeName() + " is illegal because it has primitive properties without null value: " + typeDesc.getPrimitivePropertiesWithoutNullValues() + ". When using template matching to query the space, properties with primitive types require a 'null value' definition to avoid ambiguity (should the property be matched or not). Select one of the following resolutions: a) Use non-primitive types instead b) define a null value for those properties c) use an alternate query mechanism (e.g. SQLQuery). (you can disable this protection, though it is not recommended, by setting the following system property: " + "com.gs.protectiveMode.primitiveWithoutNullValue" + "=false)");
        }
    }

    public TemplateEntryData() {
        this._entryTypeDesc = null;
        this._extendedMatchCodes = null;
        this._rangeValues = null;
        this._rangeValuesInclusion = null;
        this._isIdQuery = false;
    }

    public boolean isExpired() {
        if (this._expirationTime == 0L || this._expirationTime == Long.MAX_VALUE) {
            return false;
        }
        return this.isExpired(SystemTime.timeMillis());
    }

    public boolean isExpired(long limit) {
        return this._expirationTime != 0L && this._expirationTime <= limit;
    }

    @Override
    public EntryDataType getEntryDataType() {
        return EntryDataType.FLAT;
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return this._dynamicProperties;
    }

    @Override
    public void setDynamicPropertyValue(String propertyName, Object value) {
        if (!this._entryTypeDesc.getTypeDesc().supportsDynamicProperties()) {
            throw new UnsupportedOperationException(this._entryTypeDesc.getTypeDesc().getTypeName() + " does not support dynamic properties");
        }
        this._dynamicProperties.put(propertyName, value);
    }

    @Override
    public void unsetDynamicPropertyValue(String propertyName) {
        if (this._dynamicProperties != null) {
            this._dynamicProperties.remove(propertyName);
        }
    }

    @Override
    public int getVersion() {
        return this._versionID;
    }

    public void setVersion(int version) {
        this._versionID = version;
    }

    @Override
    public long getExpirationTime() {
        return this._expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this._expirationTime = expirationTime;
    }

    @Override
    public long getTimeToLive(boolean useDummyIfRelevant) {
        return AbstractEntryData.getTimeToLive(this._expirationTime, useDummyIfRelevant);
    }

    @Override
    public int getNumOfFixedProperties() {
        return this._fieldsValues.length;
    }

    @Override
    public Object getFixedPropertyValue(int index) {
        return this._fieldsValues[index];
    }

    @Override
    public void setFixedPropertyValue(int index, Object value) {
        this._fieldsValues[index] = value;
    }

    @Override
    public void setFixedPropertyValues(Object[] values) {
        if (values.length != this._fieldsValues.length) {
            throw new IllegalArgumentException("Cannot substitute fixed property values with array of different size!");
        }
        for (int i = 0; i < values.length; ++i) {
            this._fieldsValues[i] = values[i];
        }
    }

    @Override
    public Object[] getFixedPropertiesValues() {
        return this._fieldsValues;
    }

    public void updateData(IEntryData entryData) {
        this._fieldsValues = entryData.getFixedPropertiesValues();
        this._dynamicProperties = entryData.getDynamicProperties();
    }

    @Override
    public Object getPropertyValue(String name) {
        int pos = this._entryTypeDesc.getTypeDesc().getFixedPropertyPosition(name);
        if (pos != -1) {
            return this.getFixedPropertyValue(pos);
        }
        if (this._dynamicProperties == null) {
            throw new IllegalArgumentException("Unknown property name '" + name + "'");
        }
        return this._dynamicProperties.get(name);
    }

    @Override
    public Object getPathValue(String path) {
        if (!path.contains(".")) {
            return this.getPropertyValue(path);
        }
        return new SpaceEntryPathGetter(path).getValue(this);
    }

    @Override
    public EntryTypeDesc getEntryTypeDesc() {
        return this._entryTypeDesc;
    }

    @Override
    public SpaceTypeDescriptor getSpaceTypeDescriptor() {
        return this._entryTypeDesc.getTypeDesc();
    }

    @Override
    public void setDynamicProperties(Map<String, Object> dynamicProperties) {
        this._dynamicProperties = dynamicProperties;
    }

    public ICustomQuery getCustomQuery() {
        return this._customQuery;
    }

    public void setCustomQuery(ICustomQuery customQuery) {
        this._customQuery = customQuery;
    }

    public List<IQueryIndexScanner> getCustomIndexes() {
        return this._customQuery == null ? null : this._customQuery.getCustomIndexes();
    }

    public Object getRangeValue(int index) {
        return this._rangeValues == null ? null : this._rangeValues[index];
    }

    public boolean getRangeInclusion(int index) {
        return this._rangeValuesInclusion == null ? true : this._rangeValuesInclusion[index];
    }

    public boolean match(CacheManager cacheManager, ServerEntry entry, int skipAlreadyMatchedFixedPropertyIndex, String skipAlreadyMatchedIndexPath, RegexCache regexCache) {
        boolean result;
        boolean bl = result = this._extendedMatchCodes == null ? this.matchBasic(entry, skipAlreadyMatchedFixedPropertyIndex) : this.matchExtended(entry, skipAlreadyMatchedFixedPropertyIndex, regexCache);
        if (result && this._customQuery != null) {
            result = this._customQuery.matches(cacheManager, entry, skipAlreadyMatchedIndexPath);
        }
        return result;
    }

    private boolean matchBasic(ServerEntry entry, int skipIndex) {
        if (this._fieldsValues == null || this._fieldsValues.length == 0) {
            return true;
        }
        if (this.quickReject(entry)) {
            return false;
        }
        for (int i = 0; i < this._fieldsValues.length; ++i) {
            Object entryValue;
            Object templateValue = this.getFixedPropertyValue(i);
            if (i == skipIndex || templateValue == null || (entryValue = entry.getFixedPropertyValue(i)) != null && templateValue.equals(entryValue)) continue;
            return false;
        }
        return true;
    }

    private boolean quickReject(ServerEntry entry) {
        for (int i = 0; i < this._fieldsValues.length; ++i) {
            Object templateFieldValue = this._fieldsValues[i];
            if (templateFieldValue == null) continue;
            Object entryFieldValue = entry.getFixedPropertyValue(i);
            if (entryFieldValue == null) {
                return true;
            }
            if (templateFieldValue == entryFieldValue || templateFieldValue.hashCode() == entryFieldValue.hashCode()) continue;
            return true;
        }
        return false;
    }

    private boolean matchExtended(ServerEntry entry, int skipIndex, RegexCache regexCache) {
        int numOfFields = this._fieldsValues.length;
        for (int i = 0; i < numOfFields; ++i) {
            Object rangeValue;
            if (i == skipIndex) continue;
            Object entryValue = entry.getFixedPropertyValue(i);
            short matchCode = this._extendedMatchCodes[i];
            if (matchCode == 6) {
                if (entryValue == null) continue;
                return false;
            }
            if (matchCode == 7) {
                if (entryValue != null) continue;
                return false;
            }
            Object templateValue = this._fieldsValues[i];
            if (templateValue == null) continue;
            if (entryValue == null) {
                return false;
            }
            Object object = rangeValue = this._rangeValues != null ? this._rangeValues[i] : null;
            if (TemplateEntryData.matchExtendedProperty(entryValue, templateValue, matchCode, this.getRangeInclusion(i), rangeValue, regexCache)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchExtendedProperty(Object entryValue, Object templateValue, short matchCode, boolean includeRange, Object rangeValue, RegexCache regexCache) {
        if (templateValue == null) {
            return true;
        }
        if (entryValue == null) {
            return false;
        }
        if (matchCode == 8) {
            Pattern p = regexCache.getPattern((String)templateValue);
            Matcher m = p.matcher((String)entryValue);
            return m.matches();
        }
        int compareResult = 0;
        if (matchCode != 1 && matchCode != 0) {
            Comparable<?> eobj = TemplateEntryData.castToComparable(entryValue);
            Comparable<?> tobj = TemplateEntryData.castToComparable(templateValue);
            try {
                compareResult = eobj.compareTo(tobj);
            }
            catch (ClassCastException cce) {
                if (!eobj.getClass().isInstance(tobj)) {
                    return false;
                }
                throw cce;
            }
        }
        switch (matchCode) {
            case 1: {
                return !templateValue.equals(entryValue);
            }
            case 0: {
                if (TemplateEntryData.quickRejectField(entryValue, templateValue)) {
                    return false;
                }
                return templateValue.equals(entryValue);
            }
            case 4: {
                if (rangeValue == null) {
                    return compareResult < 0;
                }
                if (compareResult >= 0) {
                    return false;
                }
                return TemplateEntryData.fieldExtendedMatchLimitValue(entryValue, rangeValue, matchCode, includeRange);
            }
            case 5: {
                if (rangeValue == null) {
                    return compareResult <= 0;
                }
                if (compareResult > 0) {
                    return false;
                }
                return TemplateEntryData.fieldExtendedMatchLimitValue(entryValue, rangeValue, matchCode, includeRange);
            }
            case 3: {
                if (rangeValue == null) {
                    return compareResult >= 0;
                }
                if (compareResult < 0) {
                    return false;
                }
                return TemplateEntryData.fieldExtendedMatchLimitValue(entryValue, rangeValue, matchCode, includeRange);
            }
            case 2: {
                if (rangeValue == null) {
                    return compareResult > 0;
                }
                if (compareResult <= 0) {
                    return false;
                }
                return TemplateEntryData.fieldExtendedMatchLimitValue(entryValue, rangeValue, matchCode, includeRange);
            }
        }
        return false;
    }

    private static Comparable<?> castToComparable(Object obj) {
        try {
            return (Comparable)obj;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Type " + obj.getClass() + " doesn't implement Comparable, Serialization mode might be different than " + (Object)((Object)StorageType.OBJECT) + ".", cce);
        }
    }

    private static boolean fieldExtendedMatchLimitValue(Object entryValue, Object rangeValue, short matchCode, boolean includeRange) {
        int compareResult = ((Comparable)entryValue).compareTo(rangeValue);
        switch (matchCode) {
            case 4: 
            case 5: {
                return includeRange ? compareResult >= 0 : compareResult > 0;
            }
            case 2: 
            case 3: {
                return includeRange ? compareResult <= 0 : compareResult < 0;
            }
        }
        return false;
    }

    private static boolean quickRejectField(Object entryValue, Object templateValue) {
        if (templateValue == null) {
            return false;
        }
        if (entryValue == null) {
            return true;
        }
        return templateValue.hashCode() != entryValue.hashCode();
    }

    public short[] getExtendedMatchCodes() {
        return this._extendedMatchCodes;
    }

    public SQLQuery<?> toSQLQuery(ITypeDesc typeDesc) {
        SQLQuery customQuery;
        String sqlString;
        int i;
        if (this._fieldsValues == null || this._fieldsValues.length == 0) {
            return new SQLQuery<String>(typeDesc.getTypeName(), "");
        }
        LinkedList<Object> preparedValues = new LinkedList<Object>();
        StringBuilder wherePart = new StringBuilder();
        for (i = 0; i < this._fieldsValues.length; ++i) {
            short matchCode = this._extendedMatchCodes != null ? this._extendedMatchCodes[i] : (short)0;
            Object templateFieldValue = this._fieldsValues[i];
            if (templateFieldValue != null) {
                if (wherePart.length() > 0) {
                    wherePart.append(" and ");
                }
                wherePart.append(typeDesc.getFixedProperty(i).getName());
                wherePart.append(DefaultSQLQueryBuilder.mapCodeToSign(matchCode));
                wherePart.append("?");
                Object value = DefaultSQLQueryBuilder.convertToSQLFormat(templateFieldValue, matchCode);
                preparedValues.add(value);
                continue;
            }
            if (matchCode != 6 && matchCode != 7) continue;
            if (wherePart.length() > 0) {
                wherePart.append(" and ");
            }
            wherePart.append(typeDesc.getFixedProperty(i).getName());
            wherePart.append(DefaultSQLQueryBuilder.mapCodeToSign(matchCode));
        }
        if (this._rangeValues != null) {
            for (i = 0; i < this._rangeValues.length; ++i) {
                if (this._rangeValues[i] == null) continue;
                if (wherePart.length() > 0) {
                    wherePart.append(" and ");
                }
                wherePart.append(typeDesc.getFixedProperty(i).getName());
                if (this._extendedMatchCodes != null) {
                    switch (this._extendedMatchCodes[i]) {
                        case 2: 
                        case 3: {
                            if (this.getRangeInclusion(i)) {
                                wherePart.append(DefaultSQLQueryBuilder.mapCodeToSign((short)5));
                                break;
                            }
                            wherePart.append(DefaultSQLQueryBuilder.mapCodeToSign((short)4));
                            break;
                        }
                        case 4: 
                        case 5: {
                            if (this.getRangeInclusion(i)) {
                                wherePart.append(DefaultSQLQueryBuilder.mapCodeToSign((short)3));
                                break;
                            }
                            wherePart.append(DefaultSQLQueryBuilder.mapCodeToSign((short)2));
                        }
                    }
                }
                wherePart.append("?");
                preparedValues.add(this._rangeValues[i]);
            }
        }
        if (this._customQuery != null && (sqlString = (customQuery = this._customQuery.toSQLQuery(typeDesc)).getQuery()) != null && sqlString.length() > 0) {
            if (wherePart.length() > 0) {
                wherePart.append(" and ");
            }
            wherePart.append(sqlString);
            if (customQuery.getParameters() != null) {
                for (int i2 = 0; i2 < customQuery.getParameters().length; ++i2) {
                    preparedValues.add(customQuery.getParameters()[i2]);
                }
            }
        }
        return new SQLQuery(typeDesc.getTypeName(), wherePart.toString(), preparedValues.toArray());
    }

    public boolean isAssignableFrom(IServerTypeDesc serverTypeDesc) {
        String typeName = this._entryTypeDesc.getTypeDesc().getTypeName();
        for (IServerTypeDesc typeDesc : serverTypeDesc.getSuperTypes()) {
            if (!typeDesc.getTypeName().equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public boolean isIdQuery() {
        return this._isIdQuery;
    }
}

