/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.EntryHolderAggregatorContext;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.query.RegexCache;
import com.gigaspaces.internal.query.explainplan.ExplainPlanUtil;
import com.gigaspaces.internal.query.explainplan.SingleExplainPlan;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.BatchQueryOperationContext;
import com.gigaspaces.internal.server.space.FifoSearch;
import com.gigaspaces.internal.server.space.MatchResult;
import com.gigaspaces.internal.server.space.MultipleIdsContext;
import com.gigaspaces.internal.server.storage.AbstractSpaceItem;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.gigaspaces.internal.server.storage.ShadowEntryHolder;
import com.gigaspaces.internal.server.storage.TemplateEntryData;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.lrmi.nio.IResponseContext;
import com.j_spaces.core.AnswerHolder;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.PendingFifoSearch;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.UpdateOrWriteContext;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.ReadModifiers;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.core.client.TakeModifiers;
import com.j_spaces.core.filters.FilterManager;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.kernel.locks.ILockObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class TemplateHolder
extends AbstractSpaceItem
implements ITemplateHolder {
    private final int _templateOperation;
    private boolean _pendingRemoteException;
    private volatile boolean _hasWaitingFor;
    private Collection<IEntryHolder> _waitingFor;
    private final AbstractProjectionTemplate _projectionTemplate;
    private String _uidToOperateBy;
    private final String[] _multipleUids;
    private final boolean _returnOnlyUid;
    private final boolean _fifoTemplate;
    private IEntryHolder _updatedEntry;
    private boolean _isReRegisterLeaseOnUpdate;
    private AnswerHolder _answerHolder;
    private volatile boolean _inCache;
    private final int _operationModifiers;
    private boolean _initialIfExistSearchActive;
    private PendingFifoSearch _pendingFifoSearch;
    private boolean _initialFifoSearchActive;
    private long _fifoXtnNumberOnSearchStart = -1L;
    private int _fifoThreadPartition;
    private final IResponseContext _respContext;
    private boolean _secondPhase = false;
    private boolean _inExpirationManager = false;
    private final QueryResultTypeInternal _queryResultType;
    private String _externalEntryImplClassName = null;
    private final OperationID _operationID;
    private XtnEntry _templateXtnOriginated;
    private boolean _memoryOnlySearch;
    private boolean _nonBlockingRead;
    private Object _id;
    private final TemplateEntryData _templateData;
    private transient int _previousVersion;
    private Collection<SpaceEntryMutator> _mutators;
    private long _inPlaceUpdateExpiration;
    private boolean _ifExistForInPlaceUpdate;
    private Throwable _cause;
    private IEntryData _rejectedEntry;
    private int _afterOpFilterCode = -1;
    private IEntryPacket _updateOperationEntry;
    private FilterManager _filterManager;
    private SpaceContext _spaceContext;
    private BatchQueryOperationContext _batchOerationContext;
    private MultipleIdsContext _multipleIdsContexct;
    private int _ordinalForMultipleIdsOperation;
    private UpdateOrWriteContext _updateOrWriteContext;
    private EntryHolderAggregatorContext aggregatorContext;
    private transient Boolean _optimizedForBlobStoreOp;
    private final boolean _allValuesIndexSqlQuery;
    private SingleExplainPlan _singleExplainPlan = null;

    public TemplateHolder(IServerTypeDesc typeDesc, ITemplatePacket packet, String uid, long expirationTime, XtnEntry xidOriginated, long scn, int templateOperation, IResponseContext respContext, boolean returnOnlyUid, int operationModifiers, boolean isfifo, boolean fromReplication) {
        this(typeDesc, packet, packet.getProjectionTemplate(), uid, scn, expirationTime, xidOriginated, templateOperation, respContext, returnOnlyUid, operationModifiers, isfifo, packet.getQueryResultType(), fromReplication, packet.isAllIndexValuesSqlQuery());
    }

    public TemplateHolder(IServerTypeDesc typeDesc, ITemplatePacket packet, String uid, long expirationTime, XtnEntry xidOriginated, long scn, int templateOperation, IResponseContext respContext, boolean returnOnlyUid, int operationModifiers, boolean isfifo) {
        this(typeDesc, packet, packet.getProjectionTemplate(), uid, scn, expirationTime, xidOriginated, templateOperation, respContext, returnOnlyUid, operationModifiers, isfifo, packet.getQueryResultType());
    }

    public TemplateHolder(IServerTypeDesc typeDesc, IEntryPacket packet, String uid, long expirationTime, XtnEntry xidOriginated, long scn, int templateOperation, IResponseContext respContext, int operationModifiers) {
        this(typeDesc, packet, null, uid, scn, expirationTime, xidOriginated, templateOperation, respContext, false, operationModifiers, false, QueryResultTypeInternal.getUpdateResultType(packet));
    }

    private TemplateHolder(IServerTypeDesc typeDesc, IEntryPacket packet, AbstractProjectionTemplate projectionTemplate, String uid, long scn, long expirationTime, XtnEntry xidOriginated, int templateOperation, IResponseContext respContext, boolean returnOnlyUid, int operationModifiers, boolean isfifo, QueryResultTypeInternal queryResultType, boolean fromReplication, boolean isAllIndexValuesSqlQuery) {
        super(typeDesc, uid, scn, packet.isTransient());
        this._projectionTemplate = projectionTemplate;
        this._templateOperation = templateOperation;
        this._returnOnlyUid = returnOnlyUid;
        this._operationModifiers = operationModifiers;
        this._externalEntryImplClassName = packet.getExternalEntryImplClassName();
        this._respContext = respContext;
        this._templateXtnOriginated = xidOriginated;
        this._operationID = packet.getOperationID();
        this._multipleUids = packet.getMultipleUIDs();
        this._uidToOperateBy = packet.getUID();
        this._allValuesIndexSqlQuery = isAllIndexValuesSqlQuery;
        if (this.isInitiatedEvictionOperation()) {
            isfifo = false;
        }
        this._fifoTemplate = isfifo;
        this._queryResultType = queryResultType;
        this._templateData = new TemplateEntryData(typeDesc.getTypeDesc(), packet, expirationTime, fromReplication);
        if (packet.hasPreviousVersion()) {
            this._previousVersion = packet.getPreviousVersion();
        } else {
            int version = packet.getVersion();
            if (version != 0) {
                this._previousVersion = version - 1;
            }
        }
        this.setMemoryOnlySearch(Modifiers.contains(this._operationModifiers, 0x1000000));
        if (Modifiers.contains(this._operationModifiers, 0x10000000)) {
            QueryTemplatePacket templatePacket = (QueryTemplatePacket)packet;
            SingleExplainPlan plan = new SingleExplainPlan();
            if (this.HasMatchCodes(packet)) {
                plan.setRoot(ExplainPlanUtil.BuildMatchCodes(templatePacket));
                if (templatePacket.getCustomQuery() != null) {
                    plan.getRoot().getChildren().add(ExplainPlanUtil.buildQueryTree(templatePacket.getCustomQuery()));
                }
            } else if (templatePacket.getCustomQuery() != null) {
                plan.setRoot(ExplainPlanUtil.buildQueryTree(templatePacket.getCustomQuery()));
            }
            this._singleExplainPlan = plan;
        }
    }

    private boolean HasMatchCodes(IEntryPacket packet) {
        Object[] fieldValues;
        for (Object fieldValue : fieldValues = packet.getFieldValues()) {
            if (fieldValue == null) continue;
            return true;
        }
        return false;
    }

    private TemplateHolder(IServerTypeDesc typeDesc, IEntryPacket packet, AbstractProjectionTemplate projectionTemplate, String uid, long scn, long expirationTime, XtnEntry xidOriginated, int templateOperation, IResponseContext respContext, boolean returnOnlyUid, int operationModifiers, boolean isfifo, QueryResultTypeInternal queryResultType) {
        this(typeDesc, packet, projectionTemplate, uid, scn, expirationTime, xidOriginated, templateOperation, respContext, returnOnlyUid, operationModifiers, isfifo, queryResultType, false, false);
    }

    @Override
    public boolean isHasWaitingFor() {
        return this._hasWaitingFor;
    }

    @Override
    public void setHasWaitingFor(boolean value) {
        this._hasWaitingFor = value;
    }

    @Override
    public boolean isNotifyTemplate() {
        return false;
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        this._templateData.setExpirationTime(expirationTime);
    }

    public void setExpirationTime(long expirationTime, boolean createSnapshot) {
        this.setExpirationTime(expirationTime);
    }

    @Override
    public boolean isExpired() {
        return this._templateData.isExpired();
    }

    @Override
    public boolean isExpired(long limit) {
        return this._templateData.isExpired(limit);
    }

    private void setVersionID(int versionID) {
        this._templateData.setVersion(versionID);
    }

    @Override
    public void updateVersionAndExpiration(int versionID, long expiration) {
        this.setExpirationTime(expiration);
        this.setVersionID(versionID);
    }

    @Override
    public int getTemplateOperation() {
        return this._templateOperation;
    }

    public boolean hasPendingRemoteException() {
        return this._pendingRemoteException;
    }

    public void setPendingRemoteException(boolean value) {
        this._pendingRemoteException = value;
    }

    @Override
    public QueryResultTypeInternal getQueryResultType() {
        return this._queryResultType;
    }

    @Override
    public IResponseContext getResponseContext() {
        return this._respContext;
    }

    @Override
    public int getTokenFieldNumber() {
        return -1;
    }

    @Override
    public boolean isInitialIfExistSearchActive() {
        return this._initialIfExistSearchActive;
    }

    @Override
    public void setInitialIfExistSearchActive() {
        this._initialIfExistSearchActive = true;
    }

    @Override
    public void resetInitialIfExistSearchActive() {
        this._initialIfExistSearchActive = false;
    }

    @Override
    public boolean isEmptyTemplate() {
        return this.getServerTypeDesc().isRootType();
    }

    @Override
    public boolean hasExtendedMatchCodes() {
        return this._templateData.getExtendedMatchCodes() != null;
    }

    @Override
    public short[] getExtendedMatchCodes() {
        return this._templateData.getExtendedMatchCodes();
    }

    @Override
    public boolean isExclusiveReadLockOperation() {
        return (this._templateOperation == 2 || this._templateOperation == 3) && ReadModifiers.isExclusiveReadLock(this._operationModifiers) && this.getXidOriginatedTransaction() != null;
    }

    @Override
    public boolean isFifoSearch() {
        return this._fifoTemplate && this._uidToOperateBy == null && (this._multipleUids == null || this._multipleUids.length == 0);
    }

    @Override
    public boolean isFifoTemplate() {
        return this._fifoTemplate;
    }

    @Override
    public boolean isIfExist() {
        return this._templateOperation == 3 || this._templateOperation == 5 || this._templateOperation == 7 && !this.isChange() || this._ifExistForInPlaceUpdate;
    }

    @Override
    public boolean isInCache() {
        if (this.getExpirationTime() == 0L && !this.isNotifyTemplate()) {
            return false;
        }
        return this._inCache;
    }

    @Override
    public void setInCache() {
        if (this.getExpirationTime() == 0L && !this.isNotifyTemplate()) {
            throw new UnsupportedOperationException();
        }
        this._inCache = true;
    }

    @Override
    public boolean isExpirationTimeSet() {
        return this.getExpirationTime() != 0L;
    }

    @Override
    public void removePendingFifoSearchObject(boolean disableInitialSearch) {
        this._pendingFifoSearch = null;
        if (disableInitialSearch) {
            this.resetInitialFifoSearchActive();
        }
    }

    @Override
    public void setPendingFifoSearchObject(PendingFifoSearch pobj) {
        this._pendingFifoSearch = pobj;
    }

    @Override
    public PendingFifoSearch getPendingFifoSearchObject() {
        return this._pendingFifoSearch;
    }

    @Override
    public boolean isInitialFifoSearchActive() {
        return this._initialFifoSearchActive;
    }

    @Override
    public void setInitialFifoSearchActive() {
        this._initialFifoSearchActive = true;
    }

    public void resetInitialFifoSearchActive() {
        this._initialFifoSearchActive = false;
    }

    @Override
    public long getFifoXtnNumberOnSearchStart() {
        return this._fifoXtnNumberOnSearchStart;
    }

    @Override
    public void setFifoXtnNumberOnSearchStart(long xtnnum) {
        this._fifoXtnNumberOnSearchStart = xtnnum;
    }

    @Override
    public void resetFifoXtnNumberOnSearchStart() {
        this._fifoXtnNumberOnSearchStart = -1L;
    }

    @Override
    public boolean isWriteLockOperation() {
        return this._templateOperation == 1 || this._templateOperation == 4 || this._templateOperation == 5 || this._templateOperation == 7 || this.isExclusiveReadLockOperation();
    }

    @Override
    public boolean isReadOperation() {
        return this._templateOperation == 2 || this._templateOperation == 3;
    }

    @Override
    public boolean isTakeOperation() {
        return this._templateOperation == 4 || this._templateOperation == 5;
    }

    @Override
    public boolean isUpdateOperation() {
        return this._templateOperation == 7;
    }

    @Override
    public boolean isInitiatedEvictionOperation() {
        return TakeModifiers.isEvictOnly(this._operationModifiers) && this.isTakeOperation();
    }

    @Override
    public boolean isReadCommittedRequested() {
        return this.isReadOperation() && ReadModifiers.isReadCommitted(this._operationModifiers) && !this.isExclusiveReadLockOperation();
    }

    @Override
    public boolean isDirtyReadRequested() {
        return this.isReadOperation() && ReadModifiers.isDirtyRead(this._operationModifiers);
    }

    @Override
    public int getFifoThreadPartition() {
        return this._fifoThreadPartition;
    }

    @Override
    public void setFifoThreadPartition(int nThread) {
        this._fifoThreadPartition = nThread;
    }

    @Override
    public boolean isSecondPhase() {
        return this._secondPhase;
    }

    @Override
    public void setSecondPhase() {
        this._secondPhase = true;
    }

    @Override
    public boolean hasAnswer() {
        AnswerHolder answerHolder = this._answerHolder;
        return answerHolder != null && (!answerHolder.m_AnswerPacket.isDummy() || answerHolder.m_Exception != null);
    }

    @Override
    public AnswerHolder getAnswerHolder() {
        return this._answerHolder;
    }

    @Override
    public void setAnswerHolder(AnswerHolder answerHolder) {
        if (this._singleExplainPlan != null) {
            answerHolder.setExplainPlan(this._singleExplainPlan);
        }
        this._answerHolder = answerHolder;
    }

    @Override
    public void setInExpirationManager(boolean inManager) {
        this._inExpirationManager = inManager;
    }

    @Override
    public boolean isInExpirationManager() {
        return this._inExpirationManager;
    }

    @Override
    public boolean isExplicitInsertionToExpirationManager() {
        return this.isChange();
    }

    @Override
    public String getExternalEntryImplClassName() {
        return this._externalEntryImplClassName;
    }

    @Override
    public OperationID getOperationID() {
        return this._operationID;
    }

    @Override
    public void resetXidOriginated() {
        this._templateXtnOriginated = null;
    }

    @Override
    public XtnEntry getXidOriginated() {
        return this._templateXtnOriginated;
    }

    @Override
    public ServerTransaction getXidOriginatedTransaction() {
        return this._templateXtnOriginated == null ? null : this._templateXtnOriginated.m_Transaction;
    }

    @Override
    public boolean isMaybeUnderXtn() {
        return this.getXidOriginated() != null;
    }

    @Override
    public void setNonBlockingRead(boolean val) {
        this._nonBlockingRead = val;
    }

    @Override
    public boolean isNonBlockingRead() {
        return this._nonBlockingRead;
    }

    @Override
    public Object getRangeValue(int index) {
        return this._templateData.getRangeValue(index);
    }

    @Override
    public boolean getRangeInclusion(int index) {
        return this._templateData.getRangeInclusion(index);
    }

    @Override
    public void dump(Logger logger, String msg) {
        super.dump(logger, msg);
        logger.info("TemplateOperation : " + this._templateOperation);
    }

    @Override
    public boolean isMatchByID() {
        return this._uidToOperateBy != null && (this._templateOperation == 7 || ReadModifiers.isMatchByID(this._operationModifiers));
    }

    @Override
    public Object getEntryId() {
        if (this.getEntryData().getEntryTypeDesc().getTypeDesc().isAutoGenerateId()) {
            return this.getUidToOperateBy();
        }
        return super.getEntryId();
    }

    @Override
    public String getUidToOperateBy() {
        return this._uidToOperateBy;
    }

    @Override
    public void setUidToOperateBy(String uid) {
        this._uidToOperateBy = uid;
    }

    @Override
    public String[] getMultipleUids() {
        return this._multipleUids;
    }

    @Override
    public boolean isReturnOnlyUid() {
        return this._returnOnlyUid;
    }

    @Override
    public IEntryHolder getUpdatedEntry() {
        return this._updatedEntry;
    }

    @Override
    public void setUpdatedEntry(IEntryHolder updatedEntry) {
        this._updatedEntry = updatedEntry;
    }

    @Override
    public void setReRegisterLeaseOnUpdate(boolean value) {
        this._isReRegisterLeaseOnUpdate = value;
    }

    @Override
    public boolean isReRegisterLeaseOnUpdate() {
        return this._isReRegisterLeaseOnUpdate;
    }

    @Override
    public int getOperationModifiers() {
        return this._operationModifiers;
    }

    @Override
    public IEntryData getEntryData() {
        return this._templateData;
    }

    @Override
    public boolean isMemoryOnlySearch() {
        return this._memoryOnlySearch;
    }

    @Override
    public void setMemoryOnlySearch(boolean memoryOnly) {
        this._memoryOnlySearch = memoryOnly;
    }

    @Override
    public ICustomQuery getCustomQuery() {
        return this._templateData.getCustomQuery();
    }

    public void setCustomQuery(ICustomQuery customQuery) {
        this._templateData.setCustomQuery(customQuery);
    }

    @Override
    public SQLQuery<?> toSQLQuery(ITypeDesc typeDesc) {
        return this._templateData.toSQLQuery(typeDesc);
    }

    @Override
    public void setID(Object id) {
        this._id = id;
    }

    @Override
    public Object getID() {
        return this._id;
    }

    @Override
    public MatchResult match(CacheManager cacheManager, IEntryHolder entry, int skipAlreadyMatchedFixedPropertyIndex, String skipAlreadyMatchedIndexPath, boolean safeEntry, Context context, RegexCache regexCache) {
        context.incrementNumOfEntriesMatched();
        MatchResult res = MatchResult.NONE;
        ITransactionalEntryData masterEntryData = null;
        IEntryData shadowEntryData = null;
        if (this.getCustomQuery() != null && context != null) {
            context.setOnMatchUid(entry.getUID());
        }
        if (this.isChangeById() && !this.getServerTypeDesc().getTypeName().equals(entry.getServerTypeDesc().getTypeName())) {
            res = MatchResult.NONE;
        } else if (this._uidToOperateBy != null && !this._uidToOperateBy.equals(entry.getUID())) {
            res = MatchResult.NONE;
        } else {
            masterEntryData = entry.getTxnEntryData();
            if (safeEntry) {
                if (entry.hasShadow(true)) {
                    shadowEntryData = masterEntryData.getOtherUpdateUnderXtnEntry().getEntryData();
                }
            } else {
                IEntryHolder sh = masterEntryData.getOtherUpdateUnderXtnEntry();
                IEntryData iEntryData = shadowEntryData = sh != null ? masterEntryData.getOtherUpdateUnderXtnEntry().getEntryData() : null;
            }
            if (this.isMatchByID() && !this.isChangeQuery() || this.isEmptyTemplate()) {
                res = shadowEntryData == null ? MatchResult.MASTER : MatchResult.MASTER_AND_SHADOW;
            } else {
                boolean masterMatch = this._templateData.match(cacheManager, masterEntryData, skipAlreadyMatchedFixedPropertyIndex, skipAlreadyMatchedIndexPath, regexCache);
                if (shadowEntryData == null) {
                    res = masterMatch ? MatchResult.MASTER : MatchResult.NONE;
                } else {
                    boolean shadowMatch = this._templateData.match(cacheManager, shadowEntryData, skipAlreadyMatchedFixedPropertyIndex, skipAlreadyMatchedIndexPath, regexCache);
                    if (masterMatch) {
                        res = shadowMatch ? MatchResult.MASTER_AND_SHADOW : MatchResult.MASTER;
                    } else {
                        MatchResult matchResult = res = shadowMatch ? MatchResult.SHADOW : MatchResult.NONE;
                    }
                }
            }
        }
        if (context != null) {
            if (res == MatchResult.NONE) {
                context.setRawmatchResult(null, MatchResult.NONE, null, null);
            } else {
                context.setRawmatchResult(masterEntryData, res, entry, this);
                context.setUnstableEntry(entry.isUnstable());
            }
        }
        if (this._singleExplainPlan != null) {
            this._singleExplainPlan.incrementScanned(entry.getClassName());
            if (res != MatchResult.NONE) {
                this._singleExplainPlan.incrementMatched(entry.getClassName());
            }
        }
        return res;
    }

    @Override
    public boolean quickReject(Context context, FifoSearch fifoSearch) {
        if (this.isDeleted() || this.isExpired()) {
            return true;
        }
        boolean isOperationFifoSearch = fifoSearch == FifoSearch.YES;
        boolean isTemplateFifoSearch = this.isFifoSearch();
        if (isTemplateFifoSearch != isOperationFifoSearch) {
            return true;
        }
        return context.isFifoThread() && isTemplateFifoSearch && context.getFifoThreadNumber() != this._fifoThreadPartition;
    }

    @Override
    public ITransactionalEntryData getTxnEntryData() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public boolean anyReadLockXtn() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public List<XtnEntry> getReadLockOwners() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void addReadLockOwner(XtnEntry xtn) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void removeReadLockOwner(XtnEntry xtn) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void clearReadLockOwners() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public XtnEntry getWriteLockOwner() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public boolean isEntryUnderWriteLockXtn() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public int getWriteLockOperation() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public ServerTransaction getWriteLockTransaction() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public Collection<ITemplateHolder> getTemplatesWaitingForEntry() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public Collection<ITemplateHolder> getCopyOfTemplatesWaitingForEntry() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void addTemplateWaitingForEntry(ITemplateHolder template) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void removeTemplateWaitingForEntry(ITemplateHolder template) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public IEntryHolder getMaster() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    public void setFieldsValues(Object[] fieldsValues, boolean createSnapsht) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void updateEntryData(IEntryData newEntryData, long expirationTime) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void resetEntryXtnInfo() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void resetWriteLockOwner() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void setWriteLockOperation(int writeLockOperation, boolean createSnapshot) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void setWriteLockOwnerAndOperation(XtnEntry writeLockOwner, int writeLockOperation) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void setWriteLockOwnerAndOperation(XtnEntry writeLockOwner, int writeLockOperation, boolean createSnapshot) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void setWriteLockOwnerOperationAndShadow(XtnEntry writeLockOwner, int writeLockOperation, IEntryHolder otherEh) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public boolean hasShadow(boolean safeEntry) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public ShadowEntryHolder getShadow() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void restoreUpdateXtnRollback(IEntryData entryData) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void setOtherUpdateUnderXtnEntry(IEntryHolder eh) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public IEntryHolder createCopy() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public IEntryHolder createDummy() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public boolean isUnstable() {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public void setunStable(boolean value) {
        throw new UnsupportedOperationException("This operation is not supported for TemplateHolder");
    }

    @Override
    public int getPreviousVersion() {
        return this._previousVersion;
    }

    @Override
    public int getAfterOpFilterCode() {
        return this._afterOpFilterCode;
    }

    @Override
    public IEntryPacket getUpdateOperationEntry() {
        return this._updateOperationEntry;
    }

    @Override
    public SpaceContext getSpaceContext() {
        return this._spaceContext;
    }

    @Override
    public FilterManager getFilterManager() {
        return this._filterManager;
    }

    @Override
    public void setForAfterOperationFilter(int afterOpFilterCode, SpaceContext sc, FilterManager fm, IEntryPacket updateOperationEntry) {
        this._afterOpFilterCode = afterOpFilterCode;
        this._spaceContext = sc;
        this._filterManager = fm;
        if (updateOperationEntry != null) {
            this._updateOperationEntry = updateOperationEntry;
        }
    }

    @Override
    public boolean isFifoGroupPoll() {
        return ReadModifiers.isFifoGroupingPoll(this._operationModifiers);
    }

    @Override
    public boolean isChange() {
        return this._mutators != null;
    }

    @Override
    public boolean isChangeById() {
        return this.isChange() && (this.getUidToOperateBy() != null || this.getID() != null);
    }

    @Override
    public void setMutators(Collection<SpaceEntryMutator> mutators) {
        this._mutators = mutators;
    }

    @Override
    public Collection<SpaceEntryMutator> getMutators() {
        return this._mutators;
    }

    @Override
    public void setChangeExpiration(long expirationTime) {
        this._inPlaceUpdateExpiration = expirationTime;
    }

    @Override
    public EntryHolderAggregatorContext getAggregatorContext() {
        return this.aggregatorContext;
    }

    @Override
    public void setAggregatorContext(EntryHolderAggregatorContext aggregatorContext) {
        this.aggregatorContext = aggregatorContext;
    }

    @Override
    public long getChangeExpiration() {
        return this._inPlaceUpdateExpiration;
    }

    @Override
    public void setIfExistForChange() {
        this._ifExistForInPlaceUpdate = true;
    }

    @Override
    public Throwable getRejectedOpOriginalException() {
        return this._cause;
    }

    @Override
    public void setRejectedOpOriginalExceptionAndEntry(Throwable cause, IEntryData rejectedEntry) {
        this._cause = cause;
        this._rejectedEntry = rejectedEntry;
    }

    @Override
    public IEntryData getRejectedOperationEntry() {
        return this._rejectedEntry;
    }

    @Override
    public boolean isSetSingleOperationExtendedErrorInfo() {
        return this.isChangeById();
    }

    @Override
    public Collection<IEntryHolder> getEntriesWaitingForTemplate() {
        return this._waitingFor;
    }

    @Override
    public void addEntryWaitingForTemplate(IEntryHolder entry) {
        if (this._waitingFor == null) {
            this._waitingFor = new HashSet<IEntryHolder>();
        }
        if (!this._waitingFor.contains(entry)) {
            this._waitingFor.add(entry);
        }
        if (this._waitingFor.size() == 1 && !this.isHasWaitingFor()) {
            this.setHasWaitingFor(true);
        }
    }

    @Override
    public void removeEntryWaitingForTemplate(IEntryHolder entry) {
        if (this._waitingFor != null) {
            this._waitingFor.remove(entry);
        }
        if (this._waitingFor != null && this._waitingFor.isEmpty() && this.isHasWaitingFor()) {
            this.setHasWaitingFor(false);
        }
    }

    @Override
    public boolean isBatchOperation() {
        return this._batchOerationContext != null;
    }

    @Override
    public boolean isReadMultiple() {
        return this.isBatchOperation() && this.isReadOperation();
    }

    @Override
    public boolean isTakeMultiple() {
        return this.isBatchOperation() && this.isTakeOperation();
    }

    @Override
    public BatchQueryOperationContext getBatchOperationContext() {
        return this._batchOerationContext;
    }

    @Override
    public void setBatchOperationContext(BatchQueryOperationContext batchOpContext) {
        this._batchOerationContext = batchOpContext;
    }

    @Override
    public boolean canFinishBatchOperation() {
        return this._batchOerationContext.reachedMaxEntries() || this.isInCache() && (this.isIfExist() && !this.isInitialIfExistSearchActive() && !this.isHasWaitingFor() || this._batchOerationContext.reachedMinEntries() && (!this.isIfExist() || !this.isInitialIfExistSearchActive()));
    }

    @Override
    public boolean isChangeMultiple() {
        return this.isBatchOperation() && this.isChange();
    }

    @Override
    public boolean isChangeQuery() {
        return this.isChange() && (this.getCustomQuery() != null || this.getExtendedMatchCodes() != null);
    }

    @Override
    public AbstractProjectionTemplate getProjectionTemplate() {
        return this._projectionTemplate;
    }

    @Override
    public boolean isIdQuery() {
        return this._templateData.isIdQuery();
    }

    @Override
    public boolean isMultipleIdsOperation() {
        return this._multipleIdsContexct != null;
    }

    @Override
    public MultipleIdsContext getMultipleIdsContext() {
        return this._multipleIdsContexct;
    }

    @Override
    public void setMultipleIdsContext(MultipleIdsContext byIdsContext) {
        this._multipleIdsContexct = byIdsContext;
    }

    @Override
    public boolean isUpdateMultiple() {
        return this.isMultipleIdsOperation() && this.isUpdateOperation() && !this.isChange();
    }

    @Override
    public void setOrdinalForEntryByIdMultipleOperation(int ordinal) {
        this._ordinalForMultipleIdsOperation = ordinal;
    }

    @Override
    public int getOrdinalForEntryByIdMultipleOperation() {
        return this._ordinalForMultipleIdsOperation;
    }

    @Override
    public UpdateOrWriteContext getUpfdateOrWriteContext() {
        return this._updateOrWriteContext;
    }

    @Override
    public void setUpdateOrWriteContext(UpdateOrWriteContext ctx) {
        this._updateOrWriteContext = ctx;
    }

    @Override
    public boolean isSameEntryInstance(IEntryHolder other) {
        return this == other;
    }

    @Override
    public boolean isBlobStoreEntry() {
        return false;
    }

    @Override
    public IEntryHolder getOriginalEntryHolder() {
        return this;
    }

    @Override
    public boolean isAllValuesIndexSqlQuery() {
        return this._allValuesIndexSqlQuery;
    }

    @Override
    public boolean isSqlQuery() {
        return this.getCustomQuery() != null || this.getExtendedMatchCodes() != null;
    }

    @Override
    public ILockObject getExternalLockObject() {
        return null;
    }

    @Override
    public boolean isOptimizedForBlobStoreOp(CacheManager cacheManager) {
        if (this._optimizedForBlobStoreOp != null) {
            return this._optimizedForBlobStoreOp;
        }
        this._optimizedForBlobStoreOp = this.isSqlQuery() ? Boolean.valueOf(this.isAllValuesIndexSqlQuery()) : Boolean.valueOf(TemplateHolder.isOptimizedForBlobStoreNonSql(cacheManager, (TemplateEntryData)this.getEntryData(), this.getClassName()));
        return this._optimizedForBlobStoreOp;
    }

    public static boolean isOptimizedForBlobStoreClear(CacheManager cacheManager, ITemplatePacket templatePacket, TemplateEntryData templateEntryData) {
        if (templatePacket.getCustomQuery() != null) {
            return templatePacket.isAllIndexValuesSqlQuery();
        }
        return TemplateHolder.isOptimizedForBlobStoreNonSql(cacheManager, templateEntryData, templatePacket.getTypeName());
    }

    private static boolean isOptimizedForBlobStoreNonSql(CacheManager cacheManager, TemplateEntryData templateEntryData, String typeName) {
        boolean optimized = false;
        if (templateEntryData != null) {
            if (templateEntryData.getFixedPropertiesValues() == null) {
                optimized = true;
            } else {
                TypeData typeData = cacheManager.getTypeData(cacheManager.getEngine().getTypeManager().getServerTypeDesc(typeName));
                optimized = true;
                for (int i = 0; i < templateEntryData.getFixedPropertiesValues().length; ++i) {
                    if (templateEntryData.getFixedPropertiesValues()[i] == null || typeData.getIndexesRelatedFixedProperties()[i]) continue;
                    optimized = false;
                    break;
                }
            }
        } else {
            return true;
        }
        return optimized;
    }

    public SingleExplainPlan getExplainPlan() {
        return this._singleExplainPlan;
    }
}

