/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.server.storage.TemplateHolder;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacket;
import com.gigaspaces.lrmi.nio.IResponseContext;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.XtnEntry;

@InternalApi
public class TemplateHolderFactory {
    protected TemplateHolderFactory() {
    }

    public static ITemplateHolder createEmptyTemplateHolder(SpaceEngine engine, String uid, long expirationTime, boolean isFifo) {
        return new TemplateHolder(engine.getTypeManager().getServerTypeDesc(IServerTypeDesc.ROOT_TYPE_NAME), new TemplatePacket(), uid, expirationTime, null, SystemTime.timeMillis(), 2, null, false, 0, isFifo);
    }

    public static ITemplateHolder createTemplateHolder(IServerTypeDesc typeDesc, ITemplatePacket template, String uid, long expirationTime) {
        return new TemplateHolder(typeDesc, template, uid, expirationTime, null, SystemTime.timeMillis(), 2, null, false, 0, false);
    }

    public static ITemplateHolder createTemplateHolder(IServerTypeDesc typeDesc, ITemplatePacket template, String uid, long expirationTime, XtnEntry xidOriginated, long SCN, int templateOperation, IResponseContext respContext, boolean returnOnlyUid, int operationModifiers, boolean isfifo) {
        return TemplateHolderFactory.createTemplateHolder(typeDesc, template, uid, expirationTime, xidOriginated, SCN, templateOperation, respContext, returnOnlyUid, operationModifiers, isfifo, false);
    }

    public static ITemplateHolder createTemplateHolder(IServerTypeDesc typeDesc, ITemplatePacket template, String uid, long expirationTime, XtnEntry xidOriginated, long SCN, int templateOperation, IResponseContext respContext, boolean returnOnlyUid, int operationModifiers, boolean isfifo, boolean fromReplication) {
        return new TemplateHolder(typeDesc, template, uid, expirationTime, xidOriginated, SCN, templateOperation, respContext, returnOnlyUid, operationModifiers, isfifo, fromReplication);
    }

    public static NotifyTemplateHolder createNotifyTemplateHolder(IServerTypeDesc typeDesc, ITemplatePacket template, String templateUid, long expirationTime, long eventId, NotifyInfo notifyInfo, boolean isFifo) {
        return new NotifyTemplateHolder(typeDesc, template, templateUid, expirationTime, eventId, notifyInfo, isFifo);
    }

    public static ITemplateHolder createUpdateTemplateHolder(IServerTypeDesc typeDesc, IEntryPacket template, String uid, long expirationTime, XtnEntry xidOriginated, long SCN, IResponseContext respContext, int operationModifiers) {
        return new TemplateHolder(typeDesc, template, uid, expirationTime, xidOriginated, SCN, 7, respContext, operationModifiers);
    }

    public static ITemplateHolder createTemplateHolderForReplication(IServerTypeDesc typeDesc, IEntryPacket template, String uid, long expirationTime) {
        return new TemplateHolder(typeDesc, template, uid, expirationTime, null, SystemTime.timeMillis(), 2, null, 0);
    }
}

