/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.EntryTypeDesc;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.ITypeIntrospector;
import com.gigaspaces.internal.server.storage.AbstractEntryData;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.gigaspaces.internal.transport.EntryPacketFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.server.transaction.EntryXtnInfo;
import java.util.Map;
import net.jini.space.InternalSpaceException;

@InternalApi
public class UserTypeEntryData
extends AbstractEntryData {
    private final Object _data;
    private final Object[] _indexedPropertiesValues;

    public UserTypeEntryData(Object data, EntryTypeDesc entryTypeDesc, int version, long expirationTime, boolean createEmptyTxnInfoIfNon) {
        super(entryTypeDesc, version, expirationTime, createEmptyTxnInfoIfNon);
        this._data = data;
        this._indexedPropertiesValues = this.initIndexedPropertiesValues();
    }

    private UserTypeEntryData(Object data, EntryTypeDesc entryTypeDesc, int version, long expirationTime, boolean cloneXtnInfo, AbstractEntryData other, boolean createEmptyTxnInfoIfNon) {
        super(entryTypeDesc, version, expirationTime, cloneXtnInfo, other, createEmptyTxnInfoIfNon);
        this._data = data;
        this._indexedPropertiesValues = this.initIndexedPropertiesValues();
    }

    private UserTypeEntryData(UserTypeEntryData other, EntryXtnInfo xtnInfo) {
        super(other, xtnInfo);
        this._data = other._data;
        this._indexedPropertiesValues = other._indexedPropertiesValues;
    }

    @Override
    public ITransactionalEntryData createCopyWithoutTxnInfo() {
        return new UserTypeEntryData(this._data, this._entryTypeDesc, this._versionID, this._expirationTime, false);
    }

    @Override
    public ITransactionalEntryData createCopyWithoutTxnInfo(long newExpirationTime) {
        return new UserTypeEntryData(this._data, this._entryTypeDesc, this._versionID, newExpirationTime, false);
    }

    @Override
    public ITransactionalEntryData createCopyWithTxnInfo(int newVersion, long newExpirationTime) {
        return new UserTypeEntryData(this._data, this._entryTypeDesc, newVersion, newExpirationTime, true, this, false);
    }

    public ITransactionalEntryData createCopyWithTxnInfo(Object data, boolean createEmptyTxnInfoIfNon) {
        return new UserTypeEntryData(data, this._entryTypeDesc, this._versionID, this._expirationTime, true, this, createEmptyTxnInfoIfNon);
    }

    @Override
    public ITransactionalEntryData createCopyWithTxnInfo(boolean createEmptyTxnInfoIfNon) {
        return new UserTypeEntryData(this._data, this._entryTypeDesc, this._versionID, this._expirationTime, true, this, createEmptyTxnInfoIfNon);
    }

    @Override
    public ITransactionalEntryData createCopy(boolean cloneXtnInfo, IEntryData newEntryData, long newExpirationTime) {
        if (newEntryData instanceof UserTypeEntryData) {
            UserTypeEntryData other = (UserTypeEntryData)newEntryData;
            return new UserTypeEntryData(other._data, other._entryTypeDesc, other._versionID, newExpirationTime, cloneXtnInfo, this, false);
        }
        throw new InternalSpaceException("Unable to create copy of IEntryData - unsupported type " + newEntryData.getClass().getName());
    }

    @Override
    public ITransactionalEntryData createCopyWithSuppliedTxnInfo(EntryXtnInfo ex) {
        return new UserTypeEntryData(this, ex);
    }

    @Override
    public ITransactionalEntryData createShallowClonedCopyWithSuppliedVersion(int versionID) {
        return this.createShallowClonedCopyWithSuppliedVersionAndExpiration(versionID, this.getExpirationTime());
    }

    @Override
    public ITransactionalEntryData createShallowClonedCopyWithSuppliedVersionAndExpiration(int versionID, long expirationTime) {
        IEntryPacket entryPacket = EntryPacketFactory.createFromObject(this._data, this._entryTypeDesc.getTypeDesc(), this._entryTypeDesc.getEntryType(), true);
        Object clonedData = entryPacket.toObject(this._entryTypeDesc.getEntryType());
        this._entryTypeDesc.getIntrospector().setVersion(clonedData, versionID);
        return new UserTypeEntryData(clonedData, this._entryTypeDesc, versionID, expirationTime, false);
    }

    @Override
    public EntryDataType getEntryDataType() {
        return EntryDataType.USER_TYPE;
    }

    public Object getUserObject() {
        return this._data;
    }

    @Override
    public int getNumOfFixedProperties() {
        return this._entryTypeDesc.getTypeDesc().getNumOfFixedProperties();
    }

    @Override
    public Object getFixedPropertyValue(int propertyID) {
        int indexedPropertyID = this._entryTypeDesc.getTypeDesc().getIndexedPropertyID(propertyID);
        return indexedPropertyID == -1 ? this._entryTypeDesc.getIntrospector().getValue(this._data, propertyID) : this._indexedPropertiesValues[indexedPropertyID];
    }

    @Override
    public void setFixedPropertyValue(int propertyID, Object value) {
        this._entryTypeDesc.getIntrospector().setValue(this._data, value, propertyID);
        int indexedPropertyID = this._entryTypeDesc.getTypeDesc().getIndexedPropertyID(propertyID);
        if (indexedPropertyID != -1) {
            this._indexedPropertiesValues[indexedPropertyID] = value;
        }
    }

    @Override
    public void setFixedPropertyValues(Object[] values) {
        if (values.length != this._indexedPropertiesValues.length) {
            throw new IllegalArgumentException("Cannot substitute fixed property values with array of different size!");
        }
        for (int i = 0; i < values.length; ++i) {
            this._indexedPropertiesValues[i] = values[i];
        }
    }

    @Override
    public Object[] getFixedPropertiesValues() {
        Object[] values = this._entryTypeDesc.getIntrospector().getValues(this._data);
        int length = values.length;
        ITypeDesc typeDesc = this._entryTypeDesc.getTypeDesc();
        for (int propertyID = 0; propertyID < length; ++propertyID) {
            int indexedPropertyID = typeDesc.getIndexedPropertyID(propertyID);
            if (indexedPropertyID == -1) continue;
            values[propertyID] = this._indexedPropertiesValues[indexedPropertyID];
        }
        return values;
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return this._entryTypeDesc.getIntrospector().getDynamicProperties(this._data);
    }

    @Override
    public void setDynamicProperties(Map<String, Object> dynamicProperties) {
        this._entryTypeDesc.getIntrospector().setDynamicProperties(this._data, dynamicProperties);
    }

    @Override
    public void setDynamicPropertyValue(String propertyName, Object value) {
        this._entryTypeDesc.getIntrospector().setDynamicProperty(this._data, propertyName, value);
    }

    @Override
    public void unsetDynamicPropertyValue(String propertyName) {
        this._entryTypeDesc.getIntrospector().unsetDynamicProperty(this._data, propertyName);
    }

    private Object[] initIndexedPropertiesValues() {
        ITypeDesc typeDesc = this._entryTypeDesc.getTypeDesc();
        ITypeIntrospector<Object> introspector = this._entryTypeDesc.getIntrospector();
        Object[] result = new Object[typeDesc.getNumOfIndexedProperties()];
        int propertiesLength = typeDesc.getNumOfFixedProperties();
        for (int propertyID = 0; propertyID < propertiesLength; ++propertyID) {
            int indexedPropertyID = typeDesc.getIndexedPropertyID(propertyID);
            if (indexedPropertyID == -1) continue;
            result[indexedPropertyID] = introspector.getValue(this._data, propertyID);
        }
        return result;
    }
}

