/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.service;

import com.gigaspaces.internal.service.ServiceRegistrationException;
import com.gigaspaces.internal.service.ServiceRegistrator;
import com.gigaspaces.lrmi.ILRMIService;
import com.j_spaces.core.service.CountdownModifyAttributesLatchFactory;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.start.ServiceProxyAccessor;
import java.rmi.Remote;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.discovery.DiscoveryListener;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lookup.JoinManager;

public abstract class AbstractGigaSpacesService
implements Remote,
ServiceProxyAccessor,
ILRMIService {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.service");
    public static final long SERVICE_ATTRIBUTE_MODIFY_AWAIT = 10000L;
    private final Uuid _uuid;
    private final LifeCycle _lifeCycle;
    private volatile ServiceRegistrator _serviceRegistrator;
    private final List<Entry> _lookupAttributes;

    protected AbstractGigaSpacesService(LifeCycle lifeCycle) {
        this(lifeCycle, UuidFactory.generate());
    }

    protected AbstractGigaSpacesService(LifeCycle lifeCycle, Uuid serviceUuid) {
        this._lifeCycle = lifeCycle;
        this._uuid = serviceUuid;
        this._lookupAttributes = new ArrayList<Entry>();
    }

    public Uuid getUuid() {
        return this._uuid;
    }

    public LifeCycle getLifeCycle() {
        return this._lifeCycle;
    }

    @Override
    public abstract String getServiceName();

    public JoinManager getJoinManager() {
        return this._serviceRegistrator == null ? null : this._serviceRegistrator.getJoinManager();
    }

    public void addLookupAttributes(Entry[] attributes) {
        try {
            this.addLookupAttributes(attributes, 10000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void addLookupAttributes(Entry[] attributes, long timeoutInMillis) throws InterruptedException {
        boolean advertised;
        if (attributes == null) {
            return;
        }
        JoinManager joinManager = this.getJoinManager();
        if (joinManager == null) {
            Collections.addAll(this._lookupAttributes, attributes);
            advertised = false;
        } else {
            JoinManager.ModifyAttributesLatch latch = joinManager.addAttributes(attributes, false, CountdownModifyAttributesLatchFactory.INSTANCE);
            advertised = latch.await(timeoutInMillis);
        }
        if (!advertised) {
            _logger.warning("active attribute has not yet been advertised");
        }
    }

    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) {
        if (this.getJoinManager() != null) {
            JoinManager.ModifyAttributesLatch latch = this.getJoinManager().modifyAttributes(attrSetTemplates, attrSets, false, CountdownModifyAttributesLatchFactory.INSTANCE);
            try {
                latch.await(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void registerLookupService(String[] lookupGroups, LookupLocator[] lookupLocators, DiscoveryListener listener, boolean useSharedLeaseRenewalManager) throws ServiceRegistrationException {
        if (this._serviceRegistrator != null) {
            return;
        }
        this.AppendInitialLookupAttributes(this._lookupAttributes);
        Entry[] serviceAttributes = this._lookupAttributes.toArray(new Entry[this._lookupAttributes.size()]);
        this._serviceRegistrator = new ServiceRegistrator(lookupGroups, lookupLocators, listener, useSharedLeaseRenewalManager, this, serviceAttributes);
        this._serviceRegistrator.register();
    }

    public void unregisterFromLookupService() {
        if (this._serviceRegistrator != null) {
            this._serviceRegistrator.unregister();
            this._serviceRegistrator = null;
        }
    }

    protected String getServiceTypeDescription() {
        return this.getClass().getName();
    }

    protected void AppendInitialLookupAttributes(List<Entry> lookupAttributes) throws ServiceRegistrationException {
    }

    protected static Exporter getExporter() {
        Exporter exporter;
        block8: {
            exporter = null;
            try {
                exporter = ServiceConfigLoader.getExporter();
            }
            catch (AccessControlException e) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Failed to create exporter.", e);
                }
            }
            catch (SecurityException e) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Failed to create exporter.", e);
                }
            }
            catch (ExceptionInInitializerError e) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Failed to create exporter.", e);
                }
            }
            catch (Throwable e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block8;
                _logger.log(Level.SEVERE, "Failed to create exporter.", e);
            }
        }
        return exporter;
    }
}

