/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.service;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.service.AbstractGigaSpacesService;
import com.gigaspaces.internal.service.ServiceRegistrationException;
import com.j_spaces.core.jini.SharedDiscoveryManagement;
import com.j_spaces.core.jini.SharedLeaseRenewalManager;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.j_spaces.kernel.JSpaceUtilities;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;

@InternalApi
public class ServiceRegistrator {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.service");
    private final String[] _lookupGroups;
    private final LookupLocator[] _lookupLocators;
    private final DiscoveryListener _discoveryListener;
    private final boolean _useSharedLeaseRenewalManager;
    private final AbstractGigaSpacesService _service;
    private final Entry[] _serviceAttributes;
    private volatile boolean _isRegistered;
    private LookupDiscoveryManager _discoveryManager;
    private LeaseRenewalManager _leaseRenewalManager;
    private JoinManager _joinManager;

    public ServiceRegistrator(String[] groups, LookupLocator[] locators, DiscoveryListener listener, boolean useSharedLeaseRenewalManager, AbstractGigaSpacesService service, Entry[] serviceAttributes) {
        this._lookupGroups = groups;
        this._lookupLocators = locators;
        this._discoveryListener = listener;
        this._useSharedLeaseRenewalManager = useSharedLeaseRenewalManager;
        this._service = service;
        this._serviceAttributes = serviceAttributes;
    }

    public synchronized JoinManager getJoinManager() {
        return this._joinManager;
    }

    public boolean isRegistered() {
        return this._isRegistered;
    }

    public synchronized void register() throws ServiceRegistrationException {
        if (this._isRegistered) {
            return;
        }
        try {
            this._discoveryManager = SharedDiscoveryManagement.getLookupDiscoveryManager(this._lookupGroups, this._lookupLocators, this._discoveryListener);
            Object serviceProxy = this._service.getServiceProxy();
            ServiceID serviceId = new ServiceID(this._service.getUuid().getMostSignificantBits(), this._service.getUuid().getLeastSignificantBits());
            boolean useAdvancedConfig = !this._useSharedLeaseRenewalManager;
            Configuration config = this.getConfiguration(useAdvancedConfig);
            this._leaseRenewalManager = this._useSharedLeaseRenewalManager ? SharedLeaseRenewalManager.getLeaseRenewalManager() : new LeaseRenewalManager(config);
            this._joinManager = new JoinManager(serviceProxy, this._serviceAttributes, serviceId, (DiscoveryManagement)this._discoveryManager, this._leaseRenewalManager, config);
            this._isRegistered = true;
            if (_logger.isLoggable(Level.FINE)) {
                String groupsDesc = this._lookupGroups == null ? "[ALL]" : Arrays.asList(this._lookupGroups).toString();
                String locatorsSuffix = this._lookupLocators == null ? "" : "\n[ and Unicast Locators " + Arrays.asList(this._lookupLocators) + "  ]";
                String message = "GigaSpaces Service (Jini Lookup Service): \n[ " + this._service.getServiceTypeDescription() + " <" + this._service.getServiceName() + "> member of " + groupsDesc + " jini lookup groups  ]\n[ Was advertised with serviceID <" + serviceId + "> ]" + locatorsSuffix;
                _logger.log(Level.FINE, message);
            }
        }
        catch (Throwable e) {
            this.unregister();
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to register service: " + e.getMessage(), e);
            }
            throw new ServiceRegistrationException("Failed to register service", e);
        }
    }

    public synchronized void unregister() {
        if (this._joinManager != null) {
            this._joinManager.terminate();
            this._joinManager = null;
        }
        if (this._leaseRenewalManager != null) {
            if (this._useSharedLeaseRenewalManager) {
                SharedLeaseRenewalManager.releaseLeaseRenewalManaer();
            } else {
                this._leaseRenewalManager.terminate();
            }
            this._leaseRenewalManager = null;
        }
        if (this._discoveryManager != null) {
            this._discoveryManager.terminate();
            this._discoveryManager = null;
        }
        this._isRegistered = false;
    }

    private Configuration getConfiguration(boolean isAdvanced) throws ConfigurationException {
        Configuration config;
        block10: {
            JSpaceUtilities.setXMLImplSystemProps();
            config = null;
            try {
                config = isAdvanced ? ServiceConfigLoader.getAdvancedSpaceConfig() : ServiceConfigLoader.getConfiguration();
            }
            catch (AccessControlException e) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Failed to initialize Jini Configuration object", e);
                }
            }
            catch (SecurityException e) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Failed to initialize Jini Configuration object", e);
                }
            }
            catch (ExceptionInInitializerError e) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Failed to initialize Jini Configuration object", e);
                }
            }
            catch (Throwable e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block10;
                _logger.log(Level.SEVERE, "Failed to initialize Jini Configuration object", e);
            }
        }
        if (config != null && isAdvanced) {
            Long renewalDuration = (Long)config.getEntry("net.jini.lookup.JoinManager", "maxLeaseDuration", Long.TYPE);
            Long roundTripTime = (Long)config.getEntry("net.jini.lease.LeaseRenewalManager", "roundTripTime", Long.TYPE);
            if (roundTripTime != null && renewalDuration != null) {
                _logger.log(Level.CONFIG, "The Space JoinManager leasing configuration values are: roundTripTime:" + roundTripTime + " maxLeaseDuration:" + renewalDuration);
            }
        }
        return config;
    }
}

