/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.space.actions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.space.actions.AbstractSpaceActionInfo;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@InternalApi
public class GetTypeDescriptorActionInfo
extends AbstractSpaceActionInfo {
    private static final long serialVersionUID = 1L;
    public String typeName;
    public ITypeDesc resultTypeDescriptor;

    public GetTypeDescriptorActionInfo() {
    }

    public GetTypeDescriptorActionInfo(String typeName) {
        this.typeName = typeName;
    }

    @Override
    protected void writeRequest(ObjectOutput out) throws IOException {
        super.writeRequest(out);
        IOUtils.writeRepetitiveString(out, this.typeName);
    }

    @Override
    protected void readRequest(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readRequest(in);
        this.typeName = IOUtils.readRepetitiveString(in);
    }

    @Override
    protected void writeResponse(ObjectOutput out) throws IOException {
        super.writeResponse(out);
        IOUtils.writeObject(out, this.resultTypeDescriptor);
    }

    @Override
    protected void readResponse(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readResponse(in);
        this.resultTypeDescriptor = (ITypeDesc)IOUtils.readObject(in);
    }

    public GetTypeDescriptorActionInfo reduce(List<AsyncResult<GetTypeDescriptorActionInfo>> results) {
        GetTypeDescriptorActionInfo finalResult = null;
        for (AsyncResult<GetTypeDescriptorActionInfo> result : results) {
            if (result.getException() != null || finalResult != null) continue;
            finalResult = result.getResult();
        }
        if (finalResult == null) {
            finalResult = new GetTypeDescriptorActionInfo(this.typeName);
        }
        return finalResult;
    }
}

