/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.space.requests;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ISwapExternalizable;
import com.gigaspaces.internal.space.requests.AbstractSpaceRequestInfo;
import com.gigaspaces.internal.space.responses.AddTypeIndexesResponseInfo;
import com.gigaspaces.metadata.index.AddTypeIndexesResult;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndex;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@InternalApi
public class AddTypeIndexesRequestInfo
extends AbstractSpaceRequestInfo
implements ISwapExternalizable {
    private static final long serialVersionUID = 1L;
    private String _typeName;
    private SpaceIndex[] _indexes;
    private transient AsyncFutureListener<AddTypeIndexesResult> _listener;

    public AddTypeIndexesRequestInfo() {
    }

    public AddTypeIndexesRequestInfo(String typeName, SpaceIndex[] indexes, AsyncFutureListener<AddTypeIndexesResult> listener) {
        this._typeName = typeName;
        this._indexes = indexes;
        this._listener = listener;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public SpaceIndex[] getIndexes() {
        return this._indexes;
    }

    public AsyncFutureListener<AddTypeIndexesResult> getListener() {
        return this._listener;
    }

    public void setListener(AsyncFutureListener<AddTypeIndexesResult> listener) {
        this._listener = listener;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeRepetitiveString(out, this._typeName);
        if (this._indexes == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this._indexes.length);
            for (int i = 0; i < this._indexes.length; ++i) {
                IOUtils.writeObject(out, this._indexes[i]);
            }
        }
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeRepetitiveString(out, this._typeName);
        if (this._indexes == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this._indexes.length);
            for (int i = 0; i < this._indexes.length; ++i) {
                ISpaceIndex spaceIndex = (ISpaceIndex)this._indexes[i];
                IOUtils.writeSwapExternalizableObject(out, spaceIndex);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._typeName = (String)IOUtils.readRepetitiveObject(in);
        int numOfIndexes = in.readInt();
        if (numOfIndexes >= 0) {
            this._indexes = new ISpaceIndex[numOfIndexes];
            for (int i = 0; i < numOfIndexes; ++i) {
                this._indexes[i] = (SpaceIndex)IOUtils.readObject(in);
            }
        }
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._typeName = (String)IOUtils.readRepetitiveObject(in);
        int numOfIndexes = in.readInt();
        if (numOfIndexes >= 0) {
            this._indexes = new ISpaceIndex[numOfIndexes];
            for (int i = 0; i < numOfIndexes; ++i) {
                ISpaceIndex index = (ISpaceIndex)IOUtils.readSwapExternalizableObject(in);
                this._indexes[i] = index;
            }
        }
    }

    public AddTypeIndexesResult reduce(List<AsyncResult<AddTypeIndexesResult>> results) throws Exception {
        AddTypeIndexesResult finalResult = null;
        for (AsyncResult<AddTypeIndexesResult> result : results) {
            if (result.getException() != null) {
                throw result.getException();
            }
            ITypeDesc[] updatedTypeDescriptors = ((AddTypeIndexesResponseInfo)result.getResult()).getUpdatedTypeDescriptors();
            if (finalResult != null && (updatedTypeDescriptors == null || updatedTypeDescriptors.length <= 0)) continue;
            finalResult = result.getResult();
        }
        return finalResult;
    }
}

