/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.space.requests;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.space.requests.AbstractSpaceRequestInfo;
import com.gigaspaces.internal.space.responses.RegisterReplicationLocalViewResponseInfo;
import com.gigaspaces.internal.transport.ITemplatePacket;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@InternalApi
public class RegisterReplicationLocalViewRequestInfo
extends AbstractSpaceRequestInfo {
    private static final long serialVersionUID = 1L;
    public ITemplatePacket[] templates;
    public RouterStubHolder viewStub;
    public int batchSize;
    public long batchTimeout;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.templates.length);
        for (int i = 0; i < this.templates.length; ++i) {
            IOUtils.writeObject(out, this.templates[i]);
        }
        IOUtils.writeObject(out, this.viewStub);
        out.writeInt(this.batchSize);
        out.writeLong(this.batchTimeout);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int length = in.readInt();
        this.templates = new ITemplatePacket[length];
        for (int i = 0; i < length; ++i) {
            this.templates[i] = (ITemplatePacket)IOUtils.readObject(in);
        }
        this.viewStub = (RouterStubHolder)IOUtils.readObject(in);
        this.batchSize = in.readInt();
        this.batchTimeout = in.readLong();
    }

    public RegisterReplicationLocalViewResponseInfo reduce(List<AsyncResult<RegisterReplicationLocalViewResponseInfo>> results) throws Exception {
        for (AsyncResult<RegisterReplicationLocalViewResponseInfo> result : results) {
            if (result.getException() != null) {
                throw result.getException();
            }
            RegisterReplicationLocalViewResponseInfo responseInfo = result.getResult();
            if (responseInfo.exception == null) continue;
            throw responseInfo.exception;
        }
        return null;
    }
}

