/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.stubcache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.gigaspaces.internal.classloader.IClassLoaderCacheStateListener;
import com.gigaspaces.internal.stubcache.StubId;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class StubCache
implements IClassLoaderCacheStateListener {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi.stubcache");
    private static final int CLEAN_RATE = Integer.getInteger("com.gs.transport_protocol.lrmi.stub-cache.clean-rate", 200000);
    private static final int CACHE_MAX_SIZE = Integer.getInteger("com.gs.transport_protocol.lrmi.stub-cache.size", 10240);
    private int _iteration = 0;
    private final ConcurrentMap<StubId, TouchedItem<Object>> _cachedStubs = new ConcurrentHashMap<StubId, TouchedItem<Object>>();
    private final ConcurrentMap<Long, Set<StubId>> _classLoaderContext = new CopyOnUpdateMap<Long, Set<StubId>>();

    public StubCache() {
        ClassLoaderCache.getCache().registerCacheStateListener(this);
    }

    public Object getStub(StubId id) {
        TouchedItem touchedItem;
        if (++this._iteration % CLEAN_RATE == 0) {
            this.clearStaleEntries();
        }
        if ((touchedItem = (TouchedItem)this._cachedStubs.get(id)) == null) {
            return null;
        }
        Object stub = touchedItem.getItem();
        return stub;
    }

    public synchronized void addStub(StubId id, Object stub) {
        TouchedItem<Object> previousStub;
        if (this._cachedStubs.size() >= CACHE_MAX_SIZE) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("stub cache size reached, clearing the cache");
            }
            this._cachedStubs.clear();
            this._classLoaderContext.clear();
        }
        if ((previousStub = this._cachedStubs.putIfAbsent(id, new TouchedItem<Object>(stub))) == null) {
            Set prevSet;
            Long contextClassLoaderKey = ClassLoaderCache.getCache().putClassLoader(ClassLoaderHelper.getContextClassLoader());
            Set<StubId> set = (ConcurrentHashSet<StubId>)this._classLoaderContext.get(contextClassLoaderKey);
            if (set == null && (prevSet = (Set)this._classLoaderContext.putIfAbsent(contextClassLoaderKey, set = new ConcurrentHashSet<StubId>())) != null) {
                set = prevSet;
            }
            set.add(id);
        }
    }

    public synchronized void clearStaleEntries() {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("clearing stale entries from stub cache");
        }
        ArrayList staleEntries = new ArrayList();
        for (Map.Entry entry : this._cachedStubs.entrySet()) {
            if (((TouchedItem)entry.getValue()).clearTouched()) continue;
            staleEntries.add(entry.getKey());
        }
        if (_logger.isLoggable(Level.FINER)) {
            int staleEntriesCount = staleEntries.size();
            if (staleEntriesCount > 0) {
                _logger.finer("found " + staleEntriesCount + " stale entries in cache, removing them");
            } else {
                _logger.finer("no stale entries found in cache");
            }
        }
        for (StubId id : staleEntries) {
            this._cachedStubs.remove(id);
            for (Set set : this._classLoaderContext.values()) {
                set.remove(id);
            }
        }
    }

    @Override
    public synchronized void onClassLoaderRemoved(Long classLoaderKey, boolean explicit) {
        Set associatedCachedParticipants = (Set)this._classLoaderContext.remove(classLoaderKey);
        if (associatedCachedParticipants != null) {
            for (StubId id : associatedCachedParticipants) {
                this._cachedStubs.remove(id);
            }
        }
    }

    public synchronized void clear() {
        this._cachedStubs.clear();
        this._classLoaderContext.clear();
    }

    private static class TouchedItem<K> {
        private boolean _touched;
        private final K _item;

        public TouchedItem(K item) {
            this._item = item;
            this._touched = true;
        }

        public K getItem() {
            this._touched = true;
            return this._item;
        }

        public boolean clearTouched() {
            boolean result = this._touched;
            this._touched = false;
            return result;
        }
    }
}

