/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.sync.ConsolidationParticipantData;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.SynchronizationSourceDetails;
import com.gigaspaces.transaction.TransactionParticipantMetaData;
import java.util.Arrays;
import java.util.List;

@InternalApi
public class ConsolidationParticipantDataImpl
implements ConsolidationParticipantData,
SynchronizationSourceDetails {
    private final DataSyncOperation[] _dataItems;
    private final TransactionParticipantMetaData _metaData;
    private final IReplicationInContext _context;
    private boolean _aborted;

    public ConsolidationParticipantDataImpl(List<DataSyncOperation> dataItems, TransactionParticipantMetaData metaData, IReplicationInContext context) {
        this._metaData = metaData;
        this._context = context;
        this._dataItems = dataItems.toArray(new DataSyncOperation[dataItems.size()]);
    }

    @Override
    public DataSyncOperation[] getTransactionParticipantDataItems() {
        return this._dataItems;
    }

    @Override
    public TransactionParticipantMetaData getTransactionParticipantMetadata() {
        return this._metaData;
    }

    @Override
    public void commit() {
        this._aborted = false;
    }

    @Override
    public void abort() {
        this._aborted = true;
    }

    public boolean isAborted() {
        return this._aborted;
    }

    public String toString() {
        return "ConsolidationParticipantData [metadata=" + this.getTransactionParticipantMetadata() + " data=" + Arrays.toString(this.getTransactionParticipantDataItems()) + " abort=" + this.isAborted() + "]";
    }

    @Override
    public SynchronizationSourceDetails getSourceDetails() {
        return this;
    }

    @Override
    public String getName() {
        return this._context.getSourceLookupName();
    }
}

