/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.datasource.DataSourceIdQueryImpl;
import com.gigaspaces.datasource.DataSourceIdsQueryImpl;
import com.gigaspaces.datasource.DataSourceQueryImpl;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.datasource.concurrentaccess.SharedIteratorSpaceDataSourceDecorator;
import com.gigaspaces.internal.datasource.EDSAdapterSpaceDataSource;
import com.gigaspaces.internal.datasource.EDSAdapterSynchronizationEndpoint;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.server.storage.EntryHolderFactory;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.sync.OperationsDataBatchImpl;
import com.gigaspaces.internal.sync.TransactionDataImpl;
import com.gigaspaces.internal.sync.hybrid.SyncHybridOperationDetails;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.sync.AddIndexDataImpl;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.DataSyncOperationType;
import com.gigaspaces.sync.IntroduceTypeDataImpl;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.IStorageAdapter;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.sadapter.datasource.BulkDataItem;
import com.j_spaces.sadapter.datasource.DataAdaptorIterator;
import com.j_spaces.sadapter.datasource.DataStorage;
import com.j_spaces.sadapter.datasource.EntryAdapter;
import com.j_spaces.sadapter.datasource.EntryAdapterIterator;
import com.j_spaces.sadapter.datasource.EntryPacketDataConverter;
import com.j_spaces.sadapter.datasource.IDataConverter;
import com.j_spaces.sadapter.datasource.InternalBulkItem;
import com.j_spaces.sadapter.datasource.PartialUpdateBulkDataItem;
import com.j_spaces.sadapter.datasource.SQLQueryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class SynchronizationStorageAdapter
implements IStorageAdapter {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.persistent");
    private final SpaceEngine _engine;
    private final String _spaceName;
    private final SpaceConfigReader _configReader;
    private final EntryDataType _entryDataType;
    private final SpaceTypeManager _typeManager;
    private final boolean _mirrorService;
    private final SpaceSynchronizationEndpoint _syncEndpoint;
    private SpaceDataSource _spaceDataSource;
    private final IDataConverter<IEntryPacket> _converter;
    private final EntryAdapter _conversionAdapter;
    private final SQLQueryBuilder _queryBuilder;
    private final Class<?> _dataClass;
    private final boolean _supportsPartialUpdate;
    private final boolean _centralDataSource;
    private final boolean _supportsInheritance;

    public SynchronizationStorageAdapter(SpaceEngine engine, SpaceDataSource spaceDataSource, SpaceSynchronizationEndpoint synchronizationEndpointInterceptor) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._engine = engine;
        this._spaceDataSource = spaceDataSource;
        this._syncEndpoint = synchronizationEndpointInterceptor;
        this._spaceName = engine.getSpaceName();
        this._configReader = engine.getConfigReader();
        this._entryDataType = engine.getEntryDataType();
        this._typeManager = engine.getTypeManager();
        this._mirrorService = this._configReader.getBooleanSpaceProperty("mirror-service.enabled", "false");
        boolean bl = this._supportsInheritance = this._spaceDataSource != null ? this._spaceDataSource.supportsInheritance() : true;
        if (this._spaceDataSource == null && !this._mirrorService) {
            throw new IllegalArgumentException("Cannot start a persistent space without specifying a SpaceDataSource implementation");
        }
        if (this._mirrorService && this._spaceDataSource != null && !this.isEDSAdapter()) {
            throw new IllegalArgumentException("Cannot start a mirror space since a SpaceDataSource implementation was specified - mirror space only supports SpaceSynchronizationEndpoint specification");
        }
        JSpaceAttributes spaceAttr = engine.getSpaceImpl().getJspaceAttr();
        this._supportsPartialUpdate = spaceAttr.isSupportsPartialUpdateEnabled();
        this._dataClass = ClassLoaderHelper.loadClass(spaceAttr.getDataClass());
        this._queryBuilder = (SQLQueryBuilder)ClassLoaderHelper.loadClass(spaceAttr.getQueryBuilderClass()).newInstance();
        this._converter = new EntryPacketDataConverter(this._typeManager, this._dataClass);
        this._conversionAdapter = new EntryAdapter(this._converter);
        this._centralDataSource = engine.getClusterPolicy() != null ? engine.getClusterPolicy().m_CacheLoaderConfig.centralDataSource : false;
    }

    @Override
    public void initialize() throws SAException {
        try {
            this.initOldDataStorage();
            this.initializeSharedModeIteratorIfNecessary();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.throwing(this.getClass().getName(), "Initialize", e);
            }
            throw new SAException(e);
        }
    }

    private void initializeSharedModeIteratorIfNecessary() {
        boolean shareIteratorMode = this._engine.getSpaceImpl().getJspaceAttr().getDataSourceSharedIteratorMode();
        if (this._spaceDataSource == null || !shareIteratorMode) {
            return;
        }
        long leaseManagerExpirationTimeRecentDeletes = this._configReader.getLongSpaceProperty("lease_manager.expiration_time_recent_deletes", String.valueOf(180000L));
        long leaseManagerExpirationTimeRecentUpdates = this._configReader.getLongSpaceProperty("lease_manager.expiration_time_recent_updates", String.valueOf(180000L));
        long sharedIteratorTimeToLive = this._engine.getSpaceImpl().getJspaceAttr().getDataSourceSharedIteratorTimeToLive();
        long warnThreshold = (long)((double)Math.min(leaseManagerExpirationTimeRecentDeletes, leaseManagerExpirationTimeRecentUpdates) * 0.8);
        if (shareIteratorMode && sharedIteratorTimeToLive > warnThreshold) {
            _logger.warning("shared iterator time to live [" + sharedIteratorTimeToLive + "] exceeds lease manager expiration time of recent deletes or recent updates threshold [" + warnThreshold + "], this can cause correctness issues. ");
        }
        this._spaceDataSource = new SharedIteratorSpaceDataSourceDecorator(this._spaceDataSource, sharedIteratorTimeToLive);
    }

    private void initOldDataStorage() throws SAException, DataSourceException {
        DataStorage<Object> dataStorage = this.getOldEDSDataStorage();
        if (dataStorage == null || !dataStorage.isManagedDataSource()) {
            return;
        }
        Properties dataProperties = new Properties();
        dataProperties.put("external-data-source.data-class", this._dataClass.getName());
        dataProperties.put("com.gigaspaces.datasource.number-of-partitions", (Object)this._engine.getNumberOfPartitions());
        dataProperties.put("com.gigaspaces.datasource.partition-number", (Object)this._engine.getPartitionIdOneBased());
        String dataPropertiesFile = this._engine.getSpaceImpl().getJspaceAttr().getDataPropertiesFile();
        if (dataPropertiesFile != null && dataPropertiesFile.trim().length() != 0) {
            try {
                InputStream is = ResourceLoader.getResourceStream(dataPropertiesFile);
                if (is == null) {
                    throw new FileNotFoundException("Failed to find resource: " + dataPropertiesFile);
                }
                dataProperties.load(is);
            }
            catch (IOException e) {
                throw new SAException(e);
            }
        }
        dataStorage.init(dataProperties);
    }

    @Override
    public ISAdapterIterator<?> initialLoad(Context context, ITemplateHolder template) throws SAException {
        if (template.isTransient() || this._mirrorService) {
            return null;
        }
        DataIterator<SpaceTypeDescriptor> metadataIterator = this._spaceDataSource.initialMetadataLoad();
        if (metadataIterator != null) {
            try {
                while (metadataIterator.hasNext()) {
                    ITypeDesc typeDescriptor = (ITypeDesc)metadataIterator.next();
                    String[] superClassesNames = typeDescriptor.getRestrictSuperClassesNames();
                    if (superClassesNames != null) {
                        for (String superClassName : superClassesNames) {
                            if (this._typeManager.getServerTypeDesc(superClassName) != null) continue;
                            throw new IllegalArgumentException("Missing super class type descriptor [" + superClassName + "] for type [" + typeDescriptor.getTypeName() + "]");
                        }
                    }
                    this._typeManager.addTypeDesc(typeDescriptor);
                }
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.throwing(this.getClass().getName(), "Initial Metadata Load", e);
                }
                throw new SAException(e);
            }
        }
        try {
            DataAdaptorIterator cacheAdapterIterator = new DataAdaptorIterator(this._typeManager, this._entryDataType);
            DataIterator<Object> iterator = this._spaceDataSource.initialDataLoad();
            if (iterator != null) {
                EntryAdapterIterator entryAdapterIterator = new EntryAdapterIterator(iterator, new EntryAdapter(this._converter));
                cacheAdapterIterator.add(entryAdapterIterator);
            }
            return cacheAdapterIterator;
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.throwing(this.getClass().getName(), "Initial Load", e);
            }
            throw new SAException(e);
        }
    }

    @Override
    public void insertEntry(Context context, IEntryHolder entryHolder, boolean origin, boolean shouldReplicate) throws SAException {
        try {
            if (!this.isPersistable(entryHolder, origin)) {
                return;
            }
            ITypeDesc typeDescriptor = this.getType(entryHolder.getClassName());
            BulkDataItem operation = new BulkDataItem(entryHolder, typeDescriptor, 3, this._converter);
            if (this._engine.getCacheManager().isSyncHybrid()) {
                this.injectSyncHybridOperationsDetails(context, new DataSyncOperation[]{operation});
            }
            this._syncEndpoint.onOperationsBatchSynchronization(new OperationsDataBatchImpl(operation, this._spaceName));
        }
        catch (Throwable t) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.throwing(this.getClass().getName(), "Insert Entry", t);
            }
            throw new SAException(t);
        }
    }

    private boolean isPersistable(IEntryHolder entryHolder, boolean origin) {
        if (this.isReadOnly() || entryHolder.isTransient()) {
            return false;
        }
        return origin || !this._centralDataSource;
    }

    @Override
    public void updateEntry(Context context, IEntryHolder updatedEntry, boolean updateRedoLog, boolean origin, boolean[] partialUpdateValuesIndicators) throws SAException {
        if (!this.isPersistable(updatedEntry, origin)) {
            return;
        }
        ITypeDesc typeDescriptor = this.getType(updatedEntry.getClassName());
        BulkDataItem operation = partialUpdateValuesIndicators != null && partialUpdateValuesIndicators.length > 0 && this._supportsPartialUpdate ? new PartialUpdateBulkDataItem(updatedEntry, partialUpdateValuesIndicators, typeDescriptor, this._converter) : new BulkDataItem(updatedEntry, typeDescriptor, 2, this._converter);
        if (this._engine.getCacheManager().isSyncHybrid()) {
            this.injectSyncHybridOperationsDetails(context, new DataSyncOperation[]{operation});
        }
        this._syncEndpoint.onOperationsBatchSynchronization(new OperationsDataBatchImpl(operation, this._spaceName));
    }

    @Override
    public void removeEntry(Context context, IEntryHolder entryHolder, boolean origin, boolean fromLeaseExpiration, boolean shouldReplicate) throws SAException {
        try {
            if (!this.isPersistable(entryHolder, origin) || fromLeaseExpiration) {
                return;
            }
            ITypeDesc typeDescriptor = this.getType(entryHolder.getClassName());
            BulkDataItem operation = new BulkDataItem(entryHolder, typeDescriptor, 1, this._converter);
            if (this._engine.getCacheManager().isSyncHybrid()) {
                this.injectSyncHybridOperationsDetails(context, new DataSyncOperation[]{operation});
            }
            this._syncEndpoint.onOperationsBatchSynchronization(new OperationsDataBatchImpl(operation, this._spaceName));
        }
        catch (Throwable t) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.throwing(this.getClass().getName(), "Remove Entry", t);
            }
            throw new SAException(t);
        }
    }

    @Override
    public void prepare(Context context, ServerTransaction xtn, ArrayList<IEntryHolder> pLocked, boolean singleParticipant, Map<String, Object> partialUpdatesAndInPlaceUpdatesInfo, boolean shouldReplicate) throws SAException {
        if (this.isReadOnly()) {
            return;
        }
        try {
            ArrayList<BulkDataItem> operations = new ArrayList<BulkDataItem>(pLocked.size());
            block6: for (IEntryHolder entryHolder : pLocked) {
                if (entryHolder == null || entryHolder.isDeleted() || entryHolder.isTransient() || entryHolder.getWriteLockTransaction() == null || !entryHolder.getWriteLockTransaction().equals((Object)xtn)) continue;
                if (this._centralDataSource && entryHolder.getTxnEntryData().getWriteLockOwner().isFromReplication()) break;
                ITypeDesc typeDescriptor = this.getType(entryHolder.getClassName());
                switch (entryHolder.getWriteLockOperation()) {
                    case 1: {
                        operations.add(new BulkDataItem(entryHolder, typeDescriptor, 3, this._converter));
                        continue block6;
                    }
                    case 7: {
                        boolean[] partialUpdateValuesIndicators;
                        Object updateInfo = partialUpdatesAndInPlaceUpdatesInfo != null ? partialUpdatesAndInPlaceUpdatesInfo.get(entryHolder.getUID()) : null;
                        boolean[] blArray = partialUpdateValuesIndicators = updateInfo != null && updateInfo instanceof boolean[] ? (boolean[])updateInfo : null;
                        if (partialUpdateValuesIndicators != null && partialUpdateValuesIndicators.length > 0 && this.supportsPartialUpdate()) {
                            operations.add(new PartialUpdateBulkDataItem(entryHolder, partialUpdateValuesIndicators, typeDescriptor, this._converter));
                            continue block6;
                        }
                        operations.add(new BulkDataItem(entryHolder, typeDescriptor, 2, this._converter));
                        continue block6;
                    }
                }
                operations.add(new BulkDataItem(entryHolder, typeDescriptor, 1, this._converter));
            }
            if (!operations.isEmpty()) {
                if (this._engine.getCacheManager().isSyncHybrid()) {
                    this.injectSyncHybridOperationsDetails(context, operations.toArray(new DataSyncOperation[operations.size()]));
                }
                this._syncEndpoint.onTransactionSynchronization(new TransactionDataImpl(operations.toArray(new DataSyncOperation[operations.size()]), xtn.getMetaData(), this._spaceName));
            }
        }
        catch (Throwable t) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.throwing(this.getClass().getName(), "Prepare", t);
            }
            throw new SAException(t);
        }
    }

    @Override
    public void rollback(ServerTransaction xtn, boolean anyUpdates) throws SAException {
    }

    @Override
    public boolean supportsGetEntries() {
        return true;
    }

    @Override
    public Map<String, IEntryHolder> getEntries(Context context, Object[] ids, String typeName, IEntryHolder[] templates) throws SAException {
        try {
            Map<String, IEntryHolder> results = Collections.emptyMap();
            IServerTypeDesc serverTypeDesc = this.getServerType(typeName);
            ITypeDesc typeDescriptor = serverTypeDesc.getTypeDesc();
            DataIterator<Object> dataSourceResults = this._spaceDataSource.getDataIteratorByIds(new DataSourceIdsQueryImpl(typeDescriptor, ids, templates, this._queryBuilder, this._dataClass, this._converter));
            if (dataSourceResults == null) {
                return results;
            }
            while (dataSourceResults.hasNext()) {
                Object dataSourceResult = dataSourceResults.next();
                IEntryPacket entryPacket = this._conversionAdapter.toEntry(dataSourceResult);
                IEntryHolder entryHolder = EntryHolderFactory.createEntryHolder(serverTypeDesc, entryPacket, this._entryDataType);
                if (this._engine.isPartitionedSpace() && !this._engine.isEntryFromPartition(entryHolder)) continue;
                if (results.isEmpty()) {
                    results = new HashMap<String, IEntryHolder>();
                }
                results.put(entryHolder.getUID(), entryHolder);
            }
            return results;
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.throwing(this.getClass().getName(), "Get Entries", e);
            }
            throw new SAException(e);
        }
    }

    @Override
    public IEntryHolder getEntry(Context context, Object uid, String typeName, IEntryHolder template) throws SAException {
        return this.getEntry_impl(uid, typeName, template);
    }

    private IEntryHolder getEntry_impl(Object uid, String typeName, IEntryHolder template) throws SAException {
        try {
            IServerTypeDesc serverTypeDesc = this.getServerType(typeName);
            ITypeDesc typeDescriptor = serverTypeDesc.getTypeDesc();
            EntryAdapter entryAdapter = new EntryAdapter(template, typeDescriptor, this._converter);
            DataSourceIdQueryImpl idQuery = new DataSourceIdQueryImpl(typeDescriptor, entryAdapter.toEntryPacket(), this._queryBuilder, this._dataClass, entryAdapter);
            Object result = this._spaceDataSource.getById(idQuery);
            if (result == null) {
                return null;
            }
            IEntryPacket entryPacket = entryAdapter.toEntry(result);
            IServerTypeDesc serverTypeDescriptor = this._typeManager.loadServerTypeDesc(entryPacket);
            IEntryHolder holder = EntryHolderFactory.createEntryHolder(serverTypeDescriptor, entryPacket, this._entryDataType);
            if (this._engine.isPartitionedSpace() && !this._engine.isEntryFromPartition(holder)) {
                return null;
            }
            return holder;
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.throwing(this.getClass().getName(), "Get Entry", e);
            }
            throw new SAException(e);
        }
    }

    @Override
    public ISAdapterIterator<IEntryHolder> makeEntriesIter(ITemplateHolder template, long SCNFilter, long leaseFilter, IServerTypeDesc[] subTypes) throws SAException {
        try {
            if (template.isTransient() || this._mirrorService) {
                return null;
            }
            if (template.isIdQuery()) {
                final IEntryHolder idQueryResult = this.getEntry_impl(template.getUID(), template.getClassName(), template);
                if (idQueryResult == null) {
                    return null;
                }
                return new ISAdapterIterator<IEntryHolder>(){
                    private IEntryHolder holder;
                    {
                        this.holder = idQueryResult;
                    }

                    @Override
                    public IEntryHolder next() {
                        if (this.holder == null) {
                            return null;
                        }
                        IEntryHolder result = this.holder;
                        this.holder = null;
                        return result;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
            DataAdaptorIterator cacheAdapterIterator = new DataAdaptorIterator(this._typeManager, this._entryDataType);
            ITypeDesc typeDescriptor = this.getType(template.getClassName());
            EntryAdapter entry = new EntryAdapter(template, typeDescriptor, this._converter);
            if (this._supportsInheritance) {
                this.createDataSourceIteratorForType(template, cacheAdapterIterator, entry, typeDescriptor);
            } else {
                for (int i = 0; i < subTypes.length; ++i) {
                    String typeName = subTypes[i].getTypeName();
                    ITypeDesc typeDesc = this.getType(typeName);
                    this.createDataSourceIteratorForType(template, cacheAdapterIterator, entry, typeDesc);
                }
            }
            return cacheAdapterIterator;
        }
        catch (Throwable t) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.throwing(SynchronizationStorageAdapter.class.getName(), "Entries Iterator", t);
            }
            throw new SAException(t);
        }
    }

    private void createDataSourceIteratorForType(ITemplateHolder template, DataAdaptorIterator cacheAdapterIterator, EntryAdapter entryAdapter, ITypeDesc typeDescriptor) {
        int maxResults = template.isBatchOperation() ? template.getBatchOperationContext().getMaxEntries() : 1;
        DataSourceQueryImpl dataSourceQuery = new DataSourceQueryImpl(template, typeDescriptor, this._dataClass, this._queryBuilder, entryAdapter, maxResults);
        DataIterator<Object> dataIterator = this._spaceDataSource.getDataIterator(dataSourceQuery);
        if (dataIterator != null) {
            EntryAdapterIterator entryAdapterIterator = new EntryAdapterIterator(dataIterator, new EntryAdapter(this._converter));
            cacheAdapterIterator.add(entryAdapterIterator);
        }
    }

    private ITypeDesc getType(String typeName) {
        IServerTypeDesc serverTypeDesc = this._typeManager.getServerTypeDesc(typeName);
        return serverTypeDesc != null ? serverTypeDesc.getTypeDesc() : null;
    }

    private IServerTypeDesc getServerType(String typeName) {
        return this._typeManager.getServerTypeDesc(typeName);
    }

    @Override
    public void commit(ServerTransaction xtn, boolean anyUpdates) throws SAException {
    }

    @Override
    public int count(ITemplateHolder template, String[] subClasses) throws SAException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutDown() throws SAException {
        DataStorage<Object> dataStorage = this.getOldEDSDataStorage();
        if (dataStorage != null && dataStorage.isManagedDataSource()) {
            try {
                dataStorage.shutdown();
            }
            catch (DataSourceException e) {
                throw new SAException(e);
            }
        }
        if (this._spaceDataSource instanceof SharedIteratorSpaceDataSourceDecorator) {
            SharedIteratorSpaceDataSourceDecorator sharedIteratorSpaceDataSourceDecorator = (SharedIteratorSpaceDataSourceDecorator)this._spaceDataSource;
            try {
                sharedIteratorSpaceDataSourceDecorator.shutdown();
            }
            catch (DataSourceException e) {
                throw new SAException(e);
            }
        }
    }

    private boolean isEDSAdapter() {
        return this.getOldEDSDataStorage() != null;
    }

    private DataStorage<Object> getOldEDSDataStorage() {
        if (this._spaceDataSource != null && this._spaceDataSource instanceof EDSAdapterSpaceDataSource) {
            EDSAdapterSpaceDataSource edsAdapterSpaceDataSource = (EDSAdapterSpaceDataSource)this._spaceDataSource;
            return edsAdapterSpaceDataSource.getDataStorage();
        }
        if (this._syncEndpoint != null && this._syncEndpoint instanceof EDSAdapterSynchronizationEndpoint) {
            EDSAdapterSynchronizationEndpoint edsInterceptor = (EDSAdapterSynchronizationEndpoint)this._syncEndpoint;
            return edsInterceptor.getDataStorage();
        }
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return this._syncEndpoint == null;
    }

    @Override
    public boolean supportsExternalDB() {
        return true;
    }

    @Override
    public boolean supportsPartialUpdate() {
        return this._supportsPartialUpdate;
    }

    @Override
    public void introduceDataType(ITypeDesc typeDesc) {
        if (this._syncEndpoint != null) {
            this._syncEndpoint.onIntroduceType(new IntroduceTypeDataImpl(typeDesc));
        }
    }

    @Override
    public void addIndexes(String typeName, SpaceIndex[] indexes) {
        if (this._syncEndpoint != null) {
            this._syncEndpoint.onAddIndex(new AddIndexDataImpl(typeName, indexes));
        }
    }

    @Override
    public SpaceSynchronizationEndpoint getSynchronizationInterceptor() {
        return this._syncEndpoint;
    }

    @Override
    public Class<?> getDataClass() {
        return this._dataClass;
    }

    private void injectSyncHybridOperationsDetails(Context ctx, DataSyncOperation[] operations) {
        SyncHybridOperationDetails[] syncHybridOperationsDetails = new SyncHybridOperationDetails[operations.length];
        for (int i = 0; i < operations.length; ++i) {
            DataSyncOperationType dataSyncOperationType = operations[i].getDataSyncOperationType();
            IEntryPacket entryPacket = ((InternalBulkItem)operations[i]).toEntryPacket();
            syncHybridOperationsDetails[i] = new SyncHybridOperationDetails(this._spaceName, dataSyncOperationType, entryPacket);
        }
        ctx.setSyncHybridOperationDetails(syncHybridOperationsDetails);
    }
}

