/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.SynchronizationSourceDetails;
import com.gigaspaces.sync.TransactionData;
import com.gigaspaces.transaction.ConsolidatedDistributedTransactionMetaData;
import com.gigaspaces.transaction.TransactionParticipantMetaData;
import net.jini.core.transaction.server.TransactionParticipantDataImpl;

@InternalApi
public class TransactionDataImpl
implements TransactionData {
    private final DataSyncOperation[] _operations;
    private final TransactionParticipantDataImpl _metaData;
    private String _sourceName;

    public TransactionDataImpl(DataSyncOperation[] operations, TransactionParticipantDataImpl metaData, String sourceName) {
        this._operations = operations;
        this._metaData = metaData;
        this._sourceName = sourceName;
    }

    @Override
    public boolean isConsolidated() {
        return !this._metaData.isUnconsoliated();
    }

    @Override
    public TransactionParticipantMetaData getTransactionParticipantMetaData() {
        return this._metaData;
    }

    @Override
    public ConsolidatedDistributedTransactionMetaData getConsolidatedDistributedTransactionMetaData() {
        if (!this.isConsolidated()) {
            throw new IllegalStateException("Cannot get consolidated distributed transaction meta data for an unconsolidated transaction");
        }
        return this._metaData;
    }

    @Override
    public DataSyncOperation[] getTransactionParticipantDataItems() {
        return this._operations;
    }

    @Override
    public SynchronizationSourceDetails getSourceDetails() {
        return new SynchronizationSourceDetails(){

            @Override
            public String getName() {
                return TransactionDataImpl.this._sourceName;
            }
        };
    }
}

